/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public final class NullType
extends ValueType {
    NullType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    JSTypeClass getTypeClass() {
        return JSTypeClass.NULL;
    }

    @Override
    public boolean isNullType() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public JSType restrictByNotNull() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public Tri testForEquality(JSType that) {
        Tri result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isNullType() || that.isVoidType()) {
            return Tri.TRUE;
        }
        if (that.isUnknownType() || that.isNullable()) {
            return Tri.UNKNOWN;
        }
        return Tri.FALSE;
    }

    @Override
    public String getDisplayName() {
        return "null";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.FALSE;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNullType();
    }
}

