/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class EnumType
extends PrototypeObjectType
implements JSType.WithSourceRef {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.ENUM;
    private EnumElementType elementType;
    private final Set<String> elements = new LinkedHashSet<String>();
    private final Node source;
    private final String googModuleId;

    public static Builder builder(JSTypeRegistry registry) {
        return new Builder(registry);
    }

    private EnumType(Builder builder) {
        super(builder);
        this.elementType = new EnumElementType(builder.registry, builder.elementType, builder.elementName, this);
        this.source = builder.source;
        this.googModuleId = builder.googModuleId;
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean defineElement(String name, Node definingNode) {
        this.elements.add(name);
        return this.defineDeclaredProperty(name, this.elementType, definingNode);
    }

    public EnumElementType getElementsType() {
        return this.elementType;
    }

    @Override
    public JSType getEnumeratedTypeOfEnumObject() {
        return this.elementType.getPrimitiveType();
    }

    @Override
    public Tri testForEquality(JSType that) {
        Tri result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        return this.equals(that) ? Tri.TRUE : Tri.FALSE;
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        sb.append(sb.isForAnnotations() ? "!Object" : this.getReferenceName());
    }

    @Override
    public String getDisplayName() {
        return this.elementType.getDisplayName();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    @Override
    public @Nullable FunctionType getConstructor() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public final Node getSource() {
        return this.source;
    }

    @Override
    public @Nullable String getGoogModuleId() {
        return this.googModuleId;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.elementType = (EnumElementType)this.elementType.resolve(reporter);
        return super.resolveInternal(reporter);
    }

    public static final class Builder
    extends PrototypeObjectType.Builder<Builder> {
        private String elementName;
        private Node source;
        private String googModuleId;
        private JSType elementType;

        private Builder(JSTypeRegistry registry) {
            super(registry);
        }

        @Override
        public Builder setName(String x) {
            super.setName("enum{" + x + "}");
            this.elementName = x;
            return this;
        }

        public Builder setSource(Node x) {
            this.source = x;
            return this;
        }

        public Builder setGoogModuleId(String x) {
            this.googModuleId = x;
            return this;
        }

        public Builder setElementType(JSType x) {
            this.elementType = x;
            return this;
        }

        @Override
        public EnumType build() {
            return new EnumType(this);
        }
    }
}

