/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.nullness.Nullable;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String IMPLICIT_TEMPLATE_BOUND_SOURCE = "<IMPLICIT_TEMPLATE_BOUND>";
    static final JSTypeExpression IMPLICIT_TEMPLATE_BOUND = new JSTypeExpression(new Node(Token.QMARK), "<IMPLICIT_TEMPLATE_BOUND>");
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node root, String sourceName) {
        this.root = root;
        this.sourceName = sourceName;
    }

    public JSTypeExpression replaceNamesWithUnknownType(Set<String> names) {
        Node oldExprRoot = this.root.cloneTree();
        Node newExprRoot = JSTypeExpression.replaceNames(oldExprRoot, names);
        JSTypeExpression newTypeExpression = new JSTypeExpression(newExprRoot, this.sourceName);
        return newTypeExpression;
    }

    private static @Nullable Node replaceNames(Node n, Set<String> names) {
        if (n == null) {
            return null;
        }
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            JSTypeExpression.replaceNames(child, names);
            child = next;
        }
        if (n.isStringLit() && names.contains(n.getString())) {
            Node qMark = new Node(Token.QMARK);
            qMark.addChildrenToBack(n.removeChildren());
            if (n.hasParent()) {
                n.replaceWith(qMark);
            }
            return qMark;
        }
        return n;
    }

    public ImmutableList<Node> getAllTypeNodes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        JSTypeExpression.visitAllTypeNodes(this.root, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public ImmutableSet<String> getAllTypeNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JSTypeExpression.visitAllTypeNodes(this.root, n -> builder.add((Object)n.getString()));
        return builder.build();
    }

    private static void visitAllTypeNodes(Node n, Consumer<Node> visitor) {
        if (n == null) {
            return;
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            JSTypeExpression.visitAllTypeNodes(child, visitor);
        }
        if (n.isStringLit()) {
            visitor.accept(n);
        }
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression expr) {
        if (expr.isOptionalArg() || expr.isVarArgs()) {
            return expr;
        }
        Node equals = new Node(Token.EQUALS, expr.root);
        equals.clonePropsFrom(expr.root);
        return new JSTypeExpression(equals, expr.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getToken() == Token.EQUALS;
    }

    public boolean isVarArgs() {
        return this.root.getToken() == Token.ITER_REST;
    }

    public JSType evaluate(@Nullable StaticTypedScope scope, JSTypeRegistry registry) {
        JSType type = registry.createTypeFromCommentNode(this.root, this.sourceName, scope);
        this.root.setJSType(type);
        return type;
    }

    public boolean isEquivalentTo(@Nullable JSTypeExpression other) {
        return other != null && this.root.isEquivalentTo(other.root);
    }

    public Node getRoot() {
        return this.root;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return "type: " + this.root.toStringTree();
    }

    public JSTypeExpression copy() {
        return new JSTypeExpression(this.root.cloneTree(), this.sourceName);
    }

    public boolean isExplicitUnknownTemplateBound() {
        return JSCompObjects.identical((Object)this.root.getToken(), (Object)Token.QMARK) && !this.root.hasChildren() && !this.sourceName.equals(IMPLICIT_TEMPLATE_BOUND_SOURCE);
    }

    public ImmutableSet<String> getRecordPropertyNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JSTypeExpression.getRecordPropertyNamesRecursive(this.root, (ImmutableSet.Builder<String>)builder);
        return builder.build();
    }

    private static void getRecordPropertyNamesRecursive(Node n, ImmutableSet.Builder<String> names) {
        if (n == null) {
            return;
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            JSTypeExpression.getRecordPropertyNamesRecursive(child, names);
        }
        if (n.isStringKey()) {
            names.add((Object)n.getString());
        }
    }

    static {
        IMPLICIT_TEMPLATE_BOUND.getRoot().setStaticSourceFile(new SimpleSourceFile(IMPLICIT_TEMPLATE_BOUND_SOURCE, StaticSourceFile.SourceKind.STRONG));
    }
}

