/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import org.jspecify.nullness.Nullable;

public abstract class ChainableReverseAbstractInterpreter
implements ReverseAbstractInterpreter {
    final JSTypeRegistry typeRegistry;
    private ChainableReverseAbstractInterpreter firstLink;
    private @Nullable ChainableReverseAbstractInterpreter nextLink;
    final Visitor<JSType> restrictToArrayVisitor = new RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType topType) {
            return topType.isAllType() ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE) : topType;
        }

        @Override
        public @Nullable JSType caseObjectType(ObjectType type) {
            JSType arrayType = ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE);
            return arrayType.isSubtypeOf(type) ? arrayType : null;
        }
    };
    final Visitor<JSType> restrictToNotArrayVisitor = new RestrictByFalseTypeOfResultVisitor(){

        @Override
        public @Nullable JSType caseObjectType(ObjectType type) {
            return type.isSubtypeOf(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE)) ? null : type;
        }
    };

    public ChainableReverseAbstractInterpreter(JSTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
        this.firstLink = this;
        this.nextLink = null;
    }

    public ChainableReverseAbstractInterpreter append(ChainableReverseAbstractInterpreter lastLink) {
        Preconditions.checkArgument((lastLink.nextLink == null ? 1 : 0) != 0);
        this.nextLink = lastLink;
        lastLink.firstLink = this.firstLink;
        return lastLink;
    }

    public ChainableReverseAbstractInterpreter getFirst() {
        return this.firstLink;
    }

    protected FlowScope firstPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, Outcome outcome) {
        return this.firstLink.getPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    protected FlowScope nextPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, Outcome outcome) {
        return this.nextLink != null ? this.nextLink.getPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome) : blindScope;
    }

    protected @Nullable JSType getTypeIfRefinable(Node node, FlowScope scope) {
        switch (node.getToken()) {
            case NAME: {
                StaticTypedSlot nameVar = scope.getSlot(node.getString());
                if (nameVar != null) {
                    JSType nameVarType = nameVar.getType();
                    if (nameVarType == null) {
                        nameVarType = node.getJSType();
                    }
                    return nameVarType;
                }
                return null;
            }
            case GETPROP: {
                String qualifiedName = node.getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                StaticTypedSlot propVar = scope.getSlot(qualifiedName);
                JSType propVarType = null;
                if (propVar != null) {
                    propVarType = propVar.getType();
                }
                if (propVarType == null) {
                    propVarType = node.getJSType();
                }
                if (propVarType == null) {
                    propVarType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return propVarType;
            }
        }
        return null;
    }

    @CheckReturnValue
    protected FlowScope declareNameInScope(FlowScope scope, Node node, JSType type) {
        switch (node.getToken()) {
            case NAME: {
                return scope.inferSlotType(node.getString(), type);
            }
            case GETPROP: {
                String qualifiedName = node.getQualifiedName();
                Preconditions.checkNotNull((Object)qualifiedName);
                JSType origType = node.getJSType();
                origType = origType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : origType;
                return scope.inferQualifiedSlot(node, qualifiedName, origType, type, false);
            }
            case THIS: {
                return scope;
            }
        }
        throw new IllegalArgumentException("Node cannot be refined. \n" + node.toStringTree());
    }

    @Nullable JSType getRestrictedByTypeOfResult(JSType type, String value, boolean resultEqualsValue) {
        if (type == null) {
            if (resultEqualsValue) {
                JSType result = this.getNativeTypeForTypeOf(value);
                return result == null ? this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE) : result;
            }
            return null;
        }
        return type.visit(new RestrictByOneTypeOfResultVisitor(value, resultEqualsValue));
    }

    JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private @Nullable JSType getNativeTypeForTypeOf(String value) {
        switch (value) {
            case "number": {
                return this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            case "boolean": {
                return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            case "string": {
                return this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            case "symbol": {
                return this.getNativeType(JSTypeNative.SYMBOL_TYPE);
            }
            case "undefined": {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case "object": {
                return this.typeRegistry.createUnionType(this.getNativeType(JSTypeNative.OBJECT_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
            }
            case "function": {
                return this.getNativeType(JSTypeNative.FUNCTION_TYPE);
            }
        }
        return null;
    }

    private class RestrictByOneTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        private final String value;
        private final boolean resultEqualsValue;

        RestrictByOneTypeOfResultVisitor(String value, boolean resultEqualsValue) {
            this.value = value;
            this.resultEqualsValue = resultEqualsValue;
        }

        private boolean matchesExpectation(String result) {
            return result.equals(this.value) == this.resultEqualsValue;
        }

        @Override
        protected JSType caseTopType(JSType topType) {
            JSType typeByName;
            JSType result = topType;
            if (this.resultEqualsValue && (typeByName = ChainableReverseAbstractInterpreter.this.getNativeTypeForTypeOf(this.value)) != null) {
                result = typeByName;
            }
            return result;
        }

        @Override
        public @Nullable JSType caseNoObjectType() {
            return (this.value.equals("object") || this.value.equals("function")) == this.resultEqualsValue ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseBooleanType() {
            return this.matchesExpectation("boolean") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseFunctionType(FunctionType type) {
            return this.matchesExpectation("function") ? type : null;
        }

        @Override
        public @Nullable JSType caseNullType() {
            return this.matchesExpectation("object") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseNumberType() {
            return this.matchesExpectation("number") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseBigIntType() {
            return this.matchesExpectation("bigint") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BIGINT_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseObjectType(ObjectType type) {
            if (this.value.equals("function")) {
                JSType ctorType = ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.FUNCTION_TYPE);
                if (this.resultEqualsValue) {
                    return ctorType.getGreatestSubtype(type);
                }
                return type.isSubtypeOf(ctorType) ? null : type;
            }
            return this.matchesExpectation("object") ? type : null;
        }

        @Override
        public @Nullable JSType caseStringType() {
            return this.matchesExpectation("string") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseSymbolType() {
            return this.matchesExpectation("symbol") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.SYMBOL_TYPE) : null;
        }

        @Override
        public @Nullable JSType caseVoidType() {
            return this.matchesExpectation("undefined") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE) : null;
        }
    }

    abstract class RestrictByFalseTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByFalseTypeOfResultVisitor() {
        }

        @Override
        protected JSType caseTopType(JSType topType) {
            return topType;
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }

        @Override
        public JSType caseNullType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseBigIntType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BIGINT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseSymbolType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.SYMBOL_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE);
        }
    }

    abstract class RestrictByTrueTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByTrueTypeOfResultVisitor() {
        }

        @Override
        public JSType caseNoObjectType() {
            return null;
        }

        @Override
        public JSType caseBooleanType() {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }

        @Override
        public JSType caseNullType() {
            return null;
        }

        @Override
        public JSType caseNumberType() {
            return null;
        }

        @Override
        public JSType caseBigIntType() {
            return null;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseStringType() {
            return null;
        }

        @Override
        public JSType caseSymbolType() {
            return null;
        }

        @Override
        public JSType caseVoidType() {
            return null;
        }
    }

    abstract class RestrictByTypeOfResultVisitor
    implements Visitor<JSType> {
        RestrictByTypeOfResultVisitor() {
        }

        protected abstract JSType caseTopType(JSType var1);

        @Override
        public JSType caseAllType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ALL_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            JSType restricted = null;
            for (JSType alternate : type.getAlternates()) {
                JSType restrictedAlternate = alternate.visit(this);
                if (restrictedAlternate == null) continue;
                if (restricted == null) {
                    restricted = restrictedAlternate;
                    continue;
                }
                restricted = restrictedAlternate.getLeastSupertype(restricted);
            }
            return restricted;
        }

        @Override
        public JSType caseNoType(NoType type) {
            return type;
        }

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType type = enumElementType.getPrimitiveType().visit(this);
            if (type != null && enumElementType.getPrimitiveType().equals(type)) {
                return enumElementType;
            }
            return type;
        }

        @Override
        public JSType caseTemplatizedType(TemplatizedType type) {
            return (JSType)this.caseObjectType(type);
        }

        @Override
        public JSType caseTemplateType(TemplateType templateType) {
            return (JSType)this.caseObjectType(templateType);
        }

        @Override
        public JSType caseNamedType(NamedType type) {
            return this.caseProxyObjectType(type);
        }

        @Override
        public JSType caseProxyObjectType(ProxyObjectType type) {
            return type.visitReferenceType(this);
        }
    }
}

