/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.io.BaseEncoding;
import com.google.common.net.PercentEscaper;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class TranspileResult {
    private final URI path;
    private final String original;
    private final String transpiled;
    private final String sourceMap;
    private static final Escaper ESCAPER = new PercentEscaper("-_.*", false);

    public TranspileResult(URI path, String original, String transpiled, String sourceMap) {
        this.path = (URI)Preconditions.checkNotNull((Object)path);
        this.original = (String)Preconditions.checkNotNull((Object)original);
        this.transpiled = (String)Preconditions.checkNotNull((Object)transpiled);
        this.sourceMap = (String)Preconditions.checkNotNull((Object)sourceMap);
    }

    public URI path() {
        return this.path;
    }

    public String original() {
        return this.original;
    }

    public String sourceMap() {
        return this.sourceMap;
    }

    public TranspileResult embedSourcemapUrl(String url) {
        if (this.sourceMap.isEmpty()) {
            return this;
        }
        String embedded = this.transpiled + "\n//# sourceMappingURL=" + url + "\n";
        return new TranspileResult(this.path, this.original, embedded, this.sourceMap);
    }

    public TranspileResult embedSourcemap() {
        if (this.sourceMap.isEmpty()) {
            return this;
        }
        String embedded = this.transpiled + "\n//# sourceMappingURL=data:," + ESCAPER.escape(this.sourceMap) + "\n";
        return new TranspileResult(this.path, this.original, embedded, "");
    }

    public TranspileResult embedSourcemapBase64() {
        if (this.sourceMap.isEmpty()) {
            return this;
        }
        String embedded = this.transpiled + "\n//# sourceMappingURL=data:application/json;base64," + BaseEncoding.base64().encode(this.sourceMap.getBytes(StandardCharsets.UTF_8)) + "\n";
        return new TranspileResult(this.path, this.original, embedded, "");
    }

    public String transpiled() {
        return this.transpiled;
    }

    public boolean wasTranspiled() {
        return !this.transpiled.equals(this.original);
    }

    public boolean equals(Object other) {
        return other instanceof TranspileResult && ((TranspileResult)other).path.equals(this.path) && ((TranspileResult)other).original.equals(this.original) && ((TranspileResult)other).transpiled.equals(this.transpiled) && ((TranspileResult)other).sourceMap.equals(this.sourceMap);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.original, this.transpiled, this.sourceMap);
    }

    public String toString() {
        return String.format("TranspileResut{path=%s, original=%s, transpiled=%s, sourceMapURL=%s}", this.path, this.original, this.transpiled, this.sourceMap);
    }
}

