/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.javascript.jscomp.bundle.TranspilationException;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.net.URI;
import java.util.Objects;

public final class CachingTranspiler
implements Transpiler {
    private final LoadingCache<Key, TranspileResult> cache;
    private final Supplier<String> runtime;

    public CachingTranspiler(final Transpiler delegate, CacheBuilder<Object, ? super TranspileResult> builder) {
        Preconditions.checkNotNull((Object)delegate);
        this.cache = builder.build((CacheLoader)new CacheLoader<Key, TranspileResult>(){

            public TranspileResult load(Key key) {
                return delegate.transpile(key.path, key.code);
            }
        });
        this.runtime = Suppliers.memoize(delegate::runtime);
    }

    @Override
    public TranspileResult transpile(URI path, String code) {
        try {
            return (TranspileResult)this.cache.getUnchecked((Object)new Key(path, code));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TranspilationException) {
                throw new TranspilationException((Exception)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public String runtime() {
        return (String)this.runtime.get();
    }

    private static final class Key {
        private final URI path;
        private final String code;

        Key(URI path, String code) {
            this.path = (URI)Preconditions.checkNotNull((Object)path);
            this.code = (String)Preconditions.checkNotNull((Object)code);
        }

        public boolean equals(Object other) {
            return other instanceof Key && ((Key)other).path.equals(this.path) && ((Key)other).code.equals(this.code);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.code);
        }
    }
}

