/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.serialization.AstNode;
import com.google.javascript.jscomp.serialization.ColorSerializer;
import com.google.javascript.jscomp.serialization.ExternsSummary;
import com.google.javascript.jscomp.serialization.JSDocSerializer;
import com.google.javascript.jscomp.serialization.LazyAst;
import com.google.javascript.jscomp.serialization.NodeKind;
import com.google.javascript.jscomp.serialization.OptimizationJsdoc;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.SerializeTypesToPointers;
import com.google.javascript.jscomp.serialization.SourceFilePool;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.TemplateStringValue;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypedAst;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="protobuf.lite")
final class TypedAstSerializer {
    private final AbstractCompiler compiler;
    private final SerializationOptions serializationMode;
    private final StringPool.Builder stringPool = StringPool.builder();
    private int previousLine;
    private int previousColumn;
    private final ArrayDeque<SourceFile> subtreeSourceFiles = new ArrayDeque();
    private final LinkedHashMap<SourceFile, Integer> sourceFilePointers = new LinkedHashMap();
    private @Nullable TypeSerializer typeSerializer = null;

    TypedAstSerializer(AbstractCompiler compiler, SerializationOptions serializationMode) {
        this.compiler = compiler;
        this.serializationMode = serializationMode;
    }

    TypedAst serializeRoots(Node externsRoot, Node jsRoot) {
        Node script;
        Preconditions.checkArgument((boolean)externsRoot.isRoot());
        Preconditions.checkArgument((boolean)jsRoot.isRoot());
        this.typeSerializer = this.compiler.hasOptimizationColors() ? this.createColorTypeSerializer(this.compiler, this.serializationMode, this.stringPool) : (this.compiler.hasTypeCheckingRun() ? TypedAstSerializer.createJSTypeSerializer(this.compiler, this.serializationMode, this.stringPool) : new NoOpTypeSerializer());
        TypedAst.Builder builder = TypedAst.newBuilder();
        for (script = externsRoot.getFirstChild(); script != null; script = script.getNext()) {
            if (NodeUtil.isFromTypeSummary(script)) continue;
            builder.addExternAst(this.serializeScriptNode(script));
        }
        for (script = jsRoot.getFirstChild(); script != null; script = script.getNext()) {
            if (NodeUtil.isFromTypeSummary(script)) continue;
            builder.addCodeAst(this.serializeScriptNode(script));
        }
        SourceFilePool sourceFiles = SourceFilePool.newBuilder().addAllSourceFile((Iterable)this.sourceFilePointers.keySet().stream().map(SourceFile::getProto).collect(ImmutableList.toImmutableList())).build();
        if (this.compiler.getExternProperties() != null) {
            ExternsSummary.Builder externsSummary = ExternsSummary.newBuilder();
            for (String prop : this.compiler.getExternProperties()) {
                externsSummary.addPropNamePtr(this.stringPool.put(prop));
            }
            builder.setExternsSummary(externsSummary);
        }
        return builder.setTypePool(this.typeSerializer.generateTypePool()).setStringPool(this.stringPool.build().toProto()).setSourceFilePool(sourceFiles).build();
    }

    private LazyAst serializeScriptNode(Node script) {
        Preconditions.checkState((boolean)script.isScript());
        this.previousColumn = 0;
        this.previousLine = 0;
        int sourceFile = this.getSourceFilePointer(script);
        AstNode scriptProto = this.visit(script);
        this.subtreeSourceFiles.clear();
        String encodedSourceMap = this.compiler.getBase64SourceMapContents(script.getSourceFileName());
        LazyAst.Builder lazyAstBuilder = LazyAst.newBuilder().setScript(scriptProto.toByteString()).setSourceFile(sourceFile);
        if (encodedSourceMap != null) {
            lazyAstBuilder.setSourceMappingUrl(encodedSourceMap);
        }
        return lazyAstBuilder.build();
    }

    private AstNode.Builder createWithPositionInfo(Node n) {
        Preconditions.checkState((n.getLength() >= 0 ? 1 : 0) != 0);
        int currentLine = n.getLineno();
        int currentColumn = n.getCharno();
        AstNode.Builder builder = AstNode.newBuilder().setRelativeLine(currentLine - this.previousLine).setRelativeColumn(currentColumn - this.previousColumn);
        this.previousLine = currentLine;
        this.previousColumn = currentColumn;
        return builder;
    }

    private AstNode visit(Node n) {
        AstNode.Builder builder = this.createWithPositionInfo(n);
        this.addType(n, builder);
        OptimizationJsdoc serializedJsdoc = JSDocSerializer.serializeJsdoc(n.getJSDocInfo(), this.stringPool);
        if (serializedJsdoc != null) {
            builder.setJsdoc(serializedJsdoc);
        }
        builder.setKind(this.kindTranslator(n));
        this.valueTranslator(builder, n);
        builder.setBooleanProperties(n.serializeProperties());
        int sourceFile = this.getSourceFilePointer(n);
        builder.setSourceFile(sourceFile);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            builder.addChild(this.visit(child));
        }
        if (sourceFile != 0) {
            this.subtreeSourceFiles.removeLast();
        }
        this.setOriginalName(builder, n);
        return builder.build();
    }

    private int getSourceFilePointer(Node n) {
        SourceFile sourceFile = (SourceFile)n.getStaticSourceFile();
        if (sourceFile == null) {
            Preconditions.checkState((boolean)this.subtreeSourceFiles.peekLast().isExtern(), (String)"Unexpected null SourceFile for node %s with parent %s", (Object)n.toStringTree(), (Object)n.getParent());
            return 0;
        }
        if (sourceFile.equals(this.subtreeSourceFiles.peekLast())) {
            return 0;
        }
        this.subtreeSourceFiles.addLast(sourceFile);
        return this.sourceFilePointers.computeIfAbsent(sourceFile, f -> 1 + this.sourceFilePointers.size());
    }

    private void addType(Node n, AstNode.Builder builder) {
        this.typeSerializer.addTypeForNode(n, builder);
    }

    private void valueTranslator(AstNode.Builder builder, Node n) {
        switch (n.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: 
            case MEMBER_FUNCTION_DEF: 
            case MEMBER_FIELD_DEF: 
            case NAME: 
            case STRINGLIT: 
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case LABEL_NAME: 
            case IMPORT_STAR: {
                builder.setStringValuePointer(this.stringPool.put(n.getString()));
                return;
            }
            case TEMPLATELIT_STRING: {
                builder.setTemplateStringValue(TemplateStringValue.newBuilder().setRawStringPointer(this.stringPool.put(n.getRawString())).setCookedStringPointer(n.getCookedString() == null ? -1 : this.stringPool.put(n.getCookedString())).build());
                return;
            }
            case NUMBER: {
                builder.setDoubleValue(n.getDouble());
                return;
            }
            case BIGINT: {
                builder.setStringValuePointer(this.stringPool.put(n.getBigInt().toString()));
                return;
            }
        }
    }

    private void setOriginalName(AstNode.Builder builder, Node n) {
        String originalName = n.getOriginalName();
        if (originalName == null) {
            builder.setOriginalNamePointer(0);
            return;
        }
        builder.setOriginalNamePointer(this.stringPool.put(originalName));
    }

    private NodeKind kindTranslator(Node n) {
        switch (n.getToken()) {
            case SCRIPT: {
                return NodeKind.SOURCE_FILE;
            }
            case NUMBER: {
                return NodeKind.NUMBER_LITERAL;
            }
            case STRINGLIT: {
                return NodeKind.STRING_LITERAL;
            }
            case BIGINT: {
                return NodeKind.BIGINT_LITERAL;
            }
            case REGEXP: {
                return NodeKind.REGEX_LITERAL;
            }
            case FALSE: {
                return NodeKind.FALSE;
            }
            case TRUE: {
                return NodeKind.TRUE;
            }
            case NULL: {
                return NodeKind.NULL;
            }
            case THIS: {
                return NodeKind.THIS;
            }
            case VOID: {
                return NodeKind.VOID;
            }
            case ARRAYLIT: {
                return NodeKind.ARRAY_LITERAL;
            }
            case OBJECTLIT: {
                return NodeKind.OBJECT_LITERAL;
            }
            case NAME: {
                return NodeKind.IDENTIFIER;
            }
            case ASSIGN: {
                return NodeKind.ASSIGNMENT;
            }
            case CALL: {
                return NodeKind.CALL;
            }
            case NEW: {
                return NodeKind.NEW;
            }
            case GETPROP: {
                return NodeKind.PROPERTY_ACCESS;
            }
            case GETELEM: {
                return NodeKind.ELEMENT_ACCESS;
            }
            case COMMA: {
                return NodeKind.COMMA;
            }
            case OR: {
                return NodeKind.BOOLEAN_OR;
            }
            case AND: {
                return NodeKind.BOOLEAN_AND;
            }
            case HOOK: {
                return NodeKind.HOOK;
            }
            case EQ: {
                return NodeKind.EQUAL;
            }
            case NE: {
                return NodeKind.NOT_EQUAL;
            }
            case LT: {
                return NodeKind.LESS_THAN;
            }
            case LE: {
                return NodeKind.LESS_THAN_EQUAL;
            }
            case GT: {
                return NodeKind.GREATER_THAN;
            }
            case GE: {
                return NodeKind.GREATER_THAN_EQUAL;
            }
            case SHEQ: {
                return NodeKind.TRIPLE_EQUAL;
            }
            case SHNE: {
                return NodeKind.NOT_TRIPLE_EQUAL;
            }
            case NOT: {
                return NodeKind.NOT;
            }
            case POS: {
                return NodeKind.POSITIVE;
            }
            case NEG: {
                return NodeKind.NEGATIVE;
            }
            case TYPEOF: {
                return NodeKind.TYPEOF;
            }
            case INSTANCEOF: {
                return NodeKind.INSTANCEOF;
            }
            case IN: {
                return NodeKind.IN;
            }
            case ADD: {
                return NodeKind.ADD;
            }
            case SUB: {
                return NodeKind.SUBTRACT;
            }
            case MUL: {
                return NodeKind.MULTIPLY;
            }
            case DIV: {
                return NodeKind.DIVIDE;
            }
            case MOD: {
                return NodeKind.MODULO;
            }
            case EXPONENT: {
                return NodeKind.EXPONENT;
            }
            case BITNOT: {
                return NodeKind.BITWISE_NOT;
            }
            case BITOR: {
                return NodeKind.BITWISE_OR;
            }
            case BITAND: {
                return NodeKind.BITWISE_AND;
            }
            case BITXOR: {
                return NodeKind.BITWISE_XOR;
            }
            case LSH: {
                return NodeKind.LEFT_SHIFT;
            }
            case RSH: {
                return NodeKind.RIGHT_SHIFT;
            }
            case URSH: {
                return NodeKind.UNSIGNED_RIGHT_SHIFT;
            }
            case INC: {
                return n.getBooleanProp(Node.INCRDECR_PROP) ? NodeKind.POST_INCREMENT : NodeKind.PRE_INCREMENT;
            }
            case DEC: {
                return n.getBooleanProp(Node.INCRDECR_PROP) ? NodeKind.POST_DECREMENT : NodeKind.PRE_DECREMENT;
            }
            case ASSIGN_ADD: {
                return NodeKind.ASSIGN_ADD;
            }
            case ASSIGN_SUB: {
                return NodeKind.ASSIGN_SUBTRACT;
            }
            case ASSIGN_MUL: {
                return NodeKind.ASSIGN_MULTIPLY;
            }
            case ASSIGN_DIV: {
                return NodeKind.ASSIGN_DIVIDE;
            }
            case ASSIGN_MOD: {
                return NodeKind.ASSIGN_MODULO;
            }
            case ASSIGN_EXPONENT: {
                return NodeKind.ASSIGN_EXPONENT;
            }
            case ASSIGN_BITOR: {
                return NodeKind.ASSIGN_BITWISE_OR;
            }
            case ASSIGN_BITAND: {
                return NodeKind.ASSIGN_BITWISE_AND;
            }
            case ASSIGN_BITXOR: {
                return NodeKind.ASSIGN_BITWISE_XOR;
            }
            case ASSIGN_LSH: {
                return NodeKind.ASSIGN_LEFT_SHIFT;
            }
            case ASSIGN_RSH: {
                return NodeKind.ASSIGN_RIGHT_SHIFT;
            }
            case ASSIGN_URSH: {
                return NodeKind.ASSIGN_UNSIGNED_RIGHT_SHIFT;
            }
            case YIELD: {
                return NodeKind.YIELD;
            }
            case AWAIT: {
                return NodeKind.AWAIT;
            }
            case DELPROP: {
                return NodeKind.DELETE;
            }
            case TAGGED_TEMPLATELIT: {
                return NodeKind.TAGGED_TEMPLATELIT;
            }
            case TEMPLATELIT: {
                return NodeKind.TEMPLATELIT;
            }
            case TEMPLATELIT_SUB: {
                return NodeKind.TEMPLATELIT_SUB;
            }
            case TEMPLATELIT_STRING: {
                return NodeKind.TEMPLATELIT_STRING;
            }
            case NEW_TARGET: {
                return NodeKind.NEW_TARGET;
            }
            case COMPUTED_PROP: {
                return NodeKind.COMPUTED_PROP;
            }
            case IMPORT_META: {
                return NodeKind.IMPORT_META;
            }
            case OPTCHAIN_GETPROP: {
                return NodeKind.OPTCHAIN_PROPERTY_ACCESS;
            }
            case OPTCHAIN_CALL: {
                return NodeKind.OPTCHAIN_CALL;
            }
            case OPTCHAIN_GETELEM: {
                return NodeKind.OPTCHAIN_ELEMENT_ACCESS;
            }
            case COALESCE: {
                return NodeKind.COALESCE;
            }
            case DYNAMIC_IMPORT: {
                return NodeKind.DYNAMIC_IMPORT;
            }
            case ASSIGN_OR: {
                return NodeKind.ASSIGN_OR;
            }
            case ASSIGN_AND: {
                return NodeKind.ASSIGN_AND;
            }
            case ASSIGN_COALESCE: {
                return NodeKind.ASSIGN_COALESCE;
            }
            case EXPR_RESULT: {
                return NodeKind.EXPRESSION_STATEMENT;
            }
            case BREAK: {
                return NodeKind.BREAK_STATEMENT;
            }
            case CONTINUE: {
                return NodeKind.CONTINUE_STATEMENT;
            }
            case DEBUGGER: {
                return NodeKind.DEBUGGER_STATEMENT;
            }
            case DO: {
                return NodeKind.DO_STATEMENT;
            }
            case FOR: {
                return NodeKind.FOR_STATEMENT;
            }
            case FOR_IN: {
                return NodeKind.FOR_IN_STATEMENT;
            }
            case FOR_OF: {
                return NodeKind.FOR_OF_STATEMENT;
            }
            case FOR_AWAIT_OF: {
                return NodeKind.FOR_AWAIT_OF_STATEMENT;
            }
            case IF: {
                return NodeKind.IF_STATEMENT;
            }
            case RETURN: {
                return NodeKind.RETURN_STATEMENT;
            }
            case SWITCH: {
                return NodeKind.SWITCH_STATEMENT;
            }
            case THROW: {
                return NodeKind.THROW_STATEMENT;
            }
            case TRY: {
                return NodeKind.TRY_STATEMENT;
            }
            case WHILE: {
                return NodeKind.WHILE_STATEMENT;
            }
            case EMPTY: {
                return NodeKind.EMPTY;
            }
            case WITH: {
                return NodeKind.WITH;
            }
            case IMPORT: {
                return NodeKind.IMPORT;
            }
            case EXPORT: {
                return NodeKind.EXPORT;
            }
            case VAR: {
                return NodeKind.VAR_DECLARATION;
            }
            case CONST: {
                return NodeKind.CONST_DECLARATION;
            }
            case LET: {
                return NodeKind.LET_DECLARATION;
            }
            case FUNCTION: {
                return NodeKind.FUNCTION_LITERAL;
            }
            case CLASS: {
                return NodeKind.CLASS_LITERAL;
            }
            case BLOCK: {
                return NodeKind.BLOCK;
            }
            case LABEL: {
                return NodeKind.LABELED_STATEMENT;
            }
            case LABEL_NAME: {
                return NodeKind.LABELED_NAME;
            }
            case CLASS_MEMBERS: {
                return NodeKind.CLASS_MEMBERS;
            }
            case MEMBER_FUNCTION_DEF: {
                return NodeKind.METHOD_DECLARATION;
            }
            case MEMBER_FIELD_DEF: {
                return NodeKind.FIELD_DECLARATION;
            }
            case COMPUTED_FIELD_DEF: {
                return NodeKind.COMPUTED_PROP_FIELD;
            }
            case PARAM_LIST: {
                return NodeKind.PARAMETER_LIST;
            }
            case STRING_KEY: {
                return n.isQuotedStringKey() ? NodeKind.QUOTED_STRING_KEY : NodeKind.RENAMABLE_STRING_KEY;
            }
            case CASE: {
                return NodeKind.CASE;
            }
            case DEFAULT_CASE: {
                return NodeKind.DEFAULT_CASE;
            }
            case CATCH: {
                return NodeKind.CATCH;
            }
            case SUPER: {
                return NodeKind.SUPER;
            }
            case ARRAY_PATTERN: {
                return NodeKind.ARRAY_PATTERN;
            }
            case OBJECT_PATTERN: {
                return NodeKind.OBJECT_PATTERN;
            }
            case DESTRUCTURING_LHS: {
                return NodeKind.DESTRUCTURING_LHS;
            }
            case DEFAULT_VALUE: {
                return NodeKind.DEFAULT_VALUE;
            }
            case GETTER_DEF: {
                return n.isQuotedStringKey() ? NodeKind.QUOTED_GETTER_DEF : NodeKind.RENAMABLE_GETTER_DEF;
            }
            case SETTER_DEF: {
                return n.isQuotedStringKey() ? NodeKind.QUOTED_SETTER_DEF : NodeKind.RENAMABLE_SETTER_DEF;
            }
            case IMPORT_SPECS: {
                return NodeKind.IMPORT_SPECS;
            }
            case IMPORT_SPEC: {
                return NodeKind.IMPORT_SPEC;
            }
            case IMPORT_STAR: {
                return NodeKind.IMPORT_STAR;
            }
            case EXPORT_SPECS: {
                return NodeKind.EXPORT_SPECS;
            }
            case EXPORT_SPEC: {
                return NodeKind.EXPORT_SPEC;
            }
            case MODULE_BODY: {
                return NodeKind.MODULE_BODY;
            }
            case ITER_REST: {
                return NodeKind.ITER_REST;
            }
            case ITER_SPREAD: {
                return NodeKind.ITER_SPREAD;
            }
            case OBJECT_REST: {
                return NodeKind.OBJECT_REST;
            }
            case OBJECT_SPREAD: {
                return NodeKind.OBJECT_SPREAD;
            }
        }
        throw new IllegalStateException("Unserializable token for node: " + n);
    }

    private static JSTypeSerializer createJSTypeSerializer(AbstractCompiler compiler, SerializationOptions serializationMode, StringPool.Builder stringPoolBuilder) {
        SerializeTypesToPointers serializeTypesToPointers = SerializeTypesToPointers.create(compiler, stringPoolBuilder, serializationMode);
        serializeTypesToPointers.gatherTypesOnAst(compiler.getRoot());
        return new JSTypeSerializer(serializeTypesToPointers.getTypePointersByJstype(), serializeTypesToPointers.getTypePool());
    }

    private ColorTypeSerializer createColorTypeSerializer(AbstractCompiler compiler, SerializationOptions serializationMode, StringPool.Builder stringPoolBuilder) {
        ImmutableSet<String> usedPropertyNames = TypedAstSerializer.collectUsedPropertyNames(compiler);
        ColorSerializer colorSerializer = new ColorSerializer(serializationMode, stringPoolBuilder::put, arg_0 -> usedPropertyNames.contains(arg_0));
        return new ColorTypeSerializer(colorSerializer, compiler.getColorRegistry());
    }

    private static ImmutableSet<String> collectUsedPropertyNames(AbstractCompiler compiler) {
        final ImmutableSet.Builder propertyNamesBuilder = ImmutableSet.builder();
        NodeTraversal.traverse(compiler, compiler.getRoot(), new NodeTraversal.Callback(){

            @Override
            public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                switch (n.getToken()) {
                    case GETPROP: 
                    case OPTCHAIN_GETPROP: {
                        propertyNamesBuilder.add((Object)n.getString());
                        break;
                    }
                    case MEMBER_FUNCTION_DEF: 
                    case MEMBER_FIELD_DEF: 
                    case STRING_KEY: 
                    case GETTER_DEF: 
                    case SETTER_DEF: {
                        if (n.isQuotedStringKey()) break;
                        propertyNamesBuilder.add((Object)n.getString());
                        break;
                    }
                }
            }
        });
        return propertyNamesBuilder.build();
    }

    static interface TypeSerializer {
        public void addTypeForNode(Node var1, AstNode.Builder var2);

        public TypePool generateTypePool();
    }

    private static class ColorTypeSerializer
    implements TypeSerializer {
        private final ColorSerializer colorSerializer;
        private final ColorRegistry colorRegistry;

        private ColorTypeSerializer(ColorSerializer colorSerializer, ColorRegistry colorRegistry) {
            this.colorSerializer = colorSerializer;
            this.colorRegistry = colorRegistry;
        }

        @Override
        public void addTypeForNode(Node node, AstNode.Builder astNodeBuilder) {
            Color color = node.getColor();
            if (color != null) {
                astNodeBuilder.setType(this.colorSerializer.addColor(color));
            }
        }

        @Override
        public TypePool generateTypePool() {
            ImmutableSetMultimap<ColorId, String> mismatchLocationsForDebugging = this.colorRegistry.getMismatchLocationsForDebugging();
            return this.colorSerializer.generateTypePool(this.colorRegistry::getDisambiguationSupertypes, color -> mismatchLocationsForDebugging.get((Object)color.getId()));
        }
    }

    private static class JSTypeSerializer
    implements TypeSerializer {
        private final IdentityHashMap<JSType, Integer> typesToPointers;
        private final TypePool typePool;

        private JSTypeSerializer(IdentityHashMap<JSType, Integer> typesToPointers, TypePool typePool) {
            this.typesToPointers = typesToPointers;
            this.typePool = typePool;
        }

        @Override
        public void addTypeForNode(Node node, AstNode.Builder astNodeBuilder) {
            JSType type = node.getJSType();
            if (type != null) {
                astNodeBuilder.setType((Integer)Preconditions.checkNotNull((Object)this.typesToPointers.get(type), (String)"cannot find pointer for %s", (Object)type));
            }
        }

        @Override
        public TypePool generateTypePool() {
            return this.typePool;
        }
    }

    private static class NoOpTypeSerializer
    implements TypeSerializer {
        private NoOpTypeSerializer() {
        }

        @Override
        public void addTypeForNode(Node node, AstNode.Builder astNodeBuilder) {
        }

        @Override
        public TypePool generateTypePool() {
            return TypePool.getDefaultInstance();
        }
    }
}

