/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.resources;

import com.google.common.collect.ImmutableMap;

final class PropertiesParser {
    static ImmutableMap<String, String> parse(String source) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String[] lines = source.split("\r?\n");
        for (int i = 0; i < lines.length; ++i) {
            String key;
            Object data;
            block3: {
                int delimeterIndex;
                String line = lines[i];
                if (line.isEmpty() || line.startsWith("#") || line.startsWith("!") || (delimeterIndex = PropertiesParser.findDelimiter(line)) == -1) continue;
                data = "";
                key = line.substring(0, delimeterIndex).trim();
                line = PropertiesParser.trimLeft(line.substring(delimeterIndex + 1));
                while (line.endsWith("\\")) {
                    data = (String)data + line.substring(0, line.length() - 1);
                    if (i + 1 != lines.length) {
                        line = PropertiesParser.trimLeft(lines[++i]);
                        continue;
                    }
                    break block3;
                }
                data = (String)data + line;
            }
            builder.put((Object)key, data);
        }
        return builder.buildOrThrow();
    }

    private static String trimLeft(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            return str.substring(i);
        }
        return str;
    }

    private static int findDelimiter(String line) {
        for (int i = 0; i < line.length(); ++i) {
            switch (line.charAt(i)) {
                case ':': 
                case '=': {
                    return i;
                }
            }
        }
        return line.indexOf(32);
    }

    private PropertiesParser() {
    }
}

