/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public final class FeatureSet
implements Serializable {
    private final ImmutableSet<Feature> features;
    public static final FeatureSet BARE_MINIMUM = new FeatureSet(FeatureSet.emptyEnumSet());
    public static final FeatureSet ES3 = BARE_MINIMUM.with(LangVersion.ES3.features());
    public static final FeatureSet ES5 = ES3.with(LangVersion.ES5.features());
    public static final FeatureSet ES2015_MODULES = ES5.with(LangVersion.ES2015.features());
    public static final FeatureSet ES2015 = ES2015_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2016_MODULES = ES2015_MODULES.with(LangVersion.ES2016.features());
    public static final FeatureSet ES2016 = ES2016_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2017_MODULES = ES2016_MODULES.with(LangVersion.ES2017.features());
    public static final FeatureSet ES2017 = ES2017_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2018_MODULES = ES2017_MODULES.with(LangVersion.ES2018.features());
    public static final FeatureSet ES2018 = ES2018_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2019_MODULES = ES2018_MODULES.with(LangVersion.ES2019.features());
    public static final FeatureSet ES2019 = ES2019_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2020_MODULES = ES2019_MODULES.with(LangVersion.ES2020.features());
    public static final FeatureSet ES2020 = ES2020_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2021_MODULES = ES2020_MODULES.with(LangVersion.ES2021.features());
    public static final FeatureSet ES2021 = ES2021_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES_NEXT = ES2021_MODULES.with(LangVersion.ES_NEXT.features());
    public static final FeatureSet ES_UNSTABLE = ES_NEXT.with(LangVersion.ES_UNSTABLE.features());
    public static final FeatureSet ES_UNSUPPORTED = ES_UNSTABLE.with(LangVersion.ES_UNSUPPORTED.features());
    public static final FeatureSet BROWSER_2020 = ES2019_MODULES.without(Feature.REGEXP_FLAG_S, Feature.REGEXP_LOOKBEHIND, Feature.REGEXP_NAMED_GROUPS, Feature.REGEXP_UNICODE_PROPERTY_ESCAPE);
    public static final FeatureSet BROWSER_2021 = ES2020_MODULES.without(Feature.REGEXP_LOOKBEHIND, new Feature[0]);
    public static final FeatureSet BROWSER_2022 = ES2021_MODULES.without(Feature.REGEXP_LOOKBEHIND, new Feature[0]);
    public static final FeatureSet BROWSER_2023 = ES2021_MODULES.without(Feature.REGEXP_LOOKBEHIND, new Feature[0]);
    public static final FeatureSet BROWSER_2024 = ES2021_MODULES;
    public static final FeatureSet ALL = ES_UNSUPPORTED.with(LangVersion.TYPESCRIPT.features());

    private FeatureSet(EnumSet<Feature> features) {
        this.features = ImmutableSet.copyOf(features);
    }

    public String version() {
        if (ES3.contains(this)) {
            return "es3";
        }
        if (ES5.contains(this)) {
            return "es5";
        }
        if (ES2015_MODULES.contains(this)) {
            return "es6";
        }
        if (ES2016_MODULES.contains(this)) {
            return "es7";
        }
        if (ES2017_MODULES.contains(this)) {
            return "es8";
        }
        if (ES2018_MODULES.contains(this)) {
            return "es9";
        }
        if (ES2019_MODULES.contains(this)) {
            return "es_2019";
        }
        if (ES2020_MODULES.contains(this)) {
            return "es_2020";
        }
        if (ES2021_MODULES.contains(this)) {
            return "es_2021";
        }
        if (ES_NEXT.contains(this)) {
            return "es_next";
        }
        if (ES_UNSTABLE.contains(this)) {
            return "es_unstable";
        }
        if (ES_UNSUPPORTED.contains(this)) {
            return "es_unsupported";
        }
        if (ALL.contains(this)) {
            return "all";
        }
        throw new IllegalStateException(this.toString());
    }

    @Deprecated
    @InlineMe(replacement="this.version()")
    public String versionForDebugging() {
        return this.version();
    }

    public FeatureSet without(Feature featureToRemove, Feature ... moreFeaturesToRemove) {
        return new FeatureSet(FeatureSet.difference(this.features, EnumSet.of(featureToRemove, moreFeaturesToRemove)));
    }

    public FeatureSet without(FeatureSet other) {
        return new FeatureSet(FeatureSet.difference(this.features, other.features));
    }

    public FeatureSet withoutTypes() {
        return new FeatureSet(FeatureSet.difference(this.features, LangVersion.TYPESCRIPT.features()));
    }

    public FeatureSet union(FeatureSet other) {
        return new FeatureSet(FeatureSet.union(this.features, other.features));
    }

    public boolean containsAtLeastOneOf(FeatureSet other) {
        for (Feature otherFeature : other.features) {
            if (!this.features.contains((Object)otherFeature)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(FeatureSet other) {
        return this.features.containsAll(other.features);
    }

    public boolean contains(Feature feature) {
        return this.features.containsAll(EnumSet.of(feature));
    }

    private static EnumSet<Feature> emptyEnumSet() {
        return EnumSet.noneOf(Feature.class);
    }

    private static EnumSet<Feature> enumSetOf(Set<Feature> set) {
        return set.isEmpty() ? FeatureSet.emptyEnumSet() : EnumSet.copyOf(set);
    }

    private static EnumSet<Feature> add(Set<Feature> features, Feature feature) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.add(feature);
        return result;
    }

    private static EnumSet<Feature> union(Set<Feature> features, Set<Feature> newFeatures) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.addAll(newFeatures);
        return result;
    }

    private static EnumSet<Feature> difference(Set<Feature> features, Set<Feature> removedFeatures) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.removeAll(removedFeatures);
        return result;
    }

    public FeatureSet with(Feature feature) {
        if (this.features.contains((Object)feature)) {
            return this;
        }
        return new FeatureSet(FeatureSet.add(this.features, feature));
    }

    @VisibleForTesting
    public FeatureSet with(Feature ... newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, (Set<Feature>)ImmutableSet.copyOf((Object[])newFeatures)));
    }

    @VisibleForTesting
    public FeatureSet with(Set<Feature> newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, newFeatures));
    }

    @VisibleForTesting
    public FeatureSet with(FeatureSet newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, newFeatures.features));
    }

    public boolean has(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public ImmutableSet<Feature> getFeatures() {
        return this.features;
    }

    public boolean equals(Object other) {
        return other instanceof FeatureSet && ((FeatureSet)other).features.equals(this.features);
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public String toString() {
        return this.features.toString();
    }

    public static FeatureSet valueOf(String name) {
        switch (name) {
            case "es3": {
                return ES3;
            }
            case "es5": {
                return ES5;
            }
            case "es_2015": 
            case "es6": {
                return ES2015;
            }
            case "es_2016": 
            case "es7": {
                return ES2016;
            }
            case "es_2017": 
            case "es8": {
                return ES2017;
            }
            case "es_2018": 
            case "es9": {
                return ES2018;
            }
            case "es_2019": {
                return ES2019;
            }
            case "es_2020": {
                return ES2020;
            }
            case "es_2021": {
                return ES2021;
            }
            case "es_next": {
                return ES_NEXT;
            }
            case "es_unstable": {
                return ES_UNSTABLE;
            }
            case "es_unsupported": {
                return ES_UNSUPPORTED;
            }
            case "all": {
                return ALL;
            }
        }
        throw new IllegalArgumentException("No such FeatureSet: " + name);
    }

    public static FeatureSet all() {
        return ALL;
    }

    public static FeatureSet latest() {
        return ES_UNSUPPORTED;
    }

    private static enum LangVersion {
        ES3,
        ES5,
        ES2015,
        ES2016,
        ES2017,
        ES2018,
        ES2019,
        ES2020,
        ES2021,
        ES_NEXT,
        ES_UNSTABLE,
        ES_UNSUPPORTED,
        TYPESCRIPT;


        private EnumSet<Feature> features() {
            EnumSet<Feature> set = EnumSet.noneOf(Feature.class);
            for (Feature feature : Feature.values()) {
                if (feature.version != this) continue;
                set.add(feature);
            }
            return set;
        }
    }

    public static enum Feature {
        ES3_KEYWORDS_AS_IDENTIFIERS("ES3 keywords as identifiers", LangVersion.ES5),
        GETTER("getters", LangVersion.ES5),
        KEYWORDS_AS_PROPERTIES("reserved words as properties", LangVersion.ES5),
        SETTER("setters", LangVersion.ES5),
        STRING_CONTINUATION("string continuation", LangVersion.ES5),
        TRAILING_COMMA("trailing comma", LangVersion.ES5),
        ARRAY_PATTERN_REST("array pattern rest", LangVersion.ES2015),
        ARROW_FUNCTIONS("arrow function", LangVersion.ES2015),
        BINARY_LITERALS("binary literal", LangVersion.ES2015),
        BLOCK_SCOPED_FUNCTION_DECLARATION("block-scoped function declaration", LangVersion.ES2015),
        CLASSES("class", LangVersion.ES2015),
        CLASS_EXTENDS("class extends", LangVersion.ES2015),
        CLASS_GETTER_SETTER("class getters/setters", LangVersion.ES2015),
        COMPUTED_PROPERTIES("computed property", LangVersion.ES2015),
        CONST_DECLARATIONS("const declaration", LangVersion.ES2015),
        DEFAULT_PARAMETERS("default parameter", LangVersion.ES2015),
        ARRAY_DESTRUCTURING("array destructuring", LangVersion.ES2015),
        OBJECT_DESTRUCTURING("object destructuring", LangVersion.ES2015),
        EXTENDED_OBJECT_LITERALS("extended object literal", LangVersion.ES2015),
        FOR_OF("for-of loop", LangVersion.ES2015),
        GENERATORS("generator", LangVersion.ES2015),
        LET_DECLARATIONS("let declaration", LangVersion.ES2015),
        MEMBER_DECLARATIONS("member declaration", LangVersion.ES2015),
        NEW_TARGET("new.target", LangVersion.ES2015),
        OCTAL_LITERALS("octal literal", LangVersion.ES2015),
        REGEXP_FLAG_U("RegExp flag 'u'", LangVersion.ES2015),
        REGEXP_FLAG_Y("RegExp flag 'y'", LangVersion.ES2015),
        REST_PARAMETERS("rest parameter", LangVersion.ES2015),
        SPREAD_EXPRESSIONS("spread expression", LangVersion.ES2015),
        SUPER("super", LangVersion.ES2015),
        TEMPLATE_LITERALS("template literal", LangVersion.ES2015),
        MODULES("modules", LangVersion.ES2015),
        EXPONENT_OP("exponent operator (**)", LangVersion.ES2016),
        ASYNC_FUNCTIONS("async function", LangVersion.ES2017),
        OBJECT_LITERALS_WITH_SPREAD("object literals with spread", LangVersion.ES2018),
        OBJECT_PATTERN_REST("object pattern rest", LangVersion.ES2018),
        ASYNC_GENERATORS("async generator functions", LangVersion.ES2018),
        FOR_AWAIT_OF("for-await-of loop", LangVersion.ES2018),
        REGEXP_FLAG_S("RegExp flag 's'", LangVersion.ES2018),
        REGEXP_LOOKBEHIND("RegExp Lookbehind", LangVersion.ES2018),
        REGEXP_NAMED_GROUPS("RegExp named groups", LangVersion.ES2018),
        REGEXP_UNICODE_PROPERTY_ESCAPE("RegExp unicode property escape", LangVersion.ES2018),
        UNESCAPED_UNICODE_LINE_OR_PARAGRAPH_SEP("Unescaped unicode line or paragraph separator", LangVersion.ES2019),
        OPTIONAL_CATCH_BINDING("Optional catch binding", LangVersion.ES2019),
        DYNAMIC_IMPORT("Dynamic module import", LangVersion.ES2020),
        BIGINT("bigint", LangVersion.ES2020),
        IMPORT_META("import.meta", LangVersion.ES2020),
        NULL_COALESCE_OP("Nullish coalescing", LangVersion.ES2020),
        OPTIONAL_CHAINING("Optional chaining", LangVersion.ES2020),
        NUMERIC_SEPARATOR("numeric separator", LangVersion.ES2021),
        LOGICAL_ASSIGNMENT("Logical assignments", LangVersion.ES2021),
        REGEXP_FLAG_D("RegExp flag 'd'", LangVersion.ES_NEXT),
        PUBLIC_CLASS_FIELDS("Public class fields", LangVersion.ES_UNSTABLE),
        CLASS_STATIC_BLOCK("Class static block", LangVersion.ES_UNSTABLE),
        TYPE_ANNOTATION("type annotation", LangVersion.TYPESCRIPT);

        private final String name;
        private final LangVersion version;

        private Feature(String name, LangVersion version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.name;
        }
    }
}

