/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

public final class CheckInterfaces
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String ANONYMOUS_CLASSNAME = "<anonymous>";
    public static final DiagnosticType NON_DECLARATION_STATEMENT_IN_INTERFACE = DiagnosticType.disabled("JSC_NON_DECLARATION_STATEMENT_IN_INTERFACE", "@interface or @record functions should not contain statements other than field declarations");
    public static final DiagnosticType MISSING_JSDOC_IN_DECLARATION_STATEMENT = DiagnosticType.disabled("JSC_MISSING_JSDOC_IN_DECLARATION_STATEMENT", "@interface or @record functions must contain JSDoc for each field declaration.");
    public static final DiagnosticType INTERFACE_CLASS_NONSTATIC_METHOD_NOT_EMPTY = DiagnosticType.disabled("JSC_INTERFACE_CLASS_NONSTATIC_METHOD_NOT_EMPTY", "interface methods must have an empty body");
    public static final DiagnosticType INTERFACE_CONSTRUCTOR_SHOULD_NOT_TAKE_ARGS = DiagnosticType.disabled("JSC_INTERFACE_CONSTRUCTOR_SHOULD_NOT_TAKE_ARGS", "Interface constructors should not take any arguments");
    public static final DiagnosticType STATIC_MEMBER_FUNCTION_IN_INTERFACE_CLASS = DiagnosticType.disabled("JSC_STATIC_MEMBER_FUNCTION_IN_INTERFACE_CLASS", "Interface class should not have static member functions. Consider pulling out the static method into a flat name as {0}_{1}");
    public static final DiagnosticType INTERFACE_DEFINED_WITH_EXTENDS = DiagnosticType.disabled("JSC_INTERFACE_DEFINED_WITH_EXTENDS", "Interface/Record class should use the `@extends` annotation instead of extends keyword.");
    private final AbstractCompiler compiler;

    public CheckInterfaces(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private static boolean isInterface(JSDocInfo jsDoc) {
        return jsDoc != null && jsDoc.isInterface();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
                if (!CheckInterfaces.isInterface(jsdoc)) break;
                CheckInterfaces.checkInterfaceConstructorArgs(t, n);
                CheckInterfaces.checkConstructorBlock(t, n);
                break;
            }
            case CLASS: {
                Node ctorDef;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
                if (!CheckInterfaces.isInterface(jsdoc)) break;
                if (n.getSecondChild() != null && n.getSecondChild().isName()) {
                    t.report(n, INTERFACE_DEFINED_WITH_EXTENDS, new String[0]);
                }
                if ((ctorDef = NodeUtil.getEs6ClassConstructorMemberFunctionDef(n)) != null) {
                    Node ctor = ctorDef.getFirstChild();
                    CheckInterfaces.checkInterfaceConstructorArgs(t, ctor);
                    CheckInterfaces.checkConstructorBlock(t, ctor);
                }
                CheckInterfaces.checkClassMethods(t, n, ctorDef);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void checkInterfaceConstructorArgs(NodeTraversal t, Node funcNode) {
        Node args = funcNode.getSecondChild();
        if (args.hasChildren()) {
            t.report(args.getFirstChild(), INTERFACE_CONSTRUCTOR_SHOULD_NOT_TAKE_ARGS, new String[0]);
        }
    }

    private static void checkClassMethods(NodeTraversal t, Node classNode, @Nullable Node ctorDef) {
        Node classMembers = classNode.getLastChild();
        Preconditions.checkState((boolean)classMembers.isClassMembers(), (Object)classMembers);
        for (Node memberFuncDef = classMembers.getFirstChild(); memberFuncDef != null; memberFuncDef = memberFuncDef.getNext()) {
            if (memberFuncDef.equals(ctorDef)) continue;
            if (memberFuncDef.isStaticMember()) {
                String className = NodeUtil.getName(classNode);
                if (className == null) {
                    className = ANONYMOUS_CLASSNAME;
                }
                String funcName = memberFuncDef.getString();
                t.report(memberFuncDef, STATIC_MEMBER_FUNCTION_IN_INTERFACE_CLASS, className, funcName);
                continue;
            }
            Node block = memberFuncDef.getLastChild().getLastChild();
            if (!block.hasChildren()) continue;
            t.report(block.getFirstChild(), INTERFACE_CLASS_NONSTATIC_METHOD_NOT_EMPTY, new String[0]);
        }
    }

    private static void checkConstructorBlock(NodeTraversal t, Node funcNode) {
        Node block = funcNode.getLastChild();
        if (!block.hasChildren()) {
            return;
        }
        for (Node stmt = block.getFirstChild(); stmt != null; stmt = stmt.getNext()) {
            if (!CheckInterfaces.isThisPropAccess(stmt)) {
                t.report(stmt, NON_DECLARATION_STATEMENT_IN_INTERFACE, new String[0]);
                break;
            }
            if (stmt.getFirstChild().getJSDocInfo() != null) continue;
            t.report(stmt, MISSING_JSDOC_IN_DECLARATION_STATEMENT, new String[0]);
            break;
        }
    }

    private static boolean isThisPropAccess(Node stmt) {
        return stmt.isExprResult() && stmt.getFirstChild().isGetProp() && stmt.getFirstFirstChild().isThis();
    }
}

