/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationPass;
import com.google.javascript.jscomp.instrumentation.CoverageUtil;
import com.google.javascript.jscomp.instrumentation.FileInstrumentationData;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Map;

@GwtIncompatible(value="FileInstrumentationData")
class CoverageInstrumentationCallback
implements NodeTraversal.Callback {
    private final Map<String, FileInstrumentationData> instrumentationData;
    private final CoverageInstrumentationPass.CoverageReach reach;
    static final String ARRAY_NAME_PREFIX = "JSCompiler_lcov_data_";

    public CoverageInstrumentationCallback(Map<String, FileInstrumentationData> instrumentationData, CoverageInstrumentationPass.CoverageReach reach) {
        this.instrumentationData = instrumentationData;
        this.reach = reach;
    }

    private static String getFileName(NodeTraversal traversal) {
        return traversal.getSourceName();
    }

    private String createArrayName(NodeTraversal traversal) {
        return ARRAY_NAME_PREFIX + CoverageUtil.createIdentifierFromText(CoverageInstrumentationCallback.getFileName(traversal));
    }

    private Node newInstrumentationNode(NodeTraversal traversal, Node node) {
        int lineNumber = node.getLineno();
        String arrayName = this.createArrayName(traversal);
        Node getElemNode = IR.getelem(IR.name(arrayName), IR.number(lineNumber - 1));
        Node exprNode = IR.exprResult(IR.assign(getElemNode, IR.trueNode()));
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        this.instrumentationData.computeIfAbsent(fileName, k -> new FileInstrumentationData((String)k, arrayName));
        this.instrumentationData.get(fileName).setLineAsInstrumented(lineNumber);
        return exprNode.srcrefTreeIfMissing(node);
    }

    private Node newArrayDeclarationNode(NodeTraversal traversal) {
        return IR.var(IR.name(this.createArrayName(traversal)), IR.arraylit(new Node[0]));
    }

    private Node newHeaderNode(NodeTraversal traversal, Node srcref) {
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        String arrayName = this.createArrayName(traversal);
        FileInstrumentationData data = this.instrumentationData.get(fileName);
        Preconditions.checkNotNull((Object)data);
        String objName = "__jscov";
        return IR.block(this.newArrayDeclarationNode(traversal), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("executedLines")), "push"), IR.name(arrayName))), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("instrumentedLines")), "push"), IR.string(data.getInstrumentedLinesAsHexString()))), IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("fileNames")), "push"), IR.string(fileName)))).srcrefTreeIfMissing(srcref);
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return !n.isScript() || n.getJSDocInfo() == null || !n.getJSDocInfo().isNoCoverage();
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.isScript()) {
            String fileName = CoverageInstrumentationCallback.getFileName(traversal);
            if (this.instrumentationData.get(fileName) != null) {
                if (node.hasChildren() && node.getFirstChild().isModuleBody()) {
                    node = node.getFirstChild();
                }
                node.addChildrenToFront(this.newHeaderNode(traversal, node).removeChildren());
            }
            traversal.reportCodeChange();
            return;
        }
        if (this.reach == CoverageInstrumentationPass.CoverageReach.CONDITIONAL && parent != null && parent.isScript()) {
            return;
        }
        if (node.isFunction() && !NodeUtil.getFunctionBody(node).isBlock()) {
            Node returnValue = NodeUtil.getFunctionBody(node);
            Node body = IR.block(IR.returnNode(returnValue.detach()));
            body.srcrefTreeIfMissing(returnValue);
            node.addChildToBack(body);
        }
        if (node.isFunction() || node.isWith() || node.isCase() || node.isDefaultCase() || node.isCatch()) {
            Node codeBlock = node.getLastChild();
            codeBlock.addChildToFront(this.newInstrumentationNode(traversal, node));
            traversal.reportCodeChange();
            return;
        }
        if (node.isTry()) {
            Node firstChild = node.getFirstChild();
            firstChild.addChildToFront(this.newInstrumentationNode(traversal, node));
            traversal.reportCodeChange();
            return;
        }
        if (parent != null && NodeUtil.isStatementBlock(parent) && !node.isModuleBody()) {
            this.newInstrumentationNode(traversal, node).insertBefore(node);
            traversal.reportCodeChange();
            return;
        }
    }
}

