/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ijs.ClassUtil;
import com.google.javascript.jscomp.ijs.JsdocUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import org.jspecify.nullness.Nullable;

abstract class PotentialDeclaration {
    private static final int STRING_ENUM_RETAIN_CAP = 10;
    private final String fullyQualifiedName;
    private final Node lhs;
    private final @Nullable Node rhs;
    private static final QualifiedName GOOG_ABSTRACTMETHOD = QualifiedName.of("goog.abstractMethod");
    private static final QualifiedName GOOG_REQUIRE = QualifiedName.of("goog.require");
    private static final QualifiedName GOOG_REQUIRETYPE = QualifiedName.of("goog.requireType");
    private static final QualifiedName GOOG_FORWARDDECLARE = QualifiedName.of("goog.forwardDeclare");
    private static final QualifiedName MODULE_EXPORTS = QualifiedName.of("module.exports");
    private static final QualifiedName GOOG_MODULE_GET = QualifiedName.of("goog.module.get");

    private PotentialDeclaration(String fullyQualifiedName, Node lhs, @Nullable Node rhs) {
        this.fullyQualifiedName = (String)Preconditions.checkNotNull((Object)fullyQualifiedName);
        this.lhs = (Node)Preconditions.checkNotNull((Object)lhs);
        this.rhs = rhs;
    }

    static PotentialDeclaration fromName(Node nameNode) {
        Preconditions.checkArgument((boolean)nameNode.isQualifiedName(), (Object)nameNode);
        Node rhs = NodeUtil.getRValueOfLValue(nameNode);
        if (ClassUtil.isThisPropInsideClassWithName(nameNode)) {
            String name = ClassUtil.getFullyQualifiedNameOfThisProp(nameNode);
            return new ThisPropDeclaration(name, nameNode, rhs);
        }
        return new NameDeclaration(nameNode.getQualifiedName(), nameNode, rhs);
    }

    static PotentialDeclaration fromMemberFieldDef(Node fieldNode) {
        Preconditions.checkArgument((boolean)fieldNode.isMemberFieldDef());
        Node rhs = NodeUtil.getRValueOfLValue(fieldNode);
        String name = ClassUtil.getFullyQualifiedNameOfMemberFieldDef(fieldNode);
        return new MemberFieldDeclaration(name, fieldNode, rhs);
    }

    static PotentialDeclaration fromMethod(Node functionNode) {
        Preconditions.checkArgument((boolean)ClassUtil.isClassMethod(functionNode));
        String name = ClassUtil.getFullyQualifiedNameOfMethod(functionNode);
        return new MethodDeclaration(name, functionNode);
    }

    static PotentialDeclaration fromStringKey(Node stringKeyNode) {
        JSDocInfo objLitJsDoc;
        Preconditions.checkArgument((boolean)stringKeyNode.isStringKey());
        Preconditions.checkArgument((boolean)stringKeyNode.getParent().isObjectLit());
        String name = "this." + stringKeyNode.getString();
        if (stringKeyNode.getString().equals("properties") && (objLitJsDoc = NodeUtil.getBestJSDocInfo(stringKeyNode.getParent())) != null && objLitJsDoc.isPolymerBehavior()) {
            return new PolymerBehaviorPropertiesDeclaration(name, stringKeyNode);
        }
        return new StringKeyDeclaration(name, stringKeyNode);
    }

    static PotentialDeclaration fromDefine(Node callNode) {
        Preconditions.checkArgument((boolean)NodeUtil.isCallTo(callNode, "goog.define"));
        return DefineDeclaration.from(callNode);
    }

    static PotentialDeclaration fromAlias(Node nameNode) {
        Preconditions.checkArgument((boolean)nameNode.isQualifiedName(), (Object)nameNode);
        return new AliasDeclaration(nameNode.getQualifiedName(), nameNode);
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    Node getLhs() {
        return this.lhs;
    }

    @Nullable Node getRhs() {
        return this.rhs;
    }

    @Nullable JSDocInfo getJsDoc() {
        return NodeUtil.getBestJSDocInfo(this.lhs);
    }

    boolean isDetached() {
        for (Node current = this.lhs; current != null; current = current.getParent()) {
            if (!current.isScript()) continue;
            return false;
        }
        return true;
    }

    Node getRemovableNode() {
        return NodeUtil.getEnclosingStatement(this.lhs);
    }

    final void remove(AbstractCompiler compiler) {
        if (this.isDetached()) {
            return;
        }
        Node statement = this.getRemovableNode();
        NodeUtil.deleteNode(statement, compiler);
        statement.removeChildren();
    }

    abstract void simplify(AbstractCompiler var1);

    boolean breakDownDestructure(AbstractCompiler compiler) {
        return false;
    }

    private void simplifyEnumValues(AbstractCompiler compiler) {
        if (this.getRhs().isObjectLit() && this.getRhs().hasChildren()) {
            boolean changed = false;
            for (Node key = this.getRhs().getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getOnlyChild();
                if (!value.isStringLit()) {
                    PotentialDeclaration.removeStringKeyValue(key);
                    changed = true;
                    continue;
                }
                String content = value.getString();
                if (content.length() <= 10) continue;
                PotentialDeclaration.truncateStringKeyValue(key);
                changed = true;
            }
            if (changed) {
                compiler.reportChangeToEnclosingScope(this.getRhs());
            }
        }
    }

    boolean isDefiniteDeclaration(AbstractCompiler compiler) {
        Node parent = this.getLhs().getParent();
        switch (parent.getToken()) {
            case DEFAULT_VALUE: {
                if (!parent.getParent().isStringKey()) {
                    return false;
                }
            }
            case COMPUTED_PROP: 
            case STRING_KEY: {
                if (NodeUtil.isLhsByDestructuring(this.getLhs())) {
                    Node rootTarget = NodeUtil.getRootTarget(this.getLhs());
                    Preconditions.checkState((boolean)rootTarget.getParent().isDestructuringLhs());
                    if (NodeUtil.isNameDeclaration(rootTarget.getGrandparent())) {
                        return true;
                    }
                }
                return false;
            }
            case VAR: 
            case LET: 
            case CONST: 
            case CLASS: 
            case FUNCTION: {
                return true;
            }
        }
        return PotentialDeclaration.isExportLhs(this.getLhs()) || this.getJsDoc() != null && this.getJsDoc().containsDeclaration() || this.getRhs() != null && PotentialDeclaration.isTypedRhs(this.getRhs());
    }

    boolean shouldPreserve() {
        return this.getRhs() != null && PotentialDeclaration.isTypedRhs(this.getRhs());
    }

    boolean isConstToBeInferred() {
        return PotentialDeclaration.isConstToBeInferred(this.getLhs());
    }

    static boolean isConstToBeInferred(Node nameNode) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(nameNode);
        boolean isConst = nameNode.getParent().isConst() || PotentialDeclaration.isExportLhs(nameNode) || jsdoc != null && jsdoc.isConstant();
        return isConst && !JsdocUtil.hasAnnotatedType(jsdoc) && !NodeUtil.isNamespaceDecl(nameNode);
    }

    private static boolean isTypedRhs(Node rhs) {
        return rhs.isFunction() || rhs.isClass() || NodeUtil.isCallTo(rhs, "goog.defineClass") || rhs.isQualifiedName() && GOOG_ABSTRACTMETHOD.matches(rhs);
    }

    private static boolean isExportLhs(Node lhs) {
        return lhs.isName() && lhs.matchesName("exports") || lhs.isGetProp() && lhs.getFirstChild().matchesName("exports") || MODULE_EXPORTS.matches(lhs);
    }

    static boolean isImportRhs(@Nullable Node rhs) {
        if (rhs == null || !rhs.isCall()) {
            return false;
        }
        Node callee = rhs.getFirstChild();
        return GOOG_REQUIRE.matches(callee) || GOOG_REQUIRETYPE.matches(callee) || GOOG_FORWARDDECLARE.matches(callee) || callee.matchesName("require");
    }

    static boolean isAliasDeclaration(Node lhs, @Nullable Node rhs) {
        return !ClassUtil.isThisPropInsideClassWithName(lhs) && PotentialDeclaration.isConstToBeInferred(lhs) && rhs != null && PotentialDeclaration.isQualifiedAliasExpression(rhs);
    }

    public static final boolean isQualifiedAliasExpression(Node n) {
        switch (n.getToken()) {
            case NAME: {
                return !n.getString().isEmpty();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return PotentialDeclaration.isQualifiedAliasExpression(n.getFirstChild());
            }
            case CALL: {
                return GOOG_MODULE_GET.matches(n.getFirstChild());
            }
        }
        return false;
    }

    private static void removeStringKeyValue(Node stringKey) {
        Node value = stringKey.getOnlyChild();
        Node replacementValue = IR.number(0.0).srcrefTree(value);
        value.replaceWith(replacementValue);
    }

    private static void truncateStringKeyValue(Node stringKey) {
        Node value = stringKey.getOnlyChild();
        Node replacementValue = IR.string(value.getString().substring(0, 8) + "..").srcrefTree(value);
        value.replaceWith(replacementValue);
    }

    private static class ThisPropDeclaration
    extends PotentialDeclaration {
        private final Node insertionPoint;

        ThisPropDeclaration(String fullyQualifiedName, Node lhs, Node rhs) {
            super(fullyQualifiedName, lhs, rhs);
            Node thisPropDefinition = NodeUtil.getEnclosingStatement(lhs);
            this.insertionPoint = NodeUtil.getEnclosingStatement(thisPropDefinition.getParent());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.shouldPreserve()) {
                return;
            }
            Node newStatement = NodeUtil.newQNameDeclaration(compiler, this.getFullyQualifiedName(), null, this.getJsDoc());
            newStatement.srcrefTreeIfMissing(this.getLhs());
            NodeUtil.deleteNode(this.getRemovableNode(), compiler);
            if (this.insertionPoint.hasParent()) {
                newStatement.insertAfter(this.insertionPoint);
                compiler.reportChangeToEnclosingScope(newStatement);
            }
        }
    }

    private static class NameDeclaration
    extends PotentialDeclaration {
        NameDeclaration(String fullyQualifiedName, Node lhs, Node rhs) {
            super(fullyQualifiedName, lhs, rhs);
        }

        private void simplifyNamespace(AbstractCompiler compiler) {
            if (this.getRhs().isOr()) {
                Node objLit = this.getRhs().getLastChild().detach();
                this.getRhs().replaceWith(objLit);
                compiler.reportChangeToEnclosingScope(this.getLhs());
            }
        }

        private void simplifySymbol(AbstractCompiler compiler) {
            Preconditions.checkArgument((boolean)NodeUtil.isCallTo(this.getRhs(), "Symbol"));
            Node callNode = this.getRhs();
            while (callNode.hasMoreThanOneChild()) {
                NodeUtil.deleteNode(callNode.getLastChild(), compiler);
            }
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.getRhs() == null || this.shouldPreserve()) {
                return;
            }
            Node nameNode = this.getLhs();
            JSDocInfo jsdoc = this.getJsDoc();
            if (jsdoc != null && jsdoc.hasEnumParameterType()) {
                super.simplifyEnumValues(compiler);
                return;
            }
            if (NodeUtil.isNamespaceDecl(nameNode)) {
                this.simplifyNamespace(compiler);
                return;
            }
            if (nameNode.matchesName("exports")) {
                NameDeclaration.replaceRhsWithUnknown(this.getRhs());
                compiler.reportChangeToEnclosingScope(nameNode);
                return;
            }
            if (NodeUtil.isCallTo(this.getRhs(), "Symbol")) {
                this.simplifySymbol(compiler);
                return;
            }
            if (this.getLhs().getParent().isConst()) {
                jsdoc = JsdocUtil.markConstant(jsdoc);
            }
            Node newStatement = NodeUtil.newQNameDeclaration(compiler, nameNode.getQualifiedName(), null, jsdoc);
            newStatement.srcrefTreeIfMissing(nameNode);
            Node oldStatement = this.getRemovableNode();
            NodeUtil.deleteChildren(oldStatement, compiler);
            if (oldStatement.isExport()) {
                oldStatement.addChildToBack(newStatement);
            } else {
                oldStatement.replaceWith(newStatement);
            }
            compiler.reportChangeToEnclosingScope(newStatement);
        }

        @Override
        boolean breakDownDestructure(AbstractCompiler compiler) {
            if (!NodeUtil.isLhsByDestructuring(this.getLhs())) {
                return false;
            }
            Node rootTarget = NodeUtil.getRootTarget(this.getLhs());
            Preconditions.checkState((boolean)rootTarget.getParent().isDestructuringLhs());
            if (!NodeUtil.isNameDeclaration(rootTarget.getGrandparent())) {
                return false;
            }
            Node definitionNode = rootTarget.getGrandparent();
            Node prev = null;
            ArrayList lhsNodes = new ArrayList();
            NodeUtil.visitLhsNodesInNode(rootTarget.getParent(), lhsNodes::add);
            for (Node n : lhsNodes) {
                n.detach();
                Node temp = IR.var(n);
                if (prev == null) {
                    definitionNode.replaceWith(temp);
                    compiler.reportChangeToEnclosingScope(temp);
                } else {
                    temp.insertAfter(prev);
                    compiler.reportChangeToEnclosingScope(temp);
                    temp.srcrefTree(prev);
                }
                prev = temp;
            }
            return true;
        }

        private static void replaceRhsWithUnknown(Node rhs) {
            rhs.replaceWith(IR.cast(IR.number(0.0), JsdocUtil.getQmarkTypeJSDoc()).srcrefTree(rhs));
        }

        @Override
        boolean shouldPreserve() {
            Node rhs = this.getRhs();
            Node nameNode = this.getLhs();
            JSDocInfo jsdoc = this.getJsDoc();
            boolean isExport = PotentialDeclaration.isExportLhs(nameNode);
            return super.shouldPreserve() || NameDeclaration.isImportRhs(rhs) || isExport && rhs != null && (rhs.isQualifiedName() || rhs.isObjectLit()) || jsdoc != null && jsdoc.isConstructor() && rhs != null && rhs.isQualifiedName() || rhs != null && rhs.isObjectLit() && !rhs.hasChildren() && (jsdoc == null || !JsdocUtil.hasAnnotatedType(jsdoc)) || rhs != null && NodeUtil.isCallTo(rhs, "Polymer") || this.isPolymerBehaviorAliasOrArray();
        }

        boolean isPolymerBehaviorAliasOrArray() {
            JSDocInfo jsdoc = this.getJsDoc();
            Node rhs = this.getRhs();
            return jsdoc != null && jsdoc.isPolymerBehavior() && rhs != null && (rhs.isName() || rhs.isArrayLit());
        }
    }

    private static class MemberFieldDeclaration
    extends PotentialDeclaration {
        MemberFieldDeclaration(@Nullable String name, Node lhs, Node rhs) {
            super(name, lhs, rhs);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            Node rhs = this.getRhs();
            if (rhs != null) {
                NodeUtil.deleteNode(rhs, compiler);
            }
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class MethodDeclaration
    extends PotentialDeclaration {
        MethodDeclaration(String name, Node functionNode) {
            super(name, functionNode.getParent(), functionNode);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class PolymerBehaviorPropertiesDeclaration
    extends PotentialDeclaration {
        PolymerBehaviorPropertiesDeclaration(String name, Node stringKeyNode) {
            super(name, stringKeyNode, stringKeyNode.getLastChild());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.isDetached()) {
                return;
            }
            Node propertiesObject = this.getRhs();
            if (!propertiesObject.isObjectLit() || !propertiesObject.hasChildren()) {
                return;
            }
            for (Node propKey = propertiesObject.getFirstChild(); propKey != null; propKey = propKey.getNext()) {
                Node propDef = propKey.getOnlyChild();
                if (!propDef.isObjectLit()) continue;
                Node subProp = propDef.getFirstChild();
                while (subProp != null) {
                    Node next = subProp.getNext();
                    if (!subProp.getString().equals("type")) {
                        NodeUtil.deleteNode(subProp, compiler);
                    }
                    subProp = next;
                }
            }
        }

        @Override
        boolean shouldPreserve() {
            return true;
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class StringKeyDeclaration
    extends PotentialDeclaration {
        StringKeyDeclaration(String name, Node stringKeyNode) {
            super(name, stringKeyNode, stringKeyNode.getLastChild());
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            if (this.shouldPreserve()) {
                return;
            }
            JSDocInfo jsdoc = this.getJsDoc();
            if (jsdoc != null && jsdoc.hasEnumParameterType()) {
                super.simplifyEnumValues(compiler);
                return;
            }
            Node key = this.getLhs();
            PotentialDeclaration.removeStringKeyValue(key);
            compiler.reportChangeToEnclosingScope(key);
            if (jsdoc == null || !jsdoc.containsDeclaration() || this.isConstToBeInferred()) {
                key.setJSDocInfo(JsdocUtil.getUnusableTypeJSDoc(jsdoc));
            }
        }

        @Override
        boolean shouldPreserve() {
            return super.isDetached() || super.shouldPreserve() || !this.isInNamespace();
        }

        private boolean isInNamespace() {
            Node stringKey = this.getLhs();
            Node objLit = stringKey.getParent();
            Node lvalue = NodeUtil.getBestLValue(objLit);
            if (lvalue == null) {
                return false;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lvalue);
            return !PotentialDeclaration.isExportLhs(lvalue) && !JsdocUtil.hasAnnotatedType(jsdoc) && NodeUtil.isNamespaceDecl(lvalue);
        }

        @Override
        Node getRemovableNode() {
            return this.getLhs();
        }
    }

    private static class DefineDeclaration
    extends PotentialDeclaration {
        DefineDeclaration(String qualifiedName, Node lhs, Node rhs) {
            super(qualifiedName, lhs, rhs);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
            Node newRhs;
            JSDocInfo info = this.getJsDoc();
            if (info != null && info.getType() != null && (newRhs = DefineDeclaration.makeEmptyValueNode(info.getType())) != null) {
                this.getRhs().replaceWith(newRhs);
                compiler.reportChangeToEnclosingScope(newRhs);
                return;
            }
            NodeUtil.deleteNode(this.getRemovableNode(), compiler);
        }

        static DefineDeclaration from(Node callNode) {
            switch (callNode.getParent().getToken()) {
                case EXPR_RESULT: {
                    return new DefineDeclaration(callNode.getSecondChild().getString(), callNode, callNode.getLastChild());
                }
                case ASSIGN: {
                    Node previous = callNode.getPrevious();
                    return new DefineDeclaration(previous.getQualifiedName(), previous, callNode.getLastChild());
                }
                case NAME: {
                    Node parent = callNode.getParent();
                    return new DefineDeclaration(parent.getString(), parent, callNode.getLastChild());
                }
            }
            throw new IllegalStateException("Unexpected parent: " + callNode.getParent().getToken());
        }

        static @Nullable Node makeEmptyValueNode(JSTypeExpression type) {
            Node n;
            for (n = type.getRoot(); n != null && !n.isStringLit() && !n.isName(); n = n.getFirstChild()) {
            }
            switch (n != null ? n.getString() : "") {
                case "boolean": {
                    return new Node(Token.FALSE);
                }
                case "number": {
                    return Node.newNumber(0.0);
                }
                case "string": {
                    return Node.newString("");
                }
            }
            return null;
        }
    }

    private static class AliasDeclaration
    extends PotentialDeclaration {
        AliasDeclaration(String name, Node lhs) {
            super(name, lhs, null);
        }

        @Override
        void simplify(AbstractCompiler compiler) {
        }

        @Override
        Node getRemovableNode() {
            Node lhs = this.getLhs();
            if (lhs.getParent().isArrayPattern() && lhs.getParent().hasMoreThanOneChild()) {
                return lhs;
            }
            if (lhs.getGrandparent().isObjectPattern() && lhs.getGrandparent().hasMoreThanOneChild()) {
                return lhs.getParent();
            }
            return NodeUtil.getEnclosingStatement(lhs);
        }

        @Override
        boolean isDefiniteDeclaration(AbstractCompiler compiler) {
            return true;
        }

        @Override
        boolean shouldPreserve() {
            return true;
        }
    }
}

