/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.Invalidation;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import org.jspecify.nullness.Nullable;

final class PropertyClustering {
    private final String name;
    private final LinkedHashMap<Node, ColorGraphNode> useSites = new LinkedHashMap();
    private final StandardUnionFind<ColorGraphNode> clusters = new StandardUnionFind();
    private @Nullable ColorGraphNode originalNameClusterRep;
    private @Nullable Invalidation lastInvalidation;

    PropertyClustering(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    String getName() {
        return this.name;
    }

    LinkedHashMap<Node, ColorGraphNode> getUseSites() {
        return this.useSites;
    }

    StandardUnionFind<ColorGraphNode> getClusters() {
        return this.clusters;
    }

    @Nullable ColorGraphNode getOriginalNameClusterRep() {
        Preconditions.checkState((!this.isInvalidated() ? 1 : 0) != 0);
        return this.originalNameClusterRep == null ? null : this.clusters.find(this.originalNameClusterRep);
    }

    boolean isInvalidated() {
        return this.lastInvalidation != null;
    }

    void invalidate(Invalidation invalidation) {
        this.lastInvalidation = (Invalidation)Preconditions.checkNotNull((Object)invalidation);
    }

    Invalidation getLastInvalidation() {
        Preconditions.checkState((boolean)this.isInvalidated());
        return this.lastInvalidation;
    }

    void registerOriginalNameType(ColorGraphNode type) {
        Preconditions.checkState((!this.isInvalidated() ? 1 : 0) != 0);
        if (this.originalNameClusterRep == null) {
            this.originalNameClusterRep = type;
        }
        this.clusters.union(this.originalNameClusterRep, type);
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

