/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

class Invalidation {
    private final Reason reason;
    private static final Invalidation WELL_KNOWN_PROPERTY = new Invalidation(Reason.WELL_KNOWN_PROPERTY);

    static Invalidation wellKnownProperty() {
        return WELL_KNOWN_PROPERTY;
    }

    static Invalidation invalidatingType(int recieverType) {
        return new WithRecieverType(Reason.INVALIDATING_TYPE, recieverType);
    }

    static Invalidation undeclaredAccess(int recieverType) {
        return new WithRecieverType(Reason.UNDECLARED_ACCESS, recieverType);
    }

    private Invalidation(Reason reason) {
        this.reason = reason;
    }

    private static final class WithRecieverType
    extends Invalidation {
        final int recieverType;

        WithRecieverType(Reason reason, int recieverType) {
            super(reason);
            this.recieverType = recieverType;
        }
    }

    private static enum Reason {
        WELL_KNOWN_PROPERTY,
        INVALIDATING_TYPE,
        UNDECLARED_ACCESS;

    }
}

