/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public final class PathUtil {
    private static final CharMatcher SLASH_MATCHER = CharMatcher.is((char)'/');
    private static final CharMatcher NON_SLASH_MATCHER = CharMatcher.isNot((char)'/');

    private PathUtil() {
    }

    public static String collapseDots(String path) {
        if (!(path = PathUtil.removeExtraneousSlashes(path)).contains(".")) {
            return path;
        }
        ArrayList<String> dstFragments = new ArrayList<String>();
        for (String fragment : Splitter.on((char)'/').split((CharSequence)path)) {
            if (fragment.equals("..")) {
                if (dstFragments.isEmpty()) continue;
                dstFragments.remove(dstFragments.size() - 1);
                continue;
            }
            if (fragment.equals(".")) continue;
            dstFragments.add(fragment);
        }
        if (dstFragments.size() == 1 && ((String)dstFragments.get(0)).isEmpty()) {
            return "/";
        }
        return Joiner.on((String)"/").join(dstFragments);
    }

    static boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    static String removeExtraneousSlashes(String s) {
        int lastNonSlash = NON_SLASH_MATCHER.lastIndexIn((CharSequence)s);
        if (lastNonSlash != -1) {
            s = s.substring(0, lastNonSlash + 1);
        }
        return SLASH_MATCHER.collapseFrom((CharSequence)s, '/');
    }

    public static String makeAbsolute(String path) {
        return PathUtil.makeAbsolute(path, StandardSystemProperty.USER_DIR.value());
    }

    public static String makeAbsolute(String path, String rootPath) {
        if (!PathUtil.isAbsolute((String)path)) {
            path = rootPath + "/" + (String)path;
        }
        return PathUtil.collapseDots((String)path);
    }

    public static String makeRelative(String basePath, String targetPath) {
        if (PathUtil.isAbsolute(basePath) != PathUtil.isAbsolute(targetPath)) {
            throw new IllegalArgumentException("Paths must both be relative or both absolute.\n  basePath: " + basePath + "\n  targetPath: " + targetPath);
        }
        basePath = PathUtil.collapseDots(basePath);
        targetPath = PathUtil.collapseDots(targetPath);
        String[] baseFragments = basePath.split("/");
        String[] targetFragments = targetPath.split("/");
        int i = -1;
        do {
            if (++i == baseFragments.length && i == targetFragments.length) {
                return ".";
            }
            if (i == baseFragments.length) {
                return Joiner.on((String)"/").join((Iterable)Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
            }
            if (i != targetFragments.length) continue;
            return "../".repeat(baseFragments.length - i - 1) + "..";
        } while (baseFragments[i].equals(targetFragments[i]));
        return "../".repeat(baseFragments.length - i) + Joiner.on((String)"/").join((Iterable)Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
    }
}

