/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.deps.BrowserModuleResolver;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.deps.ModuleResolver;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public final class ModuleLoader {
    public static final DiagnosticType MODULE_CONFLICT = DiagnosticType.warning("JSC_MODULE_CONFLICT", "File cannot be a combination of goog.provide, goog.module, and/or ES6 module: {0}");
    public static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    public static final String JSC_BROWSER_SKIPLISTED_MARKER = "$jscomp$browser$skiplisted";
    public static final DiagnosticType LOAD_WARNING = DiagnosticType.error("JSC_JS_MODULE_LOAD_WARNING", "Failed to load module \"{0}\"");
    public static final DiagnosticType INVALID_MODULE_PATH = DiagnosticType.error("JSC_INVALID_MODULE_PATH", "Invalid module path \"{0}\" for resolution mode \"{1}\"");
    private ErrorHandler errorHandler;
    private final ImmutableList<String> moduleRootPaths;
    private final PathResolver pathResolver;
    private final PathEscaper pathEscaper;
    private final ModuleResolver moduleResolver;
    private static final Comparator<String> BEST_MATCH_PATH_ORDERING = Comparator.comparingInt(String::length).reversed().thenComparing(Comparator.naturalOrder());
    private static final ErrorHandler NOOP_ERROR_HANDER = (level, error) -> {};
    public static final ModuleLoader EMPTY = ModuleLoader.builder().setModuleRoots((Iterable<String>)ImmutableList.of()).setInputs((Iterable<? extends DependencyInfo>)ImmutableList.of()).setFactory(BrowserModuleResolver.FACTORY).build();

    public static Builder builder() {
        return new Builder();
    }

    private ModuleLoader(Builder builder) {
        this.errorHandler = (ErrorHandler)Preconditions.checkNotNull((Object)builder.errorHandler);
        this.pathResolver = (PathResolver)((Object)Preconditions.checkNotNull((Object)((Object)builder.pathResolver)));
        this.pathEscaper = (PathEscaper)((Object)Preconditions.checkNotNull((Object)((Object)builder.pathEscaper)));
        this.moduleRootPaths = this.createRootPaths((Iterable)Preconditions.checkNotNull(builder.moduleRoots));
        ImmutableSet<String> modulePaths = this.resolvePaths((Iterable)Preconditions.checkNotNull(builder.inputs));
        this.moduleResolver = builder.factory.create(modulePaths, this.moduleRootPaths, this.errorHandler, this.pathEscaper);
    }

    @VisibleForTesting
    public Map<String, String> getPackageJsonMainEntries() {
        return this.moduleResolver.getPackageJsonMainEntries();
    }

    public ModulePath resolve(String path) {
        return new ModulePath(ModuleLoader.normalize(this.pathEscaper.escape((String)this.pathResolver.apply(path)), this.moduleRootPaths));
    }

    public static boolean isRelativeIdentifier(String name) {
        return name.startsWith(DEFAULT_FILENAME_PREFIX) || name.startsWith("../");
    }

    public static boolean isAbsoluteIdentifier(String name) {
        return name.startsWith(MODULE_SLASH);
    }

    public static boolean isAmbiguousIdentifier(String name) {
        return !ModuleLoader.isAbsoluteIdentifier(name) && !ModuleLoader.isRelativeIdentifier(name);
    }

    public static boolean isPathIdentifier(String name) {
        return name.contains(MODULE_SLASH);
    }

    private ImmutableList<String> createRootPaths(Iterable<String> roots) {
        return ((ImmutableSortedSet)Streams.stream(roots).map(this.pathResolver).map(this.pathEscaper::escape).map(n -> ModuleLoader.isAmbiguousIdentifier(n) ? MODULE_SLASH + n : n).collect(ImmutableSortedSet.toImmutableSortedSet(BEST_MATCH_PATH_ORDERING))).asList();
    }

    private ImmutableSet<String> resolvePaths(Iterable<? extends DependencyInfo> inputs) {
        ImmutableMultiset dupeModulePaths = (ImmutableMultiset)Streams.stream(inputs).map(DependencyInfo::getName).map(this.pathResolver).map(this.pathEscaper::escape).map(p -> ModuleLoader.normalize(p, this.moduleRootPaths)).map(n -> ModuleLoader.isAmbiguousIdentifier(n) ? MODULE_SLASH + n : n).sorted(BEST_MATCH_PATH_ORDERING).collect(ImmutableMultiset.toImmutableMultiset());
        Preconditions.checkState((dupeModulePaths.size() == dupeModulePaths.elementSet().size() ? 1 : 0) != 0, (String)"Duplicate module paths after resolving: %s", (Object)dupeModulePaths);
        return dupeModulePaths.elementSet();
    }

    static String normalize(String path, Iterable<String> moduleRootPaths) {
        Object normalizedPath = path;
        if (ModuleLoader.isAmbiguousIdentifier((String)normalizedPath)) {
            normalizedPath = MODULE_SLASH + (String)normalizedPath;
        }
        for (String moduleRoot : moduleRootPaths) {
            String trailing;
            if (!((String)normalizedPath).startsWith(moduleRoot) || !(trailing = ((String)normalizedPath).substring(moduleRoot.length())).startsWith(MODULE_SLASH)) continue;
            return trailing.substring(MODULE_SLASH.length());
        }
        return path;
    }

    public static String relativePathFrom(String fromUriPath, String toUriPath) {
        Path fromPath = Path.of(fromUriPath, new String[0]);
        Path toPath = Path.of(toUriPath, new String[0]);
        Path fromFolder = fromPath.getParent();
        if (fromFolder == null && toPath.getParent() == null) {
            return DEFAULT_FILENAME_PREFIX + toUriPath;
        }
        if (fromFolder == null && (toUriPath.startsWith(".") || toPath.toString().startsWith(MODULE_SLASH) || toPath.toString().startsWith("\\"))) {
            return toUriPath;
        }
        if (fromFolder == null) {
            throw new IllegalArgumentException("Relative path between URIs cannot be calculated");
        }
        String calculatedPath = fromFolder.relativize(toPath).toString();
        if (calculatedPath.startsWith(".") || calculatedPath.startsWith(MODULE_SLASH)) {
            return calculatedPath;
        }
        return DEFAULT_FILENAME_PREFIX + calculatedPath;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler == null ? NOOP_ERROR_HANDER : errorHandler;
        this.moduleResolver.setErrorHandler(this.errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public static final class Builder {
        private ErrorHandler errorHandler = NOOP_ERROR_HANDER;
        private Iterable<String> moduleRoots;
        private Iterable<? extends DependencyInfo> inputs;
        private ModuleResolverFactory factory;
        private PathResolver pathResolver = PathResolver.RELATIVE;
        private PathEscaper pathEscaper = PathEscaper.ESCAPE;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setErrorHandler(ErrorHandler x) {
            if (x != null) {
                this.errorHandler = x;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setModuleRoots(Iterable<String> x) {
            this.moduleRoots = x;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInputs(Iterable<? extends DependencyInfo> x) {
            this.inputs = x;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFactory(ModuleResolverFactory x) {
            this.factory = x;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPathResolver(PathResolver x) {
            this.pathResolver = x;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPathEscaper(PathEscaper x) {
            this.pathEscaper = x;
            return this;
        }

        public ModuleLoader build() {
            return new ModuleLoader(this);
        }
    }

    public static enum PathResolver implements Function<String, String>
    {
        RELATIVE{

            public String apply(String path) {
                return path;
            }
        }
        ,
        ABSOLUTE{

            public String apply(String path) {
                return Path.of(path, new String[0]).toAbsolutePath().toString();
            }
        };

    }

    public static enum PathEscaper {
        ESCAPE{

            @Override
            public String escape(String path) {
                return ModuleNames.escapePath(path);
            }
        }
        ,
        CANONICALIZE_ONLY{

            @Override
            public String escape(String path) {
                return ModuleNames.canonicalizePath(path);
            }
        };


        public abstract String escape(String var1);
    }

    @FunctionalInterface
    public static interface ModuleResolverFactory {
        public ModuleResolver create(ImmutableSet<String> var1, ImmutableList<String> var2, ErrorHandler var3, PathEscaper var4);
    }

    public class ModulePath {
        private final String path;

        private ModulePath(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }

        public boolean equalsIgnoreLeadingSlash(ModulePath other) {
            return other != null && this.toModuleName().equals(other.toModuleName());
        }

        public String toModuleName() {
            return ModuleNames.toModuleName(this.path);
        }

        public @Nullable ModulePath resolveJsModule(String moduleAddress, String sourcename, int lineno, int colno) {
            String loadAddress = ModuleLoader.this.moduleResolver.resolveJsModule(this.path, moduleAddress, sourcename, lineno, colno);
            if (loadAddress != null) {
                return new ModulePath(loadAddress);
            }
            return null;
        }

        public ModulePath resolveModuleAsPath(String moduleAddress) {
            return new ModulePath(ModuleLoader.this.moduleResolver.resolveModuleAsPath(this.path, moduleAddress));
        }
    }

    public static enum ResolutionMode {
        BROWSER,
        BROWSER_WITH_TRANSFORMED_PREFIXES,
        NODE,
        WEBPACK;

    }
}

