/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.util.regex")
public final class DepsFileRegexParser
extends JsFileLineParser {
    private static final Logger logger = Logger.getLogger(DepsFileRegexParser.class.getName());
    private final Matcher depMatcher = Pattern.compile("\\s*goog.addDependency\\((.*)\\);?\\s*").matcher("");
    private final Matcher depArgsMatch = Pattern.compile("\\s*([^,]*), (\\[[^\\]]*\\]), (\\[[^\\]]*\\])(?:, (true|false|\\{[^{}]*\\}))?\\s*").matcher("");
    private List<DependencyInfo> depInfos;
    private final Function<String, String> pathTranslator;

    public DepsFileRegexParser(ErrorManager errorManager) {
        this((Function<String, String>)Functions.identity(), errorManager);
    }

    public DepsFileRegexParser(Function<String, String> pathTranslator, ErrorManager errorManager) {
        super(errorManager);
        this.pathTranslator = pathTranslator;
    }

    public List<DependencyInfo> parseFile(String filePath) throws IOException {
        return this.parseFileReader(filePath, Files.newReader((File)new File(filePath), (Charset)StandardCharsets.UTF_8));
    }

    public List<DependencyInfo> parseFile(String filePath, String fileContents) {
        return this.parseFileReader(filePath, new StringReader(fileContents));
    }

    public List<DependencyInfo> parseFileReader(String filePath, Reader reader) {
        this.depInfos = new ArrayList<DependencyInfo>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parsing Dep: " + filePath);
        }
        this.doParse(filePath, reader);
        return this.depInfos;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean hasDependencies = false;
        if (line.contains("addDependency")) {
            this.depMatcher.reset(line);
            if (this.depMatcher.matches()) {
                hasDependencies = true;
                String addDependencyParams = this.depMatcher.group(1);
                this.depArgsMatch.reset(addDependencyParams);
                if (!this.depArgsMatch.matches()) {
                    throw new JsFileLineParser.ParseException("Invalid arguments to goog.addDependency(). Found: " + addDependencyParams, true);
                }
                String relativePath = this.parseJsString(this.depArgsMatch.group(1));
                String path = (String)this.pathTranslator.apply((Object)relativePath);
                List<String> provides = this.parseJsStringArray(this.depArgsMatch.group(2));
                Map<String, String> loadFlags = this.parseLoadFlags(this.depArgsMatch.group(4));
                if ("es6".equals(loadFlags.get("module"))) {
                    provides.add(relativePath);
                }
                SimpleDependencyInfo depInfo = SimpleDependencyInfo.builder(path, this.filePath).setProvides(provides).setRequires((Collection)this.parseJsStringArray(this.depArgsMatch.group(3)).stream().map(DependencyInfo.Require::parsedFromDeps).collect(ImmutableList.toImmutableList())).setLoadFlags(loadFlags).build();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found dep: " + depInfo);
                }
                this.depInfos.add(depInfo);
            }
        }
        return !this.shortcutMode || hasDependencies || CharMatcher.whitespace().matchesAllOf((CharSequence)line);
    }

    private Map<String, String> parseLoadFlags(String loadFlags) throws JsFileLineParser.ParseException {
        if (loadFlags == null || loadFlags.equals("false")) {
            return ImmutableMap.of();
        }
        if (loadFlags.equals("true")) {
            return ImmutableMap.of((Object)"module", (Object)"goog");
        }
        return this.parseJsStringMap(loadFlags);
    }
}

