/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.deps.DependencyFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.DependencyResolver;
import com.google.javascript.jscomp.deps.JsFileRegexParser;
import com.google.javascript.jscomp.deps.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jspecify.nullness.Nullable;

public final class DefaultDependencyResolver
implements DependencyResolver {
    static final String CLOSURE_BASE = "base.js";
    static final String CLOSURE_BASE_PROVIDE = "goog";
    private final List<DependencyFile> depsFiles;
    private final boolean strictRequires;
    private static final Logger logger = Logger.getLogger(DefaultDependencyResolver.class.getName());

    public DefaultDependencyResolver(List<DependencyFile> depsFiles, boolean strictRequires) {
        this.depsFiles = depsFiles;
        this.strictRequires = strictRequires;
    }

    public List<String> getDependencies(String code) throws ServiceException {
        return this.getDependencies((Collection)DefaultDependencyResolver.parseRequires(code, true));
    }

    public List<String> getDependencies(Collection<String> symbols) throws ServiceException {
        return this.getDependencies((Collection)symbols, (Set)new HashSet());
    }

    public List<String> getDependencies(String code, Set<String> seen, boolean addClosureBaseFile) throws ServiceException {
        return this.getDependencies((Collection)DefaultDependencyResolver.parseRequires(code, addClosureBaseFile), (Set)seen);
    }

    public List<String> getDependencies(Collection<String> symbols, Set<String> seen) throws ServiceException {
        ArrayList<String> list = new ArrayList<String>();
        for (DependencyFile depsFile : this.depsFiles) {
            depsFile.ensureUpToDate();
        }
        for (String symbol : symbols) {
            this.addDependency(symbol, seen, list);
        }
        return list;
    }

    private void addDependency(String symbol, Set<String> seen, List<String> list) throws ServiceException {
        DependencyInfo dependency = this.getDependencyInfo(symbol);
        if (dependency == null) {
            if (this.strictRequires) {
                throw new ServiceException("Unknown require of " + symbol);
            }
        } else if (!seen.containsAll((Collection<?>)dependency.getProvides())) {
            seen.addAll((Collection<String>)dependency.getProvides());
            for (String require : dependency.getRequiredSymbols()) {
                this.addDependency(require, seen, list);
            }
            list.add(dependency.getPathRelativeToClosureBase());
        }
    }

    private static Collection<String> parseRequires(String code, boolean addClosureBase) {
        LoggerErrorManager errorManager = new LoggerErrorManager(logger);
        JsFileRegexParser parser = new JsFileRegexParser(errorManager);
        DependencyInfo deps = parser.parseFile("<unknown path>", "<unknown path>", code);
        ArrayList<String> requires = new ArrayList<String>();
        if (addClosureBase) {
            requires.add(CLOSURE_BASE_PROVIDE);
        }
        requires.addAll((Collection<String>)deps.getRequiredSymbols());
        errorManager.generateReport();
        return requires;
    }

    private @Nullable DependencyInfo getDependencyInfo(String symbol) {
        for (DependencyFile depsFile : this.depsFiles) {
            DependencyInfo di = depsFile.getDependencyInfo(symbol);
            if (di == null) continue;
            return di;
        }
        return null;
    }
}

