/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

final class Timeline<T> {
    private final Map<Time, Event<Time>> eventsByTime = new LinkedHashMap<Time, Event<Time>>();
    private final Map<T, Event<T>> eventsByValue = new LinkedHashMap<T, Event<T>>();
    private Event<?> headEvent = new Event<Time>(new Time("-beginning-"));

    Timeline() {
    }

    void add(T value) {
        this.addEvent(value, this.eventsByValue);
    }

    void remove(T value) {
        Event<T> event = this.eventsByValue.remove(value);
        if (event != null) {
            if (event.nextEvent != null) {
                event.nextEvent.previousEvent = event.previousEvent;
            } else {
                this.headEvent = event.previousEvent;
            }
            event.previousEvent.nextEvent = event.nextEvent;
            event.nextEvent = null;
            event.previousEvent = null;
        }
    }

    void mark(String timeName) {
        this.addEvent(new Time(timeName), this.eventsByTime);
    }

    @Nullable List<T> getSince(String timeName) {
        ArrayList values = new ArrayList();
        Event<Time> firstEvent = this.eventsByTime.get(new Time(timeName));
        if (firstEvent == null) {
            return null;
        }
        Event<Time> event = firstEvent;
        while (event != null) {
            if (!(event.value instanceof Time)) {
                values.add(event.value);
            }
            event = event.nextEvent;
        }
        return values;
    }

    private <V> void addEvent(V value, Map<V, Event<V>> eventsByKey) {
        Event<V> event = eventsByKey.get(value);
        if (this.headEvent == event) {
            return;
        }
        if (event != null) {
            event.previousEvent.nextEvent = event.nextEvent;
            event.nextEvent.previousEvent = event.previousEvent;
            event.nextEvent = null;
        } else {
            event = new Event<V>(value);
            eventsByKey.put((Event<V>)value, (Event<Event<V>>)event);
        }
        event.previousEvent = this.headEvent;
        this.headEvent.nextEvent = event;
        this.headEvent = event;
    }

    private static class Event<T> {
        @Nullable Event<?> nextEvent;
        @Nullable Event<?> previousEvent;
        final T value;

        Event(T value) {
            Preconditions.checkNotNull(value);
            this.value = value;
        }
    }

    private static class Time {
        final String name;

        Time(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof Time) {
                return this.name.equals(((Time)anObject).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

