/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

@CheckReturnValue
final class SynthesizeExplicitConstructors {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;

    SynthesizeExplicitConstructors(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    void synthesizeClassConstructorIfMissing(NodeTraversal t, Node classNode) {
        Preconditions.checkArgument((boolean)classNode.isClass());
        if (NodeUtil.getEs6ClassConstructorMemberFunctionDef(classNode) == null) {
            this.addSyntheticConstructor(t, classNode);
        }
    }

    private void addSyntheticConstructor(NodeTraversal t, Node classNode) {
        Node memberDef;
        Node superClass = classNode.getSecondChild();
        Node classMembers = classNode.getLastChild();
        if (superClass.isEmpty()) {
            Node function = this.astFactory.createEmptyFunction(AstFactory.type(classNode));
            this.compiler.reportChangeToChangeScope(function);
            memberDef = this.astFactory.createMemberFunctionDef("constructor", function);
        } else {
            Preconditions.checkState((boolean)superClass.isQualifiedName(), (String)"Expected Es6RewriteClassExtendsExpressions to make all extends clauses into qualified names, found %s", (Object)superClass);
            Node body = IR.block();
            if (!classNode.isFromExterns() && !this.isInterface(classNode)) {
                Node exprResult = IR.exprResult(this.astFactory.createConstructorCall(AstFactory.type(classNode), this.astFactory.createSuper(AstFactory.type(superClass)), IR.iterSpread(this.astFactory.createArgumentsReference())));
                body.addChildToFront(exprResult);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.SUPER, this.compiler);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.SPREAD_EXPRESSIONS, this.compiler);
            }
            Node constructor = this.astFactory.createFunction("", IR.paramList(new Node[0]), body, AstFactory.type(classNode));
            memberDef = this.astFactory.createMemberFunctionDef("constructor", constructor);
        }
        memberDef.srcrefTreeIfMissing(classNode);
        memberDef.makeNonIndexableRecursive();
        classMembers.addChildToFront(memberDef);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.MEMBER_DECLARATIONS, this.compiler);
        this.compiler.reportChangeToChangeScope(memberDef.getOnlyChild());
        this.compiler.reportChangeToEnclosingScope(memberDef);
    }

    private boolean isInterface(Node classNode) {
        JSDocInfo classJsDocInfo = NodeUtil.getBestJSDocInfo(classNode);
        return classJsDocInfo != null && classJsDocInfo.isInterface();
    }
}

