/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

class SuppressDocWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final ImmutableMap<String, DiagnosticGroup> suppressors;
    private final AbstractCompiler compiler;

    SuppressDocWarningsGuard(AbstractCompiler compiler, Map<String, DiagnosticGroup> suppressors) {
        this.compiler = compiler;
        this.suppressors = SuppressDocWarningsGuard.createSuppressors(suppressors);
    }

    private static ImmutableMap<String, DiagnosticGroup> createSuppressors(Map<String, DiagnosticGroup> suppressors) {
        LinkedHashMap<String, DiagnosticGroup> builder = new LinkedHashMap<String, DiagnosticGroup>(suppressors);
        builder.put("missingProperties", new DiagnosticGroup(DiagnosticGroups.MISSING_PROPERTIES, DiagnosticGroups.STRICT_MISSING_PROPERTIES));
        builder.put("checkTypes", new DiagnosticGroup(DiagnosticGroups.CHECK_TYPES, DiagnosticGroups.STRICT_CHECK_TYPES));
        return ImmutableMap.copyOf(builder);
    }

    @Override
    public @Nullable CheckLevel level(JSError error) {
        JSDocInfo info;
        Node node = error.getNode();
        if (node == null) {
            node = this.getScriptNodeBySourceName(error);
        }
        if (node == null) {
            return null;
        }
        CheckLevel level = this.getCheckLevelFromAncestors(error, node);
        if (level != null) {
            return level;
        }
        Node scriptNode = this.getScriptNodeBySourceName(error);
        if (scriptNode != null && (info = scriptNode.getJSDocInfo()) != null) {
            return this.getCheckLevelFromInfo(error, info);
        }
        return null;
    }

    private @Nullable CheckLevel getCheckLevelFromAncestors(JSError error, Node node) {
        for (Node current = node; current != null; current = current.getParent()) {
            CheckLevel level;
            JSDocInfo info = null;
            if (current.isFunction() || current.isClass()) {
                info = NodeUtil.getBestJSDocInfo(current);
            } else if (current.isScript()) {
                info = current.getJSDocInfo();
            } else if (NodeUtil.isNameDeclaration(current) || NodeUtil.mayBeObjectLitKey(current) || current.isComputedProp() || current.isMemberFieldDef() || current.isComputedFieldDef() || current.hasParent() && current.getParent().isExprResult()) {
                info = NodeUtil.getBestJSDocInfo(current);
            }
            if (info == null || (level = this.getCheckLevelFromInfo(error, info)) == null) continue;
            return level;
        }
        return null;
    }

    private @Nullable CheckLevel getCheckLevelFromInfo(JSError error, JSDocInfo info) {
        for (String suppressor : info.getSuppressions()) {
            DiagnosticGroup group = (DiagnosticGroup)this.suppressors.get((Object)suppressor);
            if (group == null || !group.matches(error)) continue;
            return CheckLevel.OFF;
        }
        return null;
    }

    private final @Nullable Node getScriptNodeBySourceName(JSError error) {
        if (error.getSourceName() == null) {
            return null;
        }
        Node scriptNode = this.compiler.getScriptNode(error.getSourceName());
        if (scriptNode == null) {
            return null;
        }
        Preconditions.checkState((boolean)scriptNode.isScript());
        return scriptNode;
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_DOC.value;
    }
}

