/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

final class RewriteNewDotTarget
implements CompilerPass {
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.NEW_TARGET);
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;

    RewriteNewDotTarget(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, new RewriteNewDotTargetCallback());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, TRANSPILED_FEATURES);
    }

    private class RewriteNewDotTargetCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteNewDotTargetCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getToken() == Token.NEW_TARGET) {
                Node enclosingNonArrowFunction = NodeUtil.getEnclosingNonArrowFunction(n);
                if (enclosingNonArrowFunction != null && NodeUtil.isEs6Constructor(enclosingNonArrowFunction)) {
                    Node enclosingClass = enclosingNonArrowFunction.getParent().getGrandparent();
                    n.replaceWith(RewriteNewDotTarget.this.astFactory.createGetProp(RewriteNewDotTarget.this.astFactory.createThisForEs6Class(enclosingClass), "constructor", AstFactory.type(n)).srcrefTree(n));
                    t.reportCodeChange();
                } else {
                    TranspilationUtil.cannotConvertYet(RewriteNewDotTarget.this.compiler, n, "new.target");
                }
            }
        }
    }
}

