/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class RewriteAsyncIteration
implements NodeTraversal.Callback,
CompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    static final DiagnosticType CANNOT_CONVERT_ASYNCGEN = DiagnosticType.error("JSC_CANNOT_CONVERT_ASYNCGEN", "Cannot convert async generator. {0}");
    private static final String ACTION_RECORD_NAME = "$jscomp.AsyncGeneratorWrapper$ActionRecord";
    private static final String ACTION_ENUM_AWAIT = "$jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE";
    private static final String ACTION_ENUM_YIELD = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE";
    private static final String ACTION_ENUM_YIELD_STAR = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR";
    private static final String FOR_AWAIT_ITERATOR_TEMP_NAME = "$jscomp$forAwait$tempIterator";
    private static final String FOR_AWAIT_RESULT_TEMP_NAME = "$jscomp$forAwait$tempResult";
    private static final String FOR_AWAIT_ERROR_RESULT_TEMP_NAME = "$jscomp$forAwait$errResult";
    private static final String FOR_AWAIT_CATCH_PARAM_TEMP_NAME = "$jscomp$forAwait$catchErrParam";
    private static final String FOR_AWAIT_RETURN_FN_TEMP_NAME = "$jscomp$forAwait$retFn";
    private int nextForAwaitId = 0;
    private final AbstractCompiler compiler;
    private final ArrayDeque<LexicalContext> contextStack;
    private static final String THIS_VAR_NAME = "$jscomp$asyncIter$this";
    private static final String ARGUMENTS_VAR_NAME = "$jscomp$asyncIter$arguments";
    private static final String SUPER_PROP_GETTER_PREFIX = "$jscomp$asyncIter$super$get$";
    private final AstFactory astFactory;
    private final StaticScope namespace;

    private RewriteAsyncIteration(AbstractCompiler compiler, AstFactory astFactory, StaticScope namespace) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.astFactory = (AstFactory)Preconditions.checkNotNull((Object)astFactory);
        this.namespace = (StaticScope)Preconditions.checkNotNull((Object)namespace);
        this.contextStack = new ArrayDeque();
    }

    static RewriteAsyncIteration create(AbstractCompiler compiler) {
        AstFactory astFactory = compiler.createAstFactory();
        StaticScope namespace = compiler.getTranspilationNamespace();
        return new RewriteAsyncIteration(compiler, astFactory, namespace);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.contextStack.isEmpty());
        this.contextStack.push(LexicalContext.newGlobalContext(root));
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, transpiledFeatures);
        Preconditions.checkState((this.contextStack.element().function == null ? 1 : 0) != 0);
        this.contextStack.remove();
        Preconditions.checkState((boolean)this.contextStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.push(LexicalContext.newContextForFunction(this.contextStack.element(), n));
        } else if (n.isParamList()) {
            this.contextStack.push(LexicalContext.newContextForParamList(this.contextStack.element(), n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext ctx = this.contextStack.element();
        switch (n.getToken()) {
            case PARAM_LIST: {
                Preconditions.checkState((boolean)n.equals(ctx.contextRoot), (Object)n);
                this.contextStack.pop();
                break;
            }
            case FUNCTION: {
                Preconditions.checkState((boolean)n.equals(ctx.contextRoot));
                if (n.isAsyncGeneratorFunction()) {
                    this.convertAsyncGenerator(n);
                    this.prependTempVarDeclarations(ctx, t);
                }
                this.contextStack.pop();
                break;
            }
            case AWAIT: {
                Preconditions.checkNotNull((Object)ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertAwaitOfAsyncGenerator(ctx, n);
                break;
            }
            case YIELD: {
                Preconditions.checkNotNull((Object)ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertYieldOfAsyncGenerator(ctx, n);
                break;
            }
            case RETURN: {
                Preconditions.checkNotNull((Object)ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertReturnOfAsyncGenerator(ctx, n);
                break;
            }
            case FOR_AWAIT_OF: {
                Preconditions.checkNotNull((Object)ctx.function);
                Preconditions.checkState((boolean)ctx.function.isAsyncFunction());
                this.replaceForAwaitOf(ctx, n);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
                break;
            }
            case THIS: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceThis(ctx, n);
                break;
            }
            case NAME: {
                if (!ctx.mustReplaceThisSuperArgs() || !n.matchesName("arguments")) break;
                this.replaceArguments(ctx, n);
                break;
            }
            case SUPER: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceSuper(ctx, n, parent);
                break;
            }
        }
    }

    private void convertAsyncGenerator(Node originalFunction) {
        Preconditions.checkNotNull((Object)originalFunction);
        Preconditions.checkState((boolean)originalFunction.isAsyncGeneratorFunction());
        Node asyncGeneratorWrapperRef = this.astFactory.createQName(this.namespace, "$jscomp.AsyncGeneratorWrapper");
        Node innerFunction = this.astFactory.createEmptyAsyncGeneratorWrapperArgument(null);
        Node innerBlock = originalFunction.getLastChild();
        innerBlock.detach();
        innerFunction.getLastChild().replaceWith(innerBlock);
        Node outerBlock = this.astFactory.createBlock(this.astFactory.createReturn(this.astFactory.createNewNode(asyncGeneratorWrapperRef, this.astFactory.createCall(innerFunction, AstFactory.type(StandardColors.GENERATOR_ID), new Node[0]))));
        originalFunction.addChildToBack(outerBlock);
        originalFunction.setIsAsyncFunction(false);
        originalFunction.setIsGeneratorFunction(false);
        originalFunction.srcrefTreeIfMissing(originalFunction);
        this.compiler.reportChangeToChangeScope(originalFunction);
        this.compiler.reportChangeToChangeScope(innerFunction);
    }

    private void convertAwaitOfAsyncGenerator(LexicalContext ctx, Node awaitNode) {
        Preconditions.checkNotNull((Object)awaitNode);
        Preconditions.checkState((boolean)awaitNode.isAwait());
        Preconditions.checkState((ctx != null && ctx.function != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)ctx.function.isAsyncGeneratorFunction());
        Node expression = awaitNode.removeFirstChild();
        Preconditions.checkNotNull((Object)expression, (Object)"await needs an expression");
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), this.astFactory.createQName(this.namespace, ACTION_ENUM_AWAIT), expression);
        newActionRecord.srcrefTreeIfMissing(awaitNode);
        awaitNode.addChildToFront(newActionRecord);
        awaitNode.setToken(Token.YIELD);
    }

    private void convertYieldOfAsyncGenerator(LexicalContext ctx, Node yieldNode) {
        Preconditions.checkNotNull((Object)yieldNode);
        Preconditions.checkState((boolean)yieldNode.isYield());
        Preconditions.checkState((ctx != null && ctx.function != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)ctx.function.isAsyncGeneratorFunction());
        Node expression = yieldNode.removeFirstChild();
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), new Node[0]);
        if (yieldNode.isYieldAll()) {
            Preconditions.checkNotNull((Object)expression);
            newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD_STAR));
            newActionRecord.addChildToBack(expression);
        } else {
            if (expression == null) {
                expression = NodeUtil.newUndefinedNode(null);
            }
            newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD));
            newActionRecord.addChildToBack(expression);
        }
        newActionRecord.srcrefTreeIfMissing(yieldNode);
        yieldNode.addChildToFront(newActionRecord);
        yieldNode.putBooleanProp(Node.YIELD_ALL, false);
    }

    private void convertReturnOfAsyncGenerator(LexicalContext ctx, Node returnNode) {
        Preconditions.checkNotNull((Object)returnNode);
        Preconditions.checkState((boolean)returnNode.isReturn());
        Preconditions.checkState((ctx != null && ctx.function != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)ctx.function.isAsyncGeneratorFunction());
        Node expression = returnNode.removeFirstChild();
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), new Node[0]);
        if (expression == null) {
            expression = NodeUtil.newUndefinedNode(null);
        }
        newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD));
        newActionRecord.addChildToBack(expression);
        newActionRecord.srcrefTreeIfMissing(returnNode);
        returnNode.addChildToFront(newActionRecord);
    }

    private void replaceForAwaitOf(LexicalContext ctx, Node forAwaitOf) {
        Node lhsAssignment;
        AstFactory.Type resultType;
        Node replacementPoint;
        int forAwaitId = this.nextForAwaitId++;
        String iteratorTempName = FOR_AWAIT_ITERATOR_TEMP_NAME + forAwaitId;
        String resultTempName = FOR_AWAIT_RESULT_TEMP_NAME + forAwaitId;
        String errorResultTempName = FOR_AWAIT_ERROR_RESULT_TEMP_NAME + forAwaitId;
        String catchErrorParamTempName = FOR_AWAIT_CATCH_PARAM_TEMP_NAME + forAwaitId;
        String returnFuncTempName = FOR_AWAIT_RETURN_FN_TEMP_NAME + forAwaitId;
        Preconditions.checkState((boolean)forAwaitOf.hasParent(), (Object)"Cannot replace parentless for-await-of");
        Node forAwaitOfParent = forAwaitOf.getParent();
        if (forAwaitOfParent.isLabel()) {
            Preconditions.checkState((boolean)forAwaitOf.isSecondChildOf(forAwaitOfParent), (Object)forAwaitOfParent);
            replacementPoint = forAwaitOfParent;
        } else {
            replacementPoint = forAwaitOf;
        }
        Node lhs = forAwaitOf.removeFirstChild();
        Node rhs = forAwaitOf.removeFirstChild();
        Node originalBody = forAwaitOf.removeFirstChild();
        Node initializer = this.astFactory.createSingleVarNameDeclaration(iteratorTempName, this.astFactory.createJSCompMakeAsyncIteratorCall(rhs, this.namespace)).srcrefTreeIfMissing(rhs);
        AstFactory.Type iterableResultType = AstFactory.type(StandardColors.TOP_OBJECT);
        Node breakIfDone = this.astFactory.createIf(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "done", AstFactory.type(StandardColors.BOOLEAN)), this.astFactory.createBlock(this.astFactory.createBreak()));
        if (lhs.isValidAssignmentTarget()) {
            resultType = AstFactory.type(lhs);
            lhsAssignment = this.astFactory.exprResult(this.astFactory.createAssign(lhs, this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType)));
        } else if (NodeUtil.isNameDeclaration(lhs)) {
            Node declarationTarget = lhs.getFirstChild();
            if (declarationTarget.isName()) {
                resultType = AstFactory.type(declarationTarget);
                declarationTarget.addChildToBack(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType));
            } else {
                Preconditions.checkState((boolean)declarationTarget.isDestructuringLhs(), (Object)declarationTarget);
                Node destructuringPattern = declarationTarget.getOnlyChild();
                resultType = AstFactory.type(destructuringPattern);
                declarationTarget.addChildToBack(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType));
            }
            lhsAssignment = lhs;
        } else {
            throw new AssertionError((Object)"unexpected for-await-of lhs");
        }
        lhsAssignment.srcrefTreeIfMissing(lhs);
        Node errorResDecl = this.astFactory.createSingleVarNameDeclaration(errorResultTempName).srcrefTreeIfMissing(forAwaitOf);
        Node tempResultDecl = this.astFactory.createSingleVarNameDeclaration(resultTempName).srcrefTreeIfMissing(forAwaitOf);
        Node returnFuncDecl = this.astFactory.createSingleVarNameDeclaration(returnFuncTempName).srcrefTreeIfMissing(forAwaitOf);
        Node resultDeclaration = this.astFactory.exprResult(this.astFactory.createAssign(resultTempName, this.constructAwaitNextResult(ctx, iteratorTempName, resultType, iterableResultType)));
        Node newForLoop = this.astFactory.createFor(this.astFactory.createEmpty(), this.astFactory.createEmpty(), this.astFactory.createEmpty(), this.astFactory.createBlock(resultDeclaration, breakIfDone, lhsAssignment, this.ensureBlock(originalBody)));
        if (replacementPoint.isLabel()) {
            newForLoop = this.astFactory.createLabel(replacementPoint.getFirstChild().cloneNode(), newForLoop);
        }
        Node tryNode = this.createOuterTry(newForLoop);
        initializer.insertBefore(newForLoop);
        Node catchNode = this.createOuterCatch(catchErrorParamTempName, errorResultTempName);
        Node finallyNode = this.createOuterFinally(ctx, iterableResultType, resultType, resultTempName, returnFuncTempName, iteratorTempName, errorResultTempName);
        Node tryCatchFinally = this.astFactory.createTryCatchFinally(tryNode, catchNode, finallyNode);
        replacementPoint.replaceWith(tryCatchFinally);
        tryCatchFinally.srcrefTreeIfMissing(replacementPoint);
        errorResDecl.insertBefore(tryCatchFinally);
        tempResultDecl.insertBefore(tryCatchFinally);
        returnFuncDecl.insertBefore(tryCatchFinally);
        this.compiler.reportChangeToEnclosingScope(tryCatchFinally);
    }

    private Node createOuterTry(Node newForLoop) {
        Node tryNode = this.astFactory.createBlock(new Node[0]);
        tryNode.addChildToBack(newForLoop);
        return tryNode;
    }

    private Node createOuterCatch(String catchErrorParamTempName, String errorResultTempName) {
        Node catchBodyStmt = this.astFactory.exprResult(this.astFactory.createAssign(errorResultTempName, this.astFactory.createObjectLit(this.astFactory.createStringKey("error", this.astFactory.createNameWithUnknownType(catchErrorParamTempName)))));
        Node wrapperCatchBlockNode = this.astFactory.createBlock(new Node[0]);
        wrapperCatchBlockNode.addChildToBack(catchBodyStmt);
        return this.astFactory.createCatch(this.astFactory.createNameWithUnknownType(catchErrorParamTempName), wrapperCatchBlockNode);
    }

    private Node createOuterFinally(LexicalContext ctx, AstFactory.Type iterableResultType, AstFactory.Type resultType, String resultTempName, String returnFuncTempName, String iteratorTempName, String errorResultTempName) {
        Node finallyNode = this.astFactory.createBlock(new Node[0]);
        Node tmpResNameNode = this.astFactory.createNameWithUnknownType(resultTempName);
        Node tmpResDoneGetProp = this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "done", AstFactory.type(StandardColors.BOOLEAN));
        Node and = this.astFactory.createAnd(tmpResNameNode, this.astFactory.createNot(tmpResDoneGetProp));
        Node assign = this.astFactory.createAssign(this.astFactory.createNameWithUnknownType(returnFuncTempName), this.astFactory.createGetProp(this.astFactory.createName(iteratorTempName, resultType), "return", AstFactory.type(StandardColors.UNKNOWN)));
        Node ifCond = this.astFactory.createAnd(and, assign);
        Node awaitOrYieldStmt = null;
        awaitOrYieldStmt = ctx.function.isAsyncGeneratorFunction() ? this.astFactory.exprResult(this.astFactory.createYield(iterableResultType, this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), this.astFactory.createQName(this.namespace, ACTION_ENUM_AWAIT), this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(this.astFactory.createName(returnFuncTempName, AstFactory.type(StandardColors.UNKNOWN)), "call"), AstFactory.type(StandardColors.UNKNOWN), this.astFactory.createName(iteratorTempName, resultType))))) : this.astFactory.exprResult(this.astFactory.createAwait(iterableResultType, this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(this.astFactory.createName(returnFuncTempName, AstFactory.type(StandardColors.UNKNOWN)), "call"), AstFactory.type(StandardColors.PROMISE_ID), this.astFactory.createName(iteratorTempName, resultType))));
        Node ifBody = this.astFactory.createBlock(new Node[0]);
        ifBody.addChildToBack(awaitOrYieldStmt);
        Node ifBlock = this.astFactory.createIf(ifCond, ifBody);
        Node innerTryBlock = this.astFactory.createBlock(new Node[0]);
        innerTryBlock.addChildToBack(ifBlock);
        Node innerFinallyBlock = this.astFactory.createBlock(new Node[0]);
        Node secondIfBody = this.astFactory.createBlock(new Node[0]);
        Node throwStmt = this.astFactory.createThrow(this.astFactory.createGetPropWithUnknownType(this.astFactory.createNameWithUnknownType(errorResultTempName), "error"));
        secondIfBody.addChildToBack(throwStmt);
        Node secondIfCond = this.astFactory.createNameWithUnknownType(errorResultTempName);
        Node secondIfBlock = this.astFactory.createIf(secondIfCond, secondIfBody);
        innerFinallyBlock.addChildToBack(secondIfBlock);
        Node finallyBody = this.astFactory.createTryFinally(innerTryBlock, innerFinallyBlock);
        finallyNode.addChildToBack(finallyBody);
        return finallyNode;
    }

    private Node ensureBlock(Node possiblyBlock) {
        return possiblyBlock.isBlock() ? possiblyBlock : this.astFactory.createBlock(possiblyBlock).srcref(possiblyBlock);
    }

    private Node constructAwaitNextResult(LexicalContext ctx, String iteratorTempName, AstFactory.Type iteratorType, AstFactory.Type iterableResultType) {
        Preconditions.checkNotNull((Object)ctx.function);
        Node iteratorTemp = this.astFactory.createName(iteratorTempName, iteratorType);
        Node result = ctx.function.isAsyncGeneratorFunction() ? this.astFactory.createYield(iterableResultType, this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), this.astFactory.createQName(this.namespace, ACTION_ENUM_AWAIT), this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(iteratorTemp, "next"), new Node[0]))) : this.astFactory.createAwait(iterableResultType, this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(iteratorTemp, "next"), AstFactory.type(StandardColors.PROMISE_ID), new Node[0]));
        return result;
    }

    private void replaceThis(LexicalContext ctx, Node n) {
        Preconditions.checkArgument((boolean)n.isThis());
        Preconditions.checkArgument((ctx != null && ctx.mustReplaceThisSuperArgs() ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName(THIS_VAR_NAME, AstFactory.type(n)).srcref(n));
        ctx.thisSuperArgsContext.thisNodeToAdd = this.astFactory.createThis(AstFactory.type(n));
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceArguments(LexicalContext ctx, Node n) {
        Preconditions.checkArgument((n.isName() && "arguments".equals(n.getString()) ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx != null && ctx.mustReplaceThisSuperArgs() ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName(ARGUMENTS_VAR_NAME, AstFactory.type(n)).srcref(n));
        ctx.thisSuperArgsContext.usedArguments = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceSuper(LexicalContext ctx, Node n, Node parent) {
        if (!parent.isGetProp()) {
            this.compiler.report(JSError.make(parent, CANNOT_CONVERT_ASYNCGEN, "super only allowed with getprop (like super.foo(), not super['foo']())"));
            return;
        }
        Preconditions.checkArgument((boolean)n.isSuper());
        Preconditions.checkArgument((ctx != null && ctx.mustReplaceThisSuperArgs() ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        String propertyName = parent.getString();
        String propertyReplacementNameText = SUPER_PROP_GETTER_PREFIX + propertyName;
        Node getPropReplacement = this.astFactory.createCall(this.astFactory.createName(propertyReplacementNameText, AstFactory.type(StandardColors.TOP_OBJECT)), AstFactory.type(parent), new Node[0]);
        Node grandparent = parent.getParent();
        if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
            getPropReplacement = this.astFactory.createGetPropWithUnknownType(getPropReplacement, "call");
            ctx.thisSuperArgsContext.thisNodeToAdd = this.astFactory.createThisForEs6ClassMember(ctx.contextRoot.getParent());
            this.astFactory.createName(THIS_VAR_NAME, AstFactory.type(ctx.thisSuperArgsContext.thisNodeToAdd)).srcref(parent).insertAfter(parent);
        }
        getPropReplacement.srcrefTree(parent);
        parent.replaceWith(getPropReplacement);
        ctx.thisSuperArgsContext.usedSuperProperties.add(parent);
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void prependTempVarDeclarations(LexicalContext ctx, NodeTraversal t) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        Preconditions.checkArgument((ctx.function != null ? 1 : 0) != 0, (Object)"Cannot prepend declarations to root scope");
        Preconditions.checkNotNull((Object)ctx.thisSuperArgsContext);
        ThisSuperArgsContext thisSuperArgsCtx = ctx.thisSuperArgsContext;
        Node function = ctx.function;
        Node block = function.getLastChild();
        Preconditions.checkNotNull((Object)block, (Object)function);
        Node prefixBlock = this.astFactory.createBlock(new Node[0]);
        if (thisSuperArgsCtx.thisNodeToAdd != null) {
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration(THIS_VAR_NAME, thisSuperArgsCtx.thisNodeToAdd).srcrefTree(block));
        }
        if (thisSuperArgsCtx.usedArguments) {
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration(ARGUMENTS_VAR_NAME, this.astFactory.createArgumentsReference()).srcrefTree(block));
        }
        for (Node replacedMethodReference : thisSuperArgsCtx.usedSuperProperties) {
            prefixBlock.addChildToBack(this.createSuperMethodReferenceGetter(replacedMethodReference, t));
        }
        prefixBlock.srcrefTreeIfMissing(block);
        block.addChildrenToFront(prefixBlock.removeChildren());
        if (thisSuperArgsCtx.thisNodeToAdd != null || thisSuperArgsCtx.usedArguments || !thisSuperArgsCtx.usedSuperProperties.isEmpty()) {
            this.compiler.reportChangeToChangeScope(function);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
    }

    private Node createSuperMethodReferenceGetter(Node replacedMethodReference, NodeTraversal t) {
        AstFactory.Type typeOfSuper = AstFactory.type(replacedMethodReference.getFirstChild());
        Node superReference = this.astFactory.createSuper(typeOfSuper);
        String replacedMethodName = replacedMethodReference.getString();
        Node arrowFunction = this.astFactory.createZeroArgArrowFunctionForExpression(this.astFactory.createBlock(this.astFactory.createReturn(this.astFactory.createGetProp(superReference, replacedMethodName, AstFactory.type(replacedMethodReference)))));
        this.compiler.reportChangeToChangeScope(arrowFunction);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
        String superReplacementName = SUPER_PROP_GETTER_PREFIX + replacedMethodName;
        return this.astFactory.createSingleConstNameDeclaration(superReplacementName, arrowFunction);
    }

    private static final class LexicalContext {
        private final Node contextRoot;
        private final @Nullable Node function;
        private final @Nullable ThisSuperArgsContext thisSuperArgsContext;

        private LexicalContext(Node contextRoot) {
            this.contextRoot = (Node)Preconditions.checkNotNull((Object)contextRoot);
            this.function = null;
            this.thisSuperArgsContext = null;
        }

        private LexicalContext(LexicalContext parent, Node contextRoot, Node function) {
            Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)contextRoot);
            Preconditions.checkArgument((contextRoot == function || contextRoot.isParamList() ? 1 : 0) != 0, (Object)contextRoot);
            Preconditions.checkNotNull((Object)function);
            Preconditions.checkArgument((boolean)function.isFunction(), (Object)function);
            this.contextRoot = contextRoot;
            this.function = function;
            this.thisSuperArgsContext = function.isArrowFunction() ? parent.thisSuperArgsContext : (contextRoot.isFunction() ? new ThisSuperArgsContext(this) : null);
        }

        static LexicalContext newGlobalContext(Node contextRoot) {
            return new LexicalContext(contextRoot);
        }

        static LexicalContext newContextForFunction(LexicalContext parent, Node function) {
            return new LexicalContext(parent, function, function);
        }

        static LexicalContext newContextForParamList(LexicalContext parent, Node paramList) {
            return new LexicalContext(parent, paramList, parent.function);
        }

        Node getFunctionDeclaringThisArgsSuper() {
            return this.thisSuperArgsContext.ctx.function;
        }

        boolean mustReplaceThisSuperArgs() {
            return this.thisSuperArgsContext != null && this.getFunctionDeclaringThisArgsSuper().isAsyncGeneratorFunction();
        }
    }

    private static final class ThisSuperArgsContext {
        private final LexicalContext ctx;
        private final Set<Node> usedSuperProperties = new LinkedHashSet<Node>();
        @Nullable Node thisNodeToAdd = null;
        private boolean usedArguments = false;

        ThisSuperArgsContext(LexicalContext ctx) {
            this.ctx = ctx;
        }
    }
}

