/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class ReplaceStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType BAD_REPLACEMENT_CONFIGURATION = DiagnosticType.error("JSC_BAD_REPLACEMENT_CONFIGURATION", "Bad replacement configuration \"{0}\": {1}");
    static final DiagnosticType STRING_REPLACEMENT_TAGGED_TEMPLATE = DiagnosticType.warning("JSC_STRING_REPLACEMENT_TAGGED_TEMPLATE", "Cannot string-replace arguments of a template literal tag function.");
    private static final String DEFAULT_PLACEHOLDER_TOKEN = "`";
    public static final String EXCLUSION_PREFIX = ":!";
    private final String placeholderToken;
    private static final String REPLACE_ONE_MARKER = "?";
    private static final String REPLACE_ALL_MARKER = "*";
    private final AbstractCompiler compiler;
    private final Map<String, Config> functions = new HashMap<String, Config>();
    private final DefaultNameGenerator nameGenerator;
    private final Map<String, Result> results = new LinkedHashMap<String, Result>();
    static final Predicate<Result> USED_RESULTS = result -> result.didReplacement;

    ReplaceStrings(AbstractCompiler compiler, String placeholderToken, List<String> functionsToInspect) {
        this.compiler = compiler;
        this.placeholderToken = placeholderToken.isEmpty() ? DEFAULT_PLACEHOLDER_TOKEN : placeholderToken;
        this.nameGenerator = ReplaceStrings.createNameGenerator();
        this.parseConfiguration(functionsToInspect);
    }

    List<Result> getResult() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.results.values(), USED_RESULTS));
    }

    VariableMap getStringMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Result result : Iterables.filter(this.results.values(), USED_RESULTS)) {
            map.put((Object)result.replacement, (Object)result.original);
        }
        return new VariableMap((Map<String, String>)map.buildOrThrow());
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NEW: 
            case CALL: 
            case TAGGED_TEMPLATELIT: {
                Config config;
                Node calledFn = n.getFirstChild();
                String name = calledFn.getOriginalQualifiedName();
                if (name == null || (config = this.findMatching(name, n.getSourceFileName())) == null) break;
                this.doSubstitutions(t, config, n);
                return;
            }
        }
    }

    private @Nullable Config findMatching(String name, String callsiteSourceFileName) {
        Config config = this.functions.get(name);
        if (config == null) {
            name = name.replace('$', '.');
            config = this.functions.get(name);
        }
        if (config != null) {
            for (String excludedSuffix : config.excludedFilenameSuffixes) {
                if (!callsiteSourceFileName.endsWith(excludedSuffix)) continue;
                return null;
            }
        }
        return config;
    }

    private void doSubstitutions(NodeTraversal t, Config config, Node n) {
        if (n.isTaggedTemplateLit()) {
            this.compiler.report(JSError.make(n, STRING_REPLACEMENT_TAGGED_TEMPLATE, new String[0]));
            return;
        }
        Preconditions.checkState((n.isNew() || n.isCall() ? 1 : 0) != 0);
        if (!config.isReplaceAll()) {
            for (int parameter : config.parameters) {
                Node arg = n.getChildAtIndex(parameter);
                if (arg == null) continue;
                this.replaceExpression(t, arg);
            }
        } else {
            Node firstParam;
            for (Node arg = firstParam = n.getSecondChild(); arg != null; arg = arg.getNext()) {
                arg = this.replaceExpression(t, arg);
            }
        }
    }

    private Node replaceExpression(NodeTraversal t, Node expr) {
        Node replacement;
        String replacementString;
        String key = null;
        switch (expr.getToken()) {
            case STRINGLIT: {
                key = expr.getString();
                replacementString = this.getReplacement(key);
                replacement = IR.string(replacementString);
                break;
            }
            case TEMPLATELIT: 
            case ADD: 
            case NAME: {
                StringBuilder keyBuilder = new StringBuilder();
                Node keyNode = IR.string("");
                replacement = this.buildReplacement(t, expr, keyNode, keyBuilder);
                key = keyBuilder.toString();
                if (key.equals(this.placeholderToken)) {
                    return expr;
                }
                replacementString = this.getReplacement(key);
                keyNode.setString(replacementString);
                break;
            }
            default: {
                return expr;
            }
        }
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)replacementString);
        this.recordReplacement(key);
        replacement.srcrefTreeIfMissing(expr);
        expr.replaceWith(replacement);
        t.reportCodeChange();
        return replacement;
    }

    private String getReplacement(String key) {
        Result result = this.results.get(key);
        if (result != null) {
            return result.replacement;
        }
        String replacement = this.nameGenerator.generateNextName();
        result = new Result(key, replacement);
        this.results.put(key, result);
        return replacement;
    }

    private void recordReplacement(String key) {
        Result result = this.results.get(key);
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        result.didReplacement = true;
    }

    private Node buildReplacement(NodeTraversal t, Node expr, Node prefix, StringBuilder keyBuilder) {
        switch (expr.getToken()) {
            case ADD: {
                Node left = expr.getFirstChild();
                Node right = left.getNext();
                prefix = this.buildReplacement(t, left, prefix, keyBuilder);
                return this.buildReplacement(t, right, prefix, keyBuilder);
            }
            case TEMPLATELIT: {
                block10: for (Node child = expr.getFirstChild(); child != null; child = child.getNext()) {
                    switch (child.getToken()) {
                        case TEMPLATELIT_STRING: {
                            keyBuilder.append(child.getCookedString());
                            continue block10;
                        }
                        case TEMPLATELIT_SUB: {
                            prefix = this.buildReplacement(t, child.getFirstChild(), prefix, keyBuilder);
                            continue block10;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected TEMPLATELIT child: " + child);
                        }
                    }
                }
                return prefix;
            }
            case STRINGLIT: {
                keyBuilder.append(expr.getString());
                return prefix;
            }
            case NAME: {
                StringBuilder newKeyBuilder;
                Node newKeyNode;
                Node replacement;
                Node initialValue;
                Var var = (Var)t.getScope().getVar(expr.getString());
                if (var == null || !var.isDeclaredOrInferredConst() && !var.isConst() || (initialValue = var.getInitialValue()) == null || (replacement = this.buildReplacement(t, initialValue, newKeyNode = IR.string(""), newKeyBuilder = new StringBuilder())) != newKeyNode) break;
                keyBuilder.append((CharSequence)newKeyBuilder);
                return prefix;
            }
        }
        keyBuilder.append(this.placeholderToken);
        prefix = IR.add(prefix, IR.string(this.placeholderToken));
        return IR.add(prefix, expr.cloneTree());
    }

    private void parseConfiguration(List<String> functionsToInspect) {
        for (String function : functionsToInspect) {
            Config config = this.parseConfiguration(function);
            if (config == null) continue;
            this.functions.put(config.name, config);
        }
    }

    private @Nullable Config parseConfiguration(String function) {
        int first = function.indexOf(40);
        int last = function.indexOf(41);
        int colon = function.indexOf(EXCLUSION_PREFIX);
        Preconditions.checkState((first != -1 && last != -1 ? 1 : 0) != 0);
        if (function.contains(".prototype.")) {
            this.compiler.report(JSError.make(BAD_REPLACEMENT_CONFIGURATION, function, "Cannot replace strings passed to prototype methods."));
            return null;
        }
        String name = function.substring(0, first);
        String params = function.substring(first + 1, last);
        int paramCount = 0;
        ArrayList<Integer> replacementParameters = new ArrayList<Integer>();
        List parts = Splitter.on((char)',').splitToList((CharSequence)params);
        for (String param : parts) {
            ++paramCount;
            if (param.equals(REPLACE_ALL_MARKER)) {
                Preconditions.checkState((paramCount == 1 && parts.size() == 1 ? 1 : 0) != 0);
                replacementParameters.add(0);
                continue;
            }
            if (param.equals(REPLACE_ONE_MARKER)) {
                Preconditions.checkState((!replacementParameters.contains(0) ? 1 : 0) != 0);
                replacementParameters.add(paramCount);
                continue;
            }
            Preconditions.checkState((boolean)param.isEmpty(), (String)"Unknown marker (%s)", (Object)param);
        }
        Preconditions.checkState((!replacementParameters.isEmpty() ? 1 : 0) != 0);
        return new Config(name, replacementParameters, (ImmutableSet<String>)(colon == -1 ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])function.substring(colon + EXCLUSION_PREFIX.length()).split(","))));
    }

    private static DefaultNameGenerator createNameGenerator() {
        String namePrefix = "";
        char[] reservedChars = new char[]{};
        return new DefaultNameGenerator((Set<String>)ImmutableSet.of(), "", reservedChars);
    }

    static class Result {
        public final String original;
        public final String replacement;
        public boolean didReplacement = false;

        Result(String original, String replacement) {
            this.original = original;
            this.replacement = replacement;
        }
    }

    private static class Config {
        final String name;
        final List<Integer> parameters;
        final ImmutableSet<String> excludedFilenameSuffixes;
        static final int REPLACE_ALL_VALUE = 0;

        Config(String name, List<Integer> replacementParameters, ImmutableSet<String> excludedFilenameSuffixes) {
            this.name = name;
            this.parameters = replacementParameters;
            this.excludedFilenameSuffixes = excludedFilenameSuffixes;
        }

        public boolean isReplaceAll() {
            return this.parameters.size() == 1 && this.parameters.contains(0);
        }
    }
}

