/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class RemovePropertyRenamingCalls
implements CompilerPass {
    private final AbstractCompiler compiler;

    RemovePropertyRenamingCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new RemoveCompilerPropertyRenamingCallback());
    }

    private final class RemoveCompilerPropertyRenamingCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveCompilerPropertyRenamingCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (RemovePropertyRenamingCalls.this.compiler.getCodingConvention().isPropertyRenameFunction(fn)) {
                    this.replacePropertyRenamingCall(n);
                }
            }
        }

        private void replacePropertyRenamingCall(Node callNode) {
            Node propName = NodeUtil.getArgumentForCallOrNew(callNode, 0);
            if (propName != null) {
                callNode.replaceWith(propName.detach());
                RemovePropertyRenamingCalls.this.compiler.reportChangeToEnclosingScope(propName);
                return;
            }
        }
    }
}

