/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.SimpleReference;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

final class PreprocessorSymbolTable
implements StaticTypedScope,
StaticSymbolTable<SimpleSlot, Reference> {
    private final Map<String, SimpleSlot> symbols = new LinkedHashMap<String, SimpleSlot>();
    private final Multimap<String, Reference> refs = ArrayListMultimap.create();
    private final Node root;

    PreprocessorSymbolTable(Node root) {
        this.root = root;
    }

    @Override
    public Node getRootNode() {
        return this.root;
    }

    @Override
    public @Nullable JSType getTypeOfThis() {
        return null;
    }

    @Override
    public @Nullable StaticTypedScope getParentScope() {
        return null;
    }

    @Override
    public SimpleSlot getSlot(String name) {
        return this.symbols.get(name);
    }

    @Override
    public SimpleSlot getOwnSlot(String name) {
        return this.getSlot(name);
    }

    @Override
    public Iterable<Reference> getReferences(SimpleSlot symbol) {
        return Collections.unmodifiableCollection(this.refs.get((Object)symbol.getName()));
    }

    @Override
    public Iterable<SimpleSlot> getAllSymbols() {
        return Collections.unmodifiableCollection(this.symbols.values());
    }

    public StaticTypedScope getScope(SimpleSlot slot) {
        return this;
    }

    void addReference(Node node) {
        this.addReference(node, this.getQualifiedName(node));
    }

    void addReference(Node node, String name) {
        Preconditions.checkNotNull((Object)name);
        this.symbols.computeIfAbsent(name, k -> new SimpleSlot((String)k, null, true));
        this.refs.put((Object)name, (Object)new Reference(this.symbols.get(name), node));
    }

    public String getQualifiedName(Node n) {
        return n.isStringLit() ? n.getString() : n.getQualifiedName();
    }

    static final class Reference
    extends SimpleReference<SimpleSlot> {
        Reference(SimpleSlot symbol, Node node) {
            super(symbol, node);
        }
    }

    public static class CachedInstanceFactory {
        private @Nullable PreprocessorSymbolTable instance;

        public void maybeInitialize(AbstractCompiler compiler) {
            if (compiler.getOptions().preservesDetailedSourceInfo()) {
                Node root = compiler.getRoot();
                if (this.instance == null || this.instance.getRootNode() != root) {
                    this.instance = new PreprocessorSymbolTable(root);
                }
            }
        }

        public @Nullable PreprocessorSymbolTable getInstanceOrNull() {
            return this.instance;
        }
    }
}

