/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.jspecify.nullness.Nullable;

class PeepholeReplaceKnownMethods
extends AbstractPeepholeOptimization {
    private final boolean late;
    private final boolean useTypes;

    PeepholeReplaceKnownMethods(boolean late, boolean useTypes) {
        this.late = late;
        this.useTypes = useTypes;
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        if (subtree.isCall()) {
            return this.tryFoldKnownMethods(subtree);
        }
        return subtree;
    }

    private Node tryFoldKnownMethods(Node subtree) {
        Preconditions.checkArgument((boolean)subtree.isCall(), (Object)subtree);
        subtree = this.tryFoldArrayJoin(subtree);
        if (subtree.isCall()) {
            subtree = this.tryToFoldArrayConcat(subtree);
            Preconditions.checkState((boolean)subtree.isCall(), (Object)subtree);
            Node callTarget = (Node)Preconditions.checkNotNull((Object)subtree.getFirstChild());
            if (callTarget.isGetProp()) {
                if (this.isASTNormalized() && callTarget.getFirstChild().isQualifiedName()) {
                    switch (callTarget.getFirstChild().getQualifiedName()) {
                        case "Array": {
                            return this.tryFoldKnownArrayMethods(subtree, callTarget);
                        }
                        case "Math": {
                            return this.tryFoldKnownMathMethods(subtree, callTarget);
                        }
                    }
                }
                subtree = this.tryFoldKnownStringMethods(subtree, callTarget);
            } else if (callTarget.isName()) {
                subtree = this.tryFoldKnownNumericMethods(subtree, callTarget);
            }
        }
        return subtree;
    }

    private Node tryFoldKnownArrayMethods(Node subtree, Node callTarget) {
        Preconditions.checkArgument((subtree.isCall() && callTarget.isGetProp() ? 1 : 0) != 0);
        if (!callTarget.getString().equals("of")) {
            return subtree;
        }
        subtree.removeFirstChild();
        Node arraylit = new Node(Token.ARRAYLIT);
        arraylit.addChildrenToBack(subtree.removeChildren());
        subtree.replaceWith(arraylit);
        this.reportChangeToEnclosingScope(arraylit);
        return arraylit;
    }

    private strictfp Node tryFoldKnownMathMethods(Node subtree, Node callTarget) {
        Preconditions.checkArgument((subtree.isCall() && callTarget.isGetProp() ? 1 : 0) != 0);
        Object args = ImmutableList.of();
        for (Node arg = callTarget.getNext(); arg != null; arg = arg.getNext()) {
            Double d = this.getSideEffectFreeNumberValue(arg);
            if (d != null) {
                if (args.isEmpty()) {
                    args = new ArrayList();
                }
            } else {
                return subtree;
            }
            args.add(d);
        }
        Double replacement = null;
        String methodName = callTarget.getString();
        if (args.size() == 1) {
            double arg = (Double)args.get(0);
            switch (methodName) {
                case "abs": {
                    replacement = Math.abs(arg);
                    break;
                }
                case "ceil": {
                    replacement = Math.ceil(arg);
                    break;
                }
                case "floor": {
                    replacement = Math.floor(arg);
                    break;
                }
                case "fround": {
                    if (Double.isNaN(arg) || Double.isInfinite(arg) || arg == 0.0) {
                        replacement = arg;
                        break;
                    }
                    if ((double)((float)arg) == arg) {
                        replacement = (float)arg;
                        break;
                    }
                    replacement = null;
                    break;
                }
                case "round": {
                    if (Double.isNaN(arg) || Double.isInfinite(arg)) {
                        replacement = arg;
                        break;
                    }
                    replacement = Math.round(arg);
                    break;
                }
                case "sign": {
                    replacement = Math.signum(arg);
                    break;
                }
                case "trunc": {
                    if (Double.isNaN(arg) || Double.isInfinite(arg)) {
                        replacement = arg;
                        break;
                    }
                    replacement = Math.signum(arg) * Math.floor(Math.abs(arg));
                    break;
                }
                case "clz32": {
                    replacement = Integer.numberOfLeadingZeros(JSCompDoubles.ecmascriptToUint32(arg));
                    break;
                }
            }
        }
        if (replacement == null) {
            switch (methodName) {
                case "max": {
                    double result = Double.NEGATIVE_INFINITY;
                    Iterator iterator = args.iterator();
                    while (iterator.hasNext()) {
                        Double d = (Double)iterator.next();
                        result = Math.max(result, d);
                    }
                    replacement = result;
                    break;
                }
                case "min": {
                    double result = Double.POSITIVE_INFINITY;
                    Iterator iterator = args.iterator();
                    while (iterator.hasNext()) {
                        Double d = (Double)iterator.next();
                        result = Math.min(result, d);
                    }
                    replacement = result;
                    break;
                }
                case "imul": {
                    if (args.size() < 2) {
                        replacement = 0.0;
                        break;
                    }
                    replacement = JSCompDoubles.ecmascriptToInt32((Double)args.get(0)) * JSCompDoubles.ecmascriptToInt32((Double)args.get(1));
                    break;
                }
            }
        }
        if (replacement != null) {
            Node numberNode = NodeUtil.numberNode(replacement, subtree);
            subtree.replaceWith(numberNode);
            this.reportChangeToEnclosingScope(numberNode);
            return numberNode;
        }
        return subtree;
    }

    private Node tryFoldKnownStringMethods(Node subtree, Node callTarget) {
        Double maybeStart;
        Preconditions.checkArgument((subtree.isCall() && callTarget.isGetProp() ? 1 : 0) != 0);
        Node stringNode = callTarget.getFirstChild();
        boolean isStringLiteral = stringNode.isStringLit();
        String functionNameString = callTarget.getString();
        Node firstArg = callTarget.getNext();
        if (isStringLiteral) {
            if (functionNameString.equals("split")) {
                return this.tryFoldStringSplit(subtree, stringNode, firstArg);
            }
            if (firstArg == null) {
                switch (functionNameString) {
                    case "toLowerCase": {
                        return this.tryFoldStringToLowerCase(subtree, stringNode);
                    }
                    case "toUpperCase": {
                        return this.tryFoldStringToUpperCase(subtree, stringNode);
                    }
                    case "trim": {
                        return this.tryFoldStringTrim(subtree, stringNode);
                    }
                }
            } else if (NodeUtil.isImmutableValue(firstArg)) {
                switch (functionNameString) {
                    case "indexOf": 
                    case "lastIndexOf": {
                        return this.tryFoldStringIndexOf(subtree, functionNameString, stringNode, firstArg);
                    }
                    case "substr": {
                        return this.tryFoldStringSubstr(subtree, stringNode, firstArg);
                    }
                    case "substring": 
                    case "slice": {
                        return this.tryFoldStringSubstringOrSlice(subtree, stringNode, firstArg);
                    }
                    case "charAt": {
                        return this.tryFoldStringCharAt(subtree, stringNode, firstArg);
                    }
                    case "charCodeAt": {
                        return this.tryFoldStringCharCodeAt(subtree, stringNode, firstArg);
                    }
                    case "replace": {
                        return this.tryFoldStringReplace(subtree, stringNode, firstArg);
                    }
                    case "replaceAll": {
                        return this.tryFoldStringReplaceAll(subtree, stringNode, firstArg);
                    }
                }
            }
        }
        if (this.useTypes && firstArg != null && (isStringLiteral || StandardColors.STRING.equals(stringNode.getColor())) && subtree.hasXChildren(3) && (maybeStart = this.getSideEffectFreeNumberValue(firstArg)) != null) {
            int start = maybeStart.intValue();
            Double maybeLengthOrEnd = this.getSideEffectFreeNumberValue(firstArg.getNext());
            if (maybeLengthOrEnd != null) {
                switch (functionNameString) {
                    case "substr": {
                        int length = maybeLengthOrEnd.intValue();
                        if (start < 0 || length != 1) break;
                        return this.replaceWithCharAt(subtree, callTarget, firstArg);
                    }
                    case "substring": 
                    case "slice": {
                        int end = maybeLengthOrEnd.intValue();
                        if (start < 0 || end - start != 1) break;
                        return this.replaceWithCharAt(subtree, callTarget, firstArg);
                    }
                }
            }
        }
        return subtree;
    }

    private Node tryFoldKnownNumericMethods(Node subtree, Node callTarget) {
        Preconditions.checkArgument((boolean)subtree.isCall());
        if (this.isASTNormalized()) {
            String functionNameString = callTarget.getString();
            Node firstArgument = callTarget.getNext();
            if (firstArgument != null && (firstArgument.isStringLit() || this.isNumericLiteral(firstArgument)) && (functionNameString.equals("parseInt") || functionNameString.equals("parseFloat"))) {
                subtree = this.tryFoldParseNumber(subtree, functionNameString, firstArgument);
            }
        }
        return subtree;
    }

    private boolean isNumericLiteral(Node n) {
        return n.isNumber() || n.isNeg() && n.getOnlyChild().isNumber();
    }

    private Node tryFoldStringToLowerCase(Node subtree, Node stringNode) {
        String lowered = stringNode.getString().toLowerCase(Locale.ROOT);
        Node replacement = IR.string(lowered);
        subtree.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node tryFoldStringToUpperCase(Node subtree, Node stringNode) {
        String upped = stringNode.getString().toUpperCase(Locale.ROOT);
        Node replacement = IR.string(upped);
        subtree.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node tryFoldStringTrim(Node subtree, Node stringNode) {
        String whitespace = "[ \t\n-\r\\u0085\\u00A0\\u1680\\u2000-\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000\\uFEFF]+";
        String trimmed = stringNode.getString().replaceAll("^" + whitespace + "|" + whitespace + "$", "");
        Node replacement = IR.string(trimmed);
        subtree.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private static String normalizeNumericString(String input) {
        int startIndex;
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        int endIndex = input.length() - 1;
        for (startIndex = 0; startIndex < input.length() && input.charAt(startIndex) == '0' && input.charAt(startIndex) != '.'; ++startIndex) {
        }
        if (input.indexOf(46) >= 0) {
            while (endIndex >= 0 && input.charAt(endIndex) == '0') {
                --endIndex;
            }
            if (input.charAt(endIndex) == '.') {
                --endIndex;
            }
        }
        if (startIndex >= endIndex) {
            return input;
        }
        return input.substring(startIndex, endIndex + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node tryFoldParseNumber(Node n, String functionName, Node firstArg) {
        Node newNode;
        String stringVal;
        int radix;
        boolean isParseInt;
        block25: {
            Preconditions.checkArgument((boolean)n.isCall());
            isParseInt = functionName.equals("parseInt");
            Node secondArg = firstArg.getNext();
            radix = 0;
            if (secondArg != null) {
                if (!isParseInt) {
                    return n;
                }
                if (secondArg.getNext() != null || !secondArg.isNumber()) {
                    return n;
                }
                double tmpRadix = secondArg.getDouble();
                if (tmpRadix != (double)((int)tmpRadix)) {
                    return n;
                }
                radix = (int)tmpRadix;
                if (radix < 0 || radix == 1 || radix > 36) {
                    return n;
                }
            }
            stringVal = null;
            if (this.isNumericLiteral(firstArg)) {
                Double checkVal = this.getSideEffectFreeNumberValue(firstArg);
                if (radix != 0 && radix != 10 && isParseInt) {
                    stringVal = String.valueOf(checkVal.intValue());
                    break block25;
                } else {
                    Node numericNode = isParseInt ? NodeUtil.numberNode(checkVal.intValue(), n) : NodeUtil.numberNode(checkVal, n);
                    n.replaceWith(numericNode);
                    this.reportChangeToEnclosingScope(numericNode);
                    return numericNode;
                }
            }
            stringVal = this.getSideEffectFreeStringValue(firstArg);
            if (stringVal == null) {
                return n;
            }
            Double checkVal = NodeUtil.getStringNumberValue(stringVal);
            if (checkVal == null) {
                return n;
            }
            if ((stringVal = NodeUtil.trimJsWhiteSpace(stringVal)).isEmpty()) {
                return n;
            }
        }
        if (stringVal.equals("0")) {
            newNode = IR.number(0.0);
        } else if (isParseInt) {
            if (radix == 0 || radix == 16) {
                if (stringVal.length() > 1 && Ascii.equalsIgnoreCase((CharSequence)stringVal.substring(0, 2), (CharSequence)"0x")) {
                    radix = 16;
                    stringVal = stringVal.substring(2);
                } else if (radix == 0) {
                    if (!this.isEcmaScript5OrGreater() && stringVal.substring(0, 1).equals("0")) {
                        return n;
                    }
                    radix = 10;
                }
            }
            int newVal = 0;
            try {
                newVal = Integer.parseInt(stringVal, radix);
            }
            catch (NumberFormatException e) {
                return n;
            }
            newNode = NodeUtil.numberNode(newVal, n);
        } else {
            String normalizedNewVal = "0";
            try {
                double newVal = Double.parseDouble(stringVal);
                newNode = NodeUtil.numberNode(newVal, n);
                normalizedNewVal = PeepholeReplaceKnownMethods.normalizeNumericString(String.valueOf(newVal));
            }
            catch (NumberFormatException e) {
                return n;
            }
            if (!PeepholeReplaceKnownMethods.normalizeNumericString(stringVal).equals(normalizedNewVal)) {
                return n;
            }
        }
        n.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private Node tryFoldStringIndexOf(Node n, String functionName, Node lstringNode, Node firstArg) {
        int fromIndex;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)lstringNode.isStringLit());
        String lstring = lstringNode.getString();
        boolean isIndexOf = functionName.equals("indexOf");
        Node secondArg = firstArg.getNext();
        String searchValue = this.getSideEffectFreeStringValue(firstArg);
        if (searchValue == null) {
            return n;
        }
        int n2 = fromIndex = isIndexOf ? 0 : lstring.length();
        if (secondArg != null) {
            if (secondArg.getNext() != null || !secondArg.isNumber()) {
                return n;
            }
            fromIndex = (int)secondArg.getDouble();
        }
        int indexVal = isIndexOf ? lstring.indexOf(searchValue, fromIndex) : lstring.lastIndexOf(searchValue, fromIndex);
        Node newNode = NodeUtil.numberNode(indexVal, n);
        n.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private Node tryFoldArrayJoin(Node n) {
        Preconditions.checkState((boolean)n.isCall(), (Object)n);
        Node callTarget = n.getFirstChild();
        if (callTarget == null || !callTarget.isGetProp()) {
            return n;
        }
        Node right = callTarget.getNext();
        if (!(right == null || right.getNext() == null && NodeUtil.isImmutableValue(right))) {
            return n;
        }
        Node arrayNode = callTarget.getFirstChild();
        if (!arrayNode.isArrayLit() || !callTarget.getString().equals("join")) {
            return n;
        }
        if (right != null && right.isStringLit() && ",".equals(right.getString())) {
            right.detach();
            this.reportChangeToEnclosingScope(n);
        }
        String joinString = right == null ? "," : NodeUtil.getStringValue(right);
        ArrayList<Node> arrayFoldedChildren = new ArrayList<Node>();
        StringBuilder sb = null;
        int foldedSize = 0;
        Node prev = null;
        for (Node elem = arrayNode.getFirstChild(); elem != null; elem = elem.getNext()) {
            if (NodeUtil.isImmutableValue(elem) || elem.isEmpty()) {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append(joinString);
                }
                String elementStr = NodeUtil.getArrayElementStringValue(elem);
                if (elementStr == null) {
                    return n;
                }
                sb.append(elementStr);
            } else {
                if (sb != null) {
                    Preconditions.checkNotNull(prev);
                    foldedSize += sb.length() + 2;
                    arrayFoldedChildren.add(IR.string(sb.toString()).srcrefIfMissing(prev));
                    sb = null;
                }
                foldedSize += InlineCostEstimator.getCost(elem);
                arrayFoldedChildren.add(elem);
            }
            prev = elem;
        }
        if (sb != null) {
            Preconditions.checkNotNull(prev);
            foldedSize += sb.length() + 2;
            arrayFoldedChildren.add(IR.string(sb.toString()).srcrefIfMissing(prev));
        }
        foldedSize += arrayFoldedChildren.size() - 1;
        int originalSize = InlineCostEstimator.getCost(n);
        switch (arrayFoldedChildren.size()) {
            case 0: {
                Node emptyStringNode = IR.string("");
                n.replaceWith(emptyStringNode);
                this.reportChangeToEnclosingScope(emptyStringNode);
                return emptyStringNode;
            }
            case 1: {
                Node foldedStringNode = (Node)arrayFoldedChildren.remove(0);
                if (foldedStringNode.isSpread() || foldedSize > originalSize) {
                    return n;
                }
                if (foldedStringNode.isStringLit()) {
                    arrayNode.detachChildren();
                    n.replaceWith(foldedStringNode);
                    this.reportChangeToEnclosingScope(foldedStringNode);
                    return foldedStringNode;
                }
                return n;
            }
        }
        if (arrayNode.hasXChildren(arrayFoldedChildren.size())) {
            return n;
        }
        int kJoinOverhead = "[].join()".length();
        foldedSize += kJoinOverhead;
        if ((foldedSize += right != null ? InlineCostEstimator.getCost(right) : 0) > originalSize) {
            return n;
        }
        arrayNode.detachChildren();
        for (Node node : arrayFoldedChildren) {
            arrayNode.addChildToBack(node);
        }
        this.reportChangeToEnclosingScope(arrayNode);
        return n;
    }

    private Node tryFoldStringSubstr(Node n, Node stringNode, Node arg1) {
        int length;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        Preconditions.checkArgument((arg1 != null ? 1 : 0) != 0);
        String stringAsString = stringNode.getString();
        Double maybeStart = this.getSideEffectFreeNumberValue(arg1);
        if (maybeStart == null) {
            return n;
        }
        int start = maybeStart.intValue();
        Node arg2 = arg1.getNext();
        if (arg2 != null) {
            Double maybeLength = this.getSideEffectFreeNumberValue(arg2);
            if (maybeLength == null) {
                return n;
            }
            length = maybeLength.intValue();
            if (arg2.getNext() != null) {
                return n;
            }
        } else {
            length = stringAsString.length() - start;
        }
        if (start + length > stringAsString.length() || length < 0 || start < 0) {
            return n;
        }
        String result = stringAsString.substring(start, start + length);
        Node resultNode = IR.string(result);
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private Node tryFoldStringSubstringOrSlice(Node n, Node stringNode, Node arg1) {
        int end;
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        Preconditions.checkArgument((arg1 != null ? 1 : 0) != 0);
        String stringAsString = stringNode.getString();
        Double maybeStart = this.getSideEffectFreeNumberValue(arg1);
        if (maybeStart == null) {
            return n;
        }
        int start = maybeStart.intValue();
        Node arg2 = arg1.getNext();
        if (arg2 != null) {
            Double maybeEnd = this.getSideEffectFreeNumberValue(arg2);
            if (maybeEnd == null) {
                return n;
            }
            end = maybeEnd.intValue();
            if (arg2.getNext() != null) {
                return n;
            }
        } else {
            end = stringAsString.length();
        }
        if (end > stringAsString.length() || start > stringAsString.length() || start < 0 || end < 0 || start > end) {
            return n;
        }
        String result = stringAsString.substring(start, end);
        Node resultNode = IR.string(result);
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private Node replaceWithCharAt(Node n, Node callTarget, Node firstArg) {
        callTarget.setString("charAt");
        firstArg.getNext().detach();
        this.reportChangeToEnclosingScope(firstArg);
        return n;
    }

    private Node tryFoldStringCharAt(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber() || arg1.getNext() != null) {
            return n;
        }
        int index = (int)arg1.getDouble();
        if (index < 0 || stringAsString.length() <= index) {
            return n;
        }
        Node resultNode = IR.string(stringAsString.substring(index, index + 1));
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private Node tryFoldStringReplace(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        Node arg2 = arg1.getNext();
        if (arg2 == null || arg2.getNext() != null) {
            return n;
        }
        if (!arg1.isStringLit() || !arg2.isStringLit()) {
            return n;
        }
        String lookForPattern = arg1.getString();
        String replacementPattern = arg2.getString();
        if (replacementPattern.contains("$")) {
            return n;
        }
        String original = stringNode.getString();
        int index = original.indexOf(lookForPattern);
        if (index == -1) {
            return n;
        }
        String newString = original.substring(0, index) + replacementPattern + original.substring(index + lookForPattern.length());
        Node resultNode = IR.string(newString).srcref(stringNode);
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private Node tryFoldStringReplaceAll(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        Node arg2 = arg1.getNext();
        if (arg2 == null || arg2.getNext() != null) {
            return n;
        }
        if (!arg1.isStringLit() || !arg2.isStringLit()) {
            return n;
        }
        String replacementPattern = arg2.getString();
        if (replacementPattern.contains("$")) {
            return n;
        }
        String original = stringNode.getString();
        String newString = original.replace(arg1.getString(), replacementPattern);
        Node resultNode = IR.string(newString).srcref(stringNode);
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private Node tryFoldStringCharCodeAt(Node n, Node stringNode, Node arg1) {
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        String stringAsString = stringNode.getString();
        if (arg1 == null || !arg1.isNumber() || arg1.getNext() != null) {
            return n;
        }
        int index = (int)arg1.getDouble();
        if (index < 0 || stringAsString.length() <= index) {
            return n;
        }
        Node resultNode = IR.number(stringAsString.charAt(index));
        Node parent = n.getParent();
        n.replaceWith(resultNode);
        this.reportChangeToEnclosingScope(parent);
        return resultNode;
    }

    private static int jsSplitMatch(String stringValue, int startIndex, String separator) {
        if (startIndex + separator.length() > stringValue.length()) {
            return -1;
        }
        int matchIndex = stringValue.indexOf(separator, startIndex);
        if (matchIndex < 0) {
            return -1;
        }
        return matchIndex;
    }

    private String[] jsSplit(String stringValue, String separator, int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((stringValue != null ? 1 : 0) != 0);
        if (limit == 0) {
            return new String[0];
        }
        if (separator == null) {
            return new String[]{stringValue};
        }
        ArrayList<String> splitStrings = new ArrayList<String>();
        if (separator.isEmpty()) {
            for (int i = 0; i < stringValue.length() && i < limit; ++i) {
                splitStrings.add(stringValue.substring(i, i + 1));
            }
        } else {
            int matchIndex;
            int startIndex = 0;
            while ((matchIndex = PeepholeReplaceKnownMethods.jsSplitMatch(stringValue, startIndex, separator)) >= 0 && splitStrings.size() < limit) {
                splitStrings.add(stringValue.substring(startIndex, matchIndex));
                startIndex = matchIndex + separator.length();
            }
            if (splitStrings.size() < limit) {
                if (startIndex < stringValue.length()) {
                    splitStrings.add(stringValue.substring(startIndex));
                } else {
                    splitStrings.add("");
                }
            }
        }
        return splitStrings.toArray(new String[0]);
    }

    private Node tryFoldStringSplit(Node n, Node stringNode, Node arg1) {
        if (this.late) {
            return n;
        }
        Preconditions.checkArgument((boolean)n.isCall());
        Preconditions.checkArgument((boolean)stringNode.isStringLit());
        String separator = null;
        String stringValue = stringNode.getString();
        int limit = stringValue.length() + 1;
        if (arg1 != null) {
            if (arg1.isStringLit()) {
                separator = arg1.getString();
            } else if (!arg1.isNull()) {
                return n;
            }
            Node arg2 = arg1.getNext();
            if (arg2 != null) {
                if (arg2.isNumber()) {
                    limit = Math.min((int)arg2.getDouble(), limit);
                    if (limit < 0) {
                        return n;
                    }
                } else {
                    return n;
                }
            }
        }
        String[] stringArray = this.jsSplit(stringValue, separator, limit);
        Node arrayOfStrings = IR.arraylit(new Node[0]);
        for (String element : stringArray) {
            arrayOfStrings.addChildToBack(IR.string(element).srcref(stringNode));
        }
        Node parent = n.getParent();
        n.replaceWith(arrayOfStrings);
        this.reportChangeToEnclosingScope(parent);
        return arrayOfStrings;
    }

    private Node tryToFoldArrayConcat(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (Object)n);
        if (!this.isASTNormalized() || !this.useTypes) {
            return n;
        }
        ConcatFunctionCall concatFunctionCall = PeepholeReplaceKnownMethods.createConcatFunctionCallForNode(n);
        if (concatFunctionCall == null) {
            return n;
        }
        concatFunctionCall = this.tryToRemoveArrayLiteralFromFrontOfConcat(concatFunctionCall);
        Preconditions.checkNotNull((Object)concatFunctionCall);
        return this.tryToFoldConcatChaining(concatFunctionCall);
    }

    private ConcatFunctionCall tryToRemoveArrayLiteralFromFrontOfConcat(ConcatFunctionCall concatFunctionCall) {
        Preconditions.checkNotNull((Object)concatFunctionCall);
        Node callNode = concatFunctionCall.callNode;
        Node arrayLiteralToRemove = concatFunctionCall.calleeNode;
        if (!arrayLiteralToRemove.isArrayLit() || arrayLiteralToRemove.hasChildren()) {
            return concatFunctionCall;
        }
        Node firstArg = concatFunctionCall.firstArgumentNode;
        if (!PeepholeReplaceKnownMethods.containsExactlyArray(firstArg)) {
            return concatFunctionCall;
        }
        firstArg.detach();
        arrayLiteralToRemove.replaceWith(firstArg);
        this.reportChangeToEnclosingScope(callNode);
        return PeepholeReplaceKnownMethods.createConcatFunctionCallForNode(callNode);
    }

    private Node tryToFoldConcatChaining(ConcatFunctionCall concatFunctionCall) {
        Preconditions.checkNotNull((Object)concatFunctionCall);
        Node concatCallNode = concatFunctionCall.callNode;
        Node maybeFunctionCall = concatFunctionCall.calleeNode;
        if (!maybeFunctionCall.isCall()) {
            return concatCallNode;
        }
        ConcatFunctionCall previousConcatFunctionCall = PeepholeReplaceKnownMethods.createConcatFunctionCallForNode(maybeFunctionCall);
        if (previousConcatFunctionCall == null) {
            return concatCallNode;
        }
        for (Node arg = concatFunctionCall.firstArgumentNode; arg != null; arg = arg.getNext()) {
            if (!this.mayHaveSideEffects(arg)) continue;
            return concatCallNode;
        }
        Node previousConcatCallNode = previousConcatFunctionCall.callNode;
        for (Node arg = concatFunctionCall.firstArgumentNode; arg != null; arg = arg.getNext()) {
            Node currentArg = arg;
            previousConcatCallNode.addChildToBack(currentArg.detach());
        }
        concatCallNode.replaceWith(previousConcatCallNode.detach());
        this.reportChangeToEnclosingScope(previousConcatCallNode);
        return previousConcatCallNode;
    }

    private static @Nullable ConcatFunctionCall createConcatFunctionCallForNode(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (Object)n);
        Node callTarget = (Node)Preconditions.checkNotNull((Object)n.getFirstChild());
        if (!callTarget.isGetProp() || !callTarget.getString().equals("concat")) {
            return null;
        }
        Node calleeNode = callTarget.getFirstChild();
        if (!PeepholeReplaceKnownMethods.containsExactlyArray(calleeNode)) {
            return null;
        }
        Node firstArgumentNode = n.getSecondChild();
        return new ConcatFunctionCall(n, calleeNode, firstArgumentNode){};
    }

    private static boolean containsExactlyArray(Node n) {
        if (n == null) {
            return false;
        }
        if (n.isArrayLit()) {
            return true;
        }
        if (!n.isCall()) {
            return false;
        }
        Node callee = n.getFirstChild();
        return callee.isGetProp() && callee.getString().equals("concat") && PeepholeReplaceKnownMethods.containsExactlyArray(callee.getFirstChild());
    }

    private static abstract class ConcatFunctionCall {
        private final Node callNode;
        private final Node calleeNode;
        private final @Nullable Node firstArgumentNode;

        ConcatFunctionCall(Node callNode, Node calleeNode, Node firstArgumentNode) {
            this.callNode = (Node)Preconditions.checkNotNull((Object)callNode);
            this.calleeNode = (Node)Preconditions.checkNotNull((Object)calleeNode);
            this.firstArgumentNode = firstArgumentNode;
        }
    }
}

