/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.PassFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class PassListBuilder {
    private final CompilerOptions options;
    private final List<PassFactory> passes = new ArrayList<PassFactory>();

    public PassListBuilder(CompilerOptions options) {
        this.options = options;
    }

    public ImmutableList<PassFactory> build() {
        return ImmutableList.copyOf(this.passes);
    }

    public void addAll(PassListBuilder other) {
        this.passes.addAll((Collection<PassFactory>)other.build());
    }

    public void maybeAdd(PassFactory factory) {
        if (factory.getCondition().apply(this.options).booleanValue()) {
            this.passes.add(factory);
        }
    }

    public void addBefore(PassFactory factory, String passName) {
        this.passes.add(this.findIndexByName(passName), factory);
    }

    public void addAfter(PassFactory factory, String passName) {
        this.passes.add(this.findIndexByName(passName) + 1, factory);
    }

    @Deprecated
    public void addAllUpTo(PassListBuilder other, String passName) {
        ImmutableList<PassFactory> otherPasses = other.build();
        int index = -1;
        for (int i = 0; i < otherPasses.size(); ++i) {
            if (!passName.equals(((PassFactory)otherPasses.get(i)).getName())) continue;
            index = i;
            break;
        }
        this.passes.addAll((Collection<PassFactory>)otherPasses.subList(0, index + 1));
    }

    public PassFactory findByName(String name) {
        for (PassFactory pass : this.passes) {
            if (!pass.getName().equals(name)) continue;
            return pass;
        }
        throw new IllegalArgumentException("No factory named '" + name + "' in the factory list");
    }

    @Deprecated
    public void removeByName(String name) {
        for (int i = 0; i < this.passes.size(); ++i) {
            if (!this.passes.get(i).getName().equals(name)) continue;
            this.passes.remove(i);
            return;
        }
    }

    private int findIndexByName(String name) {
        for (int i = 0; i < this.passes.size(); ++i) {
            if (!this.passes.get(i).getName().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("No factory named '" + name + "' in the factory list");
    }

    public boolean contains(PassFactory factory) {
        return this.passes.contains(factory);
    }

    public void assertAllOneTimePasses() {
        for (PassFactory pass : this.passes) {
            Preconditions.checkState((!pass.isRunInFixedPointLoop() ? 1 : 0) != 0);
        }
    }

    public void assertAllLoopablePasses() {
        for (PassFactory pass : this.passes) {
            Preconditions.checkState((boolean)pass.isRunInFixedPointLoop());
        }
    }

    public void assertPassOrder(PassFactory pass1, PassFactory pass2, String msg) {
        int pass1Index = this.passes.indexOf(pass1);
        int pass2Index = this.passes.indexOf(pass2);
        if (pass1Index != -1 && pass2Index != -1) {
            Preconditions.checkState((pass1Index < pass2Index ? 1 : 0) != 0, (Object)msg);
        }
    }
}

