/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jspecify.nullness.Nullable;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final String ARGUMENTS = "arguments";
    private static final String PARAMETER_PREFIX = "JSCompiler_OptimizeArgumentsArray_p";
    private final String paramPrefix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = new ArrayDeque<List<Node>>();
    private List<Node> currentArgumentsAccesses = ImmutableList.of();

    OptimizeArgumentsArray(AbstractCompiler compiler) {
        this(compiler, PARAMETER_PREFIX);
    }

    OptimizeArgumentsArray(AbstractCompiler compiler, String paramPrefix) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.paramPrefix = (String)Preconditions.checkNotNull((Object)paramPrefix);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, (Node)Preconditions.checkNotNull((Object)root), this);
    }

    @Override
    public void enterScope(NodeTraversal traversal) {
        if (!OptimizeArgumentsArray.definesArgumentsVar(traversal.getScopeRoot())) {
            return;
        }
        this.argumentsAccessStack.push(this.currentArgumentsAccesses);
        this.currentArgumentsAccesses = new ArrayList<Node>();
    }

    @Override
    public void exitScope(NodeTraversal traversal) {
        if (!OptimizeArgumentsArray.definesArgumentsVar(traversal.getScopeRoot())) {
            return;
        }
        this.tryReplaceArguments(traversal.getScopeRoot());
        this.currentArgumentsAccesses = this.argumentsAccessStack.pop();
    }

    private static boolean definesArgumentsVar(Node root) {
        return root.isFunction() && !root.isArrowFunction();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal unused0, Node unused1, Node unused2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (traversal.inGlobalHoistScope()) {
            return;
        }
        if (node.isName() && ARGUMENTS.equals(node.getString())) {
            this.currentArgumentsAccesses.add(node);
        }
    }

    private void tryReplaceArguments(Node scopeRoot) {
        Node scopeRootParent = scopeRoot.getParent();
        if (scopeRootParent.isGetterDef()) {
            return;
        }
        Node parametersList = NodeUtil.getFunctionParameters(scopeRoot);
        Preconditions.checkState((boolean)parametersList.isParamList(), (Object)parametersList);
        int numParameters = parametersList.getChildCount();
        int highestIndex = this.getHighestIndex(numParameters - 1);
        if (highestIndex < 0) {
            return;
        }
        int maxCount = highestIndex + 1;
        if (scopeRootParent.isSetterDef()) {
            maxCount = 1;
        }
        ImmutableSortedMap<Integer, String> argNames = this.assembleParamNames(parametersList, maxCount);
        this.changeMethodSignature(argNames, parametersList);
        this.changeBody((ImmutableMap<Integer, String>)argNames);
    }

    private int getHighestIndex(int highestIndex) {
        for (Node ref : this.currentArgumentsAccesses) {
            Node getElem = ref.getParent();
            if (!getElem.isGetElem() || ref != getElem.getFirstChild()) {
                return -1;
            }
            Node indexNode = ref.getNext();
            if (!indexNode.isNumber()) {
                return -1;
            }
            double index = indexNode.getDouble();
            if (!JSCompDoubles.isExactInt32(index)) {
                return -1;
            }
            Node getElemParent = getElem.getParent();
            if (getElemParent.isCall() && getElemParent.getFirstChild() == getElem) {
                return -1;
            }
            int indexInt = (int)index;
            if (indexInt <= highestIndex) continue;
            highestIndex = indexInt;
        }
        return highestIndex;
    }

    private void changeMethodSignature(ImmutableSortedMap<Integer, String> argNames, Node paramList) {
        ImmutableSortedMap newParams = argNames.tailMap((Object)paramList.getChildCount());
        for (String name : newParams.values()) {
            paramList.addChildToBack(IR.name(name).srcrefIfMissing(paramList));
        }
        if (!newParams.isEmpty()) {
            this.compiler.reportChangeToEnclosingScope(paramList);
        }
    }

    private void changeBody(ImmutableMap<Integer, String> argNames) {
        for (Node ref : this.currentArgumentsAccesses) {
            Node index = ref.getNext();
            Node parent = ref.getParent();
            int value = (int)index.getDouble();
            @Nullable String name = (String)argNames.get((Object)value);
            if (name == null) continue;
            Node newName = IR.name(name).srcrefIfMissing(parent);
            parent.replaceWith(newName);
            this.compiler.reportChangeToEnclosingScope(newName);
        }
    }

    private ImmutableSortedMap<Integer, String> assembleParamNames(Node paramList, int maxCount) {
        Preconditions.checkArgument((boolean)paramList.isParamList(), (Object)paramList);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        int index = 0;
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            switch (param.getToken()) {
                case NAME: {
                    builder.put((Object)index, (Object)param.getString());
                    break;
                }
                case ITER_REST: {
                    return builder.buildOrThrow();
                }
                case DEFAULT_VALUE: 
                case OBJECT_PATTERN: 
                case ARRAY_PATTERN: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(param.toString());
                }
            }
            ++index;
        }
        while (index < maxCount) {
            builder.put((Object)index, (Object)(this.paramPrefix + this.uniqueId++));
            ++index;
        }
        return builder.buildOrThrow();
    }
}

