/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.AutoValue_ModuleRenaming_GlobalizedModuleName;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.jstype.JSType;
import java.util.List;
import org.jspecify.nullness.Nullable;

final class ModuleRenaming {
    static final String DEFAULT_EXPORT_VAR_PREFIX = "$jscompDefaultExport";

    private ModuleRenaming() {
    }

    static QualifiedName getGlobalNameOfEsModuleLocalVariable(ModuleMetadataMap.ModuleMetadata moduleMetadata, String variableName) {
        return QualifiedName.of(variableName + "$$" + ModuleRenaming.getGlobalName(moduleMetadata, null).join());
    }

    static QualifiedName getGlobalNameOfAnonymousDefaultExport(ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        return ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(moduleMetadata, DEFAULT_EXPORT_VAR_PREFIX);
    }

    static QualifiedName getGlobalName(ModuleMetadataMap.ModuleMetadata moduleMetadata, @Nullable String googNamespace) {
        return GlobalizedModuleName.create(moduleMetadata, googNamespace, null).aliasName();
    }

    static QualifiedName getGlobalName(Export export) {
        if (export.moduleMetadata().isEs6Module()) {
            if (export.localName().equals("*default*")) {
                return ModuleRenaming.getGlobalNameOfAnonymousDefaultExport(export.moduleMetadata());
            }
            return ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(export.moduleMetadata(), export.localName());
        }
        return ModuleRenaming.getGlobalName(export.moduleMetadata(), export.closureNamespace()).getprop(export.exportName());
    }

    static QualifiedName getGlobalName(Binding binding) {
        if (binding.isModuleNamespace()) {
            return ModuleRenaming.getGlobalName(binding.metadata(), binding.closureNamespace());
        }
        return ModuleRenaming.getGlobalName(binding.originatingExport());
    }

    private static @Nullable JSType getNameRootType(String qname, @Nullable TypedScope globalTypedScope) {
        if (globalTypedScope == null) {
            return null;
        }
        String root = NodeUtil.getRootOfQualifiedName(qname);
        return ((TypedVar)Preconditions.checkNotNull((Object)globalTypedScope.getVar(root), (String)"missing var for %s", (Object)root)).getType();
    }

    static String getGlobalNameForJsDoc(ModuleMap moduleMap, Binding binding, List<String> propertyChain) {
        int prop;
        for (prop = 0; binding.isModuleNamespace() && binding.metadata().isEs6Module() && prop < propertyChain.size(); ++prop) {
            String propertyName = propertyChain.get(prop);
            Module m = moduleMap.getModule(binding.metadata().path());
            if (!m.namespace().containsKey((Object)propertyName)) break;
            binding = (Binding)m.namespace().get((Object)propertyName);
        }
        QualifiedName globalName = ModuleRenaming.getGlobalName(binding);
        while (prop < propertyChain.size()) {
            globalName = globalName.getprop(propertyChain.get(prop++));
        }
        return globalName.join();
    }

    @AutoValue
    static abstract class GlobalizedModuleName {
        GlobalizedModuleName() {
        }

        abstract QualifiedName aliasName();

        abstract @Nullable JSType rootNameType();

        Node toQname(AstFactory astFactory) {
            Node rootName = astFactory.createName(this.aliasName().getRoot(), AstFactory.type(this.rootNameType()));
            if (this.aliasName().isSimple()) {
                return rootName;
            }
            return astFactory.createGetPropsWithoutColors(rootName, Iterables.skip(this.aliasName().components(), (int)1));
        }

        GlobalizedModuleName getprop(String property) {
            Preconditions.checkArgument((!property.isEmpty() && !property.contains(".") ? 1 : 0) != 0);
            return GlobalizedModuleName.create(this.aliasName().getprop(property), this.rootNameType());
        }

        static GlobalizedModuleName create(QualifiedName aliasName, JSType rootNameType) {
            return new AutoValue_ModuleRenaming_GlobalizedModuleName(aliasName, rootNameType);
        }

        static GlobalizedModuleName create(ModuleMetadataMap.ModuleMetadata moduleMetadata, @Nullable String googNamespace, @Nullable TypedScope globalTypedScope) {
            Preconditions.checkState((googNamespace == null || moduleMetadata.googNamespaces().contains((Object)googNamespace) ? 1 : 0) != 0);
            switch (moduleMetadata.moduleType()) {
                case GOOG_MODULE: {
                    Node moduleBody = moduleMetadata.rootNode().getFirstChild();
                    return new AutoValue_ModuleRenaming_GlobalizedModuleName(QualifiedName.of(ClosureRewriteModule.getBinaryModuleNamespace(googNamespace)), moduleBody.getJSType());
                }
                case GOOG_PROVIDE: 
                case LEGACY_GOOG_MODULE: {
                    return new AutoValue_ModuleRenaming_GlobalizedModuleName(QualifiedName.of(googNamespace), ModuleRenaming.getNameRootType(googNamespace, globalTypedScope));
                }
                case ES6_MODULE: 
                case COMMON_JS: {
                    return new AutoValue_ModuleRenaming_GlobalizedModuleName(QualifiedName.of(moduleMetadata.path().toModuleName()), ModuleRenaming.getNameRootType(moduleMetadata.path().toModuleName(), globalTypedScope));
                }
            }
            throw new IllegalStateException("Unexpected module type: " + moduleMetadata.moduleType());
        }
    }
}

