/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.IcuTemplateDefinition;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SourceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@GwtIncompatible(value="JsMessage.Builder")
public final class JsMessageExtractor {
    private final JsMessage.IdGenerator idGenerator;
    private final CompilerOptions options;
    private final boolean extractExternalMessages;

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator) {
        this(idGenerator, new CompilerOptions(), false);
    }

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, CompilerOptions options, boolean extractExternalMessages) {
        this.idGenerator = idGenerator;
        this.options = options;
        this.extractExternalMessages = extractExternalMessages;
    }

    public Collection<JsMessage> extractMessages(SourceFile ... inputs) {
        return this.extractMessages((Iterable<SourceFile>)ImmutableList.copyOf((Object[])inputs));
    }

    public Collection<JsMessage> extractMessages(Iterable<SourceFile> inputs) {
        ImmutableList<JSError> errors;
        Compiler compiler = new Compiler();
        compiler.init((List<SourceFile>)ImmutableList.of(), (List<SourceFile>)ImmutableList.copyOf(inputs), this.options);
        compiler.runInCompilerThread(() -> {
            compiler.parseInputs();
            return null;
        });
        ExtractMessagesVisitor extractCompilerPass = new ExtractMessagesVisitor(compiler);
        if (compiler.getErrors().isEmpty()) {
            extractCompilerPass.process(null, compiler.getRoot());
        }
        if (!(errors = compiler.getErrors()).isEmpty()) {
            StringBuilder msg = new StringBuilder("JSCompiler errors\n");
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(compiler);
            for (JSError e : errors) {
                msg.append(formatter.formatError(e));
            }
            throw new RuntimeException(msg.toString());
        }
        return extractCompilerPass.getMessages();
    }

    private class ExtractMessagesVisitor
    extends JsMessageVisitor {
        private final List<JsMessage> messages;

        private ExtractMessagesVisitor(AbstractCompiler compiler) {
            super(compiler, JsMessageExtractor.this.idGenerator);
            this.messages = new ArrayList<JsMessage>();
        }

        @Override
        protected void processJsMessageDefinition(JsMessageDefinition definition) {
            this.processJsMessage(definition.getMessage());
        }

        @Override
        protected void processIcuTemplateDefinition(IcuTemplateDefinition definition) {
            this.processJsMessage(definition.getMessage());
        }

        private void processJsMessage(JsMessage jsMessage) {
            if (JsMessageExtractor.this.extractExternalMessages || !jsMessage.isExternal()) {
                this.messages.add(jsMessage);
            }
        }

        public Collection<JsMessage> getMessages() {
            return this.messages;
        }
    }
}

