/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import java.util.ArrayList;
import org.jspecify.nullness.Nullable;

final class JsIterables {
    static final JSType getElementType(JSType iterableOrIterator, JSTypeRegistry typeRegistry) {
        TemplateTypeMap templateTypeMap = iterableOrIterator.autobox().getTemplateTypeMap();
        if (templateTypeMap.hasTemplateKey(typeRegistry.getIterableTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getIterableTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getIteratorValueTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getIteratorValueTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getAsyncIterableTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getAsyncIterableTemplate());
        }
        if (templateTypeMap.hasTemplateKey(typeRegistry.getAsyncIteratorValueTemplate())) {
            return templateTypeMap.getResolvedTemplateType(typeRegistry.getAsyncIteratorValueTemplate());
        }
        return typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    static final JSType createIterableTypeOf(JSType elementType, JSTypeRegistry typeRegistry) {
        return typeRegistry.createTemplatizedType(typeRegistry.getNativeObjectType(JSTypeNative.ITERABLE_TYPE), elementType);
    }

    static final MaybeBoxedType maybeBoxIterable(JSType type, JSTypeRegistry typeRegistry) {
        return JsIterables.maybeBoxIterableAndPossiblyAsyncIterable(type, typeRegistry, false);
    }

    static final MaybeBoxedType maybeBoxIterableOrAsyncIterable(JSType type, JSTypeRegistry typeRegistry) {
        return JsIterables.maybeBoxIterableAndPossiblyAsyncIterable(type, typeRegistry, true);
    }

    private static final MaybeBoxedType maybeBoxIterableAndPossiblyAsyncIterable(JSType type, JSTypeRegistry typeRegistry, boolean includeAsyncIterable) {
        ArrayList<JSType> templatedTypes = new ArrayList<JSType>();
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                boolean isAsyncIterable;
                alt = alt.isBoxableScalar() ? alt.autoboxesTo() : alt;
                boolean isIterable = alt.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ITERABLE_TYPE));
                boolean bl = isAsyncIterable = includeAsyncIterable && alt.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE));
                if (!isIterable && !isAsyncIterable) {
                    return new MaybeBoxedType(null, alt);
                }
                TemplateType valueTemplate = isAsyncIterable ? typeRegistry.getAsyncIterableTemplate() : typeRegistry.getIterableTemplate();
                templatedTypes.add(alt.getTemplateTypeMap().getResolvedTemplateType(valueTemplate));
            }
        } else {
            boolean isAsyncIterable;
            JSType autoboxedType = type.isBoxableScalar() ? type.autoboxesTo() : type;
            boolean isIterable = autoboxedType.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ITERABLE_TYPE));
            boolean bl = isAsyncIterable = includeAsyncIterable && autoboxedType.isSubtypeOf(typeRegistry.getNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE));
            if (!isIterable && !isAsyncIterable) {
                return new MaybeBoxedType(null, autoboxedType);
            }
            TemplateType templateType = isAsyncIterable ? typeRegistry.getAsyncIterableTemplate() : typeRegistry.getIterableTemplate();
            templatedTypes.add(autoboxedType.getTemplateTypeMap().getResolvedTemplateType(templateType));
        }
        return new MaybeBoxedType(typeRegistry.createUnionType(templatedTypes), null);
    }

    private JsIterables() {
    }

    static final class MaybeBoxedType {
        private final JSType templatedType;
        private final JSType mismatchType;

        private MaybeBoxedType(@Nullable JSType templatedType, @Nullable JSType mismatchType) {
            this.templatedType = templatedType;
            this.mismatchType = mismatchType;
        }

        JSType getTemplatedType() {
            if (!this.isMatch()) {
                throw new IllegalStateException("Type was not boxable to iterable or async iterable!");
            }
            return this.templatedType;
        }

        JSType getMismatchType() {
            return this.mismatchType;
        }

        JSType orElse(JSType type) {
            if (this.isMatch()) {
                return this.templatedType;
            }
            return type;
        }

        boolean isMatch() {
            return this.templatedType != null;
        }
    }
}

