/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AutoValue_JSError;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

@AutoValue
public abstract class JSError
implements Serializable {
    private static final int DEFAULT_LINENO = -1;
    private static final int DEFAULT_CHARNO = -1;
    private static final @Nullable String DEFAULT_SOURCENAME = null;
    private static final @Nullable Node DEFAULT_NODE = null;
    private static final @Nullable Requirement DEFAULT_REQUIREMENT = null;

    public abstract DiagnosticType getType();

    public abstract String getDescription();

    public abstract @Nullable String getSourceName();

    public abstract int getLineno();

    public abstract int getCharno();

    public abstract @Nullable Node getNode();

    public abstract CheckLevel getDefaultLevel();

    public abstract @Nullable Requirement getRequirement();

    public static JSError make(DiagnosticType type, String ... arguments) {
        return JSError.builder(type, arguments).build();
    }

    public static JSError make(String sourceName, int lineno, int charno, DiagnosticType type, String ... arguments) {
        return JSError.builder(type, arguments).setSourceLocation(sourceName, lineno, charno).build();
    }

    public static JSError make(Node n, DiagnosticType type, String ... arguments) {
        return JSError.builder(type, arguments).setNode(n).build();
    }

    public static JSError make(Requirement requirement, Node n, DiagnosticType type, String ... arguments) {
        return JSError.builder(type, arguments).setNode(n).setRequirement(requirement).build();
    }

    static Builder builder(DiagnosticType type, String ... arguments) {
        return new Builder(type, arguments);
    }

    public final String toString() {
        String sourceName = Strings.emptyToNull((String)this.getSourceName()) != null ? this.getSourceName() : "(unknown source)";
        String lineno = this.getLineno() != -1 ? String.valueOf(this.getLineno()) : "(unknown line)";
        String charno = this.getCharno() != -1 ? String.valueOf(this.getCharno()) : "(unknown column)";
        return this.getType().key + ". " + this.getDescription() + " at " + sourceName + " line " + lineno + " : " + charno;
    }

    public final @Nullable String format(CheckLevel level, MessageFormatter formatter) {
        switch (level) {
            case ERROR: {
                return formatter.formatError(this);
            }
            case WARNING: {
                return formatter.formatWarning(this);
            }
        }
        return null;
    }

    public final int getNodeSourceOffset() {
        return this.getNode() != null ? this.getNode().getSourceOffset() : -1;
    }

    public final int getNodeLength() {
        return this.getNode() != null ? this.getNode().getLength() : 0;
    }

    public final int getLineNumber() {
        return this.getLineno();
    }

    JSError() {
    }

    static final class Builder {
        private final DiagnosticType type;
        private final String[] args;
        private CheckLevel level;
        private Node n = DEFAULT_NODE;
        private String sourceName = DEFAULT_SOURCENAME;
        private int lineno = -1;
        private int charno = -1;
        private Requirement requirement = DEFAULT_REQUIREMENT;

        private Builder(DiagnosticType type, String ... args) {
            this.type = type;
            this.args = args;
            this.level = type.level;
        }

        @CanIgnoreReturnValue
        Builder setNode(Node n) {
            Preconditions.checkState((boolean)Objects.equals(DEFAULT_SOURCENAME, this.sourceName), (Object)"Cannot provide a Node when there's already a source name");
            this.n = n;
            this.sourceName = n.getSourceFileName();
            this.lineno = n.getLineno();
            this.charno = n.getCharno();
            return this;
        }

        @CanIgnoreReturnValue
        Builder setLevel(CheckLevel level) {
            this.level = (CheckLevel)Preconditions.checkNotNull((Object)level);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setRequirement(Requirement requirement) {
            this.requirement = (Requirement)Preconditions.checkNotNull((Object)requirement);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setSourceLocation(String sourceName, int lineno, int charno) {
            Preconditions.checkState((this.n == DEFAULT_NODE ? 1 : 0) != 0, (Object)"Cannot provide a source location when there is already a Node");
            this.sourceName = sourceName;
            this.lineno = lineno;
            this.charno = charno;
            return this;
        }

        JSError build() {
            return new AutoValue_JSError(this.type, this.type.format(this.args), this.sourceName, this.lineno, this.charno, this.n, this.level, this.requirement);
        }
    }
}

