/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@GwtIncompatible(value="java.util.zip.ZipFile")
final class JSCompZipFileCache {
    private static final int ZIP_CACHE_SIZE = Integer.parseInt(System.getProperty("jscomp.zipfile.cachesize", "1000"));
    private static final LoadingCache<String, CachedZipFile> zipFileCache = CacheBuilder.newBuilder().maximumSize((long)ZIP_CACHE_SIZE).removalListener(notification -> {
        try {
            ((CachedZipFile)notification.getValue()).maybeClose();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }).build((CacheLoader)new CacheLoader<String, CachedZipFile>(){

        public CachedZipFile load(String key) {
            return new CachedZipFile(key);
        }
    });

    static InputStream getEntryStream(String zipName, String entryName) throws IOException {
        return ((CachedZipFile)zipFileCache.getUnchecked((Object)zipName)).getEntryStream(entryName);
    }

    private JSCompZipFileCache() {
        throw new AssertionError();
    }

    private static final class CachedZipFile {
        private final Path path;
        private ZipFile zipFile;
        private volatile FileTime lastModified;

        private CachedZipFile(String zipName) {
            this.path = Path.of(zipName, new String[0]);
        }

        InputStream getEntryStream(String entryName) throws IOException {
            this.refreshIfNeeded();
            ZipEntry entry = (ZipEntry)Preconditions.checkNotNull((Object)this.zipFile.getEntry(entryName), (String)"%s!/%s", (Object)this.path, (Object)entryName);
            return this.zipFile.getInputStream(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshIfNeeded() throws IOException {
            FileTime newLastModified = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            if (newLastModified.equals(this.lastModified)) {
                return;
            }
            CachedZipFile cachedZipFile = this;
            synchronized (cachedZipFile) {
                if (newLastModified.equals(this.lastModified)) {
                    return;
                }
                this.maybeClose();
                this.zipFile = new ZipFile(this.path.toFile());
                this.lastModified = newLastModified;
            }
        }

        private void maybeClose() throws IOException {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
    }
}

