/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

class ExtractPrototypeMemberDeclarations
implements CompilerPass {
    private static final String PROTOTYPE_ALIAS = "JSCompiler_prototypeAlias";
    private final AbstractCompiler compiler;
    private final Pattern pattern;

    ExtractPrototypeMemberDeclarations(AbstractCompiler compiler, Pattern pattern) {
        this.compiler = compiler;
        this.pattern = pattern;
    }

    @Override
    public void process(Node externs, Node root) {
        GatherExtractionInfo extractionInfo = new GatherExtractionInfo();
        NodeTraversal.traverse(this.compiler, root, extractionInfo);
        this.maybeDoExtraction(extractionInfo);
    }

    private void maybeDoExtraction(GatherExtractionInfo info) {
        if (!(this.pattern != Pattern.USE_IIFE && this.pattern != Pattern.USE_GLOBAL_TEMP || info.shouldExtractGlobal())) {
            return;
        }
        if (this.pattern == Pattern.USE_GLOBAL_TEMP) {
            Node injectionPoint = this.compiler.getNodeForCodeInsertion(null);
            Node var = NodeUtil.newVarNode(PROTOTYPE_ALIAS, null).srcrefTreeIfMissing(injectionPoint);
            injectionPoint.addChildToFront(var);
            this.compiler.reportChangeToEnclosingScope(var);
        }
        for (Map.Entry<JSChunk, ExtractionInstanceInfo> entry : info.instancesByChunk.entrySet()) {
            Object alias = PROTOTYPE_ALIAS;
            if (this.pattern == Pattern.USE_CHUNK_TEMP) {
                if (!info.shouldExtractChunk(entry.getKey())) continue;
                Node injectionPoint = this.compiler.getNodeForCodeInsertion(entry.getKey());
                alias = PROTOTYPE_ALIAS + entry.getKey().getIndex();
                Node var = NodeUtil.newVarNode((String)alias, null).srcrefTreeIfMissing(injectionPoint);
                injectionPoint.addChildToFront(var);
                this.compiler.reportChangeToEnclosingScope(var);
            }
            for (ExtractionInstance instance : entry.getValue().instances) {
                this.extractInstance(instance, (String)alias);
            }
        }
    }

    private void extractInstance(ExtractionInstance instance, String alias) {
        PrototypeMemberDeclaration first = instance.declarations.get(0);
        String className = first.qualifiedClassName;
        if (this.pattern == Pattern.USE_GLOBAL_TEMP || this.pattern == Pattern.USE_CHUNK_TEMP) {
            Node classNameNode = NodeUtil.newQName(this.compiler, className);
            classNameNode.putBooleanProp(Node.IS_CONSTANT_NAME, first.constant);
            Node stmt = IR.exprResult(IR.assign(IR.name(alias), IR.getprop(classNameNode, "prototype"))).srcrefTreeIfMissing(first.node);
            stmt.insertBefore(first.node);
            this.compiler.reportChangeToEnclosingScope(stmt);
        } else if (this.pattern == Pattern.USE_IIFE) {
            Node block = IR.block();
            Node func = IR.function(IR.name(""), IR.paramList(IR.name(alias)), block);
            Node call = IR.call(func, NodeUtil.newQName(this.compiler, className + ".prototype", instance.parent, className + ".prototype"));
            call.putIntProp(Node.FREE_CALL, 1);
            Node stmt = IR.exprResult(call);
            stmt.srcrefTreeIfMissing(first.node);
            stmt.insertBefore(first.node);
            this.compiler.reportChangeToEnclosingScope(stmt);
            for (PrototypeMemberDeclaration declar : instance.declarations) {
                this.compiler.reportChangeToEnclosingScope(declar.node);
                block.addChildToBack(declar.node.detach());
            }
        }
        for (PrototypeMemberDeclaration declar : instance.declarations) {
            this.replacePrototypeMemberDeclaration(declar, alias);
        }
    }

    private void replacePrototypeMemberDeclaration(PrototypeMemberDeclaration declar, String alias) {
        Node assignment = declar.node.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node name = NodeUtil.newQName(this.compiler, alias + "." + declar.memberName, declar.node, declar.memberName);
        Node accessNode = declar.lhs.getFirstFirstChild();
        String originalName = accessNode.getOriginalName();
        String className = originalName != null ? originalName : "?";
        name.getFirstChild().srcrefTree(lhs);
        name.putBooleanProp(Node.IS_CONSTANT_NAME, lhs.getBooleanProp(Node.IS_CONSTANT_NAME));
        name.getFirstChild().setOriginalName(className + ".prototype");
        lhs.replaceWith(name);
        this.compiler.reportChangeToEnclosingScope(name);
    }

    static enum Pattern {
        USE_GLOBAL_TEMP("var t;".length(), "t=y.prototype;".length(), "t.y=".length() - "x[p].y=".length()),
        USE_CHUNK_TEMP("var t;".length(), "t=y.prototype;".length(), "t.y=".length() - "x[p].y=".length()),
        USE_IIFE(0, "(function(t){})(y.prototype);".length(), "t.y=".length() - "x.prototype.y=".length());

        private final int globalOverhead;
        private final int perExtractionOverhead;
        private final int perMemberOverhead;

        private Pattern(int globalOverHead, int perExtractionOverhead, int perMemberOverhead) {
            this.globalOverhead = globalOverHead;
            this.perExtractionOverhead = perExtractionOverhead;
            this.perMemberOverhead = perMemberOverhead;
        }
    }

    private class GatherExtractionInfo
    extends NodeTraversal.AbstractShallowCallback {
        private final Map<JSChunk, ExtractionInstanceInfo> instancesByChunk = new HashMap<JSChunk, ExtractionInstanceInfo>();

        private GatherExtractionInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isScript() && !n.isBlock()) {
                return;
            }
            for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null) continue;
                ExtractionInstance instance = new ExtractionInstance(prototypeMember, n);
                cur = ((PrototypeMemberDeclaration)Iterables.getLast(instance.declarations)).node;
                if (!instance.isFavorable()) continue;
                this.instancesByChunk.computeIfAbsent(t.getChunk(), k -> new ExtractionInstanceInfo());
                ExtractionInstanceInfo instanceInfo = this.instancesByChunk.get(t.getChunk());
                instanceInfo.instances.add(instance);
                instanceInfo.totalDelta += instance.delta;
            }
        }

        private boolean shouldExtractGlobal() {
            int allModulesDelta = 0;
            for (ExtractionInstanceInfo instanceInfo : this.instancesByChunk.values()) {
                allModulesDelta += instanceInfo.totalDelta;
            }
            return allModulesDelta + ExtractPrototypeMemberDeclarations.this.pattern.globalOverhead < 0;
        }

        private boolean shouldExtractChunk(JSChunk chunk) {
            ExtractionInstanceInfo instanceInfo = this.instancesByChunk.get(chunk);
            if (instanceInfo == null) {
                return false;
            }
            return instanceInfo.totalDelta + ExtractPrototypeMemberDeclarations.this.pattern.globalOverhead < 0;
        }
    }

    private static class ExtractionInstanceInfo {
        final List<ExtractionInstance> instances = new ArrayList<ExtractionInstance>();
        int totalDelta = 0;

        private ExtractionInstanceInfo() {
        }
    }

    private class ExtractionInstance {
        final List<PrototypeMemberDeclaration> declarations = new ArrayList<PrototypeMemberDeclaration>();
        private int delta = 0;
        private final Node parent;

        private ExtractionInstance(PrototypeMemberDeclaration head, Node parent) {
            this.parent = parent;
            this.declarations.add(head);
            this.delta = ExtractPrototypeMemberDeclarations.this.pattern.perExtractionOverhead + ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            for (Node cur = head.node.getNext(); cur != null; cur = cur.getNext()) {
                if (cur.isFunction()) continue;
                PrototypeMemberDeclaration prototypeMember = PrototypeMemberDeclaration.extractDeclaration(cur);
                if (prototypeMember == null || !head.isSameClass(prototypeMember)) break;
                this.declarations.add(prototypeMember);
                this.delta += ExtractPrototypeMemberDeclarations.this.pattern.perMemberOverhead;
            }
        }

        boolean isFavorable() {
            return this.delta <= 0;
        }
    }

    private static class PrototypeMemberDeclaration {
        final String memberName;
        final Node node;
        final String qualifiedClassName;
        final Node lhs;
        final boolean constant;

        private PrototypeMemberDeclaration(Node lhs, Node node) {
            Preconditions.checkState((boolean)NodeUtil.isExprAssign(node), (Object)node);
            this.lhs = lhs;
            this.memberName = NodeUtil.getPrototypePropertyName(lhs);
            this.node = node;
            Node classNode = PrototypeMemberDeclaration.getPrototypeClassName(lhs);
            this.qualifiedClassName = classNode.getQualifiedName();
            this.constant = classNode.getBooleanProp(Node.IS_CONSTANT_NAME);
        }

        private boolean isSameClass(PrototypeMemberDeclaration other) {
            return this.qualifiedClassName.equals(other.qualifiedClassName);
        }

        private static @Nullable Node getPrototypeClassName(Node qName) {
            Node cur = qName;
            while (cur.isGetProp()) {
                if (cur.getString().equals("prototype")) {
                    return cur.getFirstChild();
                }
                cur = cur.getFirstChild();
            }
            return null;
        }

        private static boolean isPrototypePropertyDeclaration(Node n) {
            if (!NodeUtil.isExprAssign(n)) {
                return false;
            }
            Node lvalue = n.getFirstFirstChild();
            if (lvalue.isGetProp()) {
                Node cur = lvalue.getFirstChild();
                while (cur.isGetProp()) {
                    if (cur.getString().equals("prototype")) {
                        return cur.isQualifiedName();
                    }
                    cur = cur.getFirstChild();
                }
            }
            return false;
        }

        private static @Nullable PrototypeMemberDeclaration extractDeclaration(Node n) {
            if (!PrototypeMemberDeclaration.isPrototypePropertyDeclaration(n)) {
                return null;
            }
            Node lhs = n.getFirstFirstChild();
            return new PrototypeMemberDeclaration(lhs, n);
        }
    }
}

