/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_Es6RewriteModulesToCommonJsModules_ModuleRequest;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jspecify.nullness.Nullable;

public class Es6RewriteModulesToCommonJsModules
implements CompilerPass {
    private static final String JSCOMP_DEFAULT_EXPORT = "$$default";
    private static final String MODULE = "$$module";
    private static final String EXPORTS = "$$exports";
    private static final String REQUIRE = "$$require";
    private final AbstractCompiler compiler;

    public Es6RewriteModulesToCommonJsModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            if (!Es6RewriteModules.isEs6ModuleRoot(script)) continue;
            NodeTraversal.traverse(this.compiler, script, new Rewriter(this.compiler, script));
        }
        NodeUtil.removeFeatureFromAllScripts(root, FeatureSet.Feature.MODULES, this.compiler);
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    private static String normalizePath(String path) {
        int indexOfProtocol = path.indexOf("://");
        if (indexOfProtocol > -1) {
            int indexOfSlash = (path = path.substring(indexOfProtocol + 3)).indexOf(47);
            if (indexOfSlash > -1) {
                path = path.substring(indexOfSlash + 1);
            }
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static class Rewriter
    extends NodeTraversal.AbstractPostOrderCallback {
        private @Nullable Node requireInsertSpot;
        private final Node script;
        private final Map<String, LocalQName> exportedNameToLocalQName;
        private final Set<Node> imports;
        private final Set<ModuleRequest> importRequests;
        private final AbstractCompiler compiler;
        private final ModuleLoader.ModulePath modulePath;

        Rewriter(AbstractCompiler compiler, Node script) {
            this.compiler = compiler;
            this.script = script;
            this.requireInsertSpot = null;
            this.exportedNameToLocalQName = new TreeMap<String, LocalQName>();
            this.importRequests = new LinkedHashSet<ModuleRequest>();
            this.imports = new HashSet<Node>();
            this.modulePath = compiler.getInput(script.getInputId()).getPath();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case IMPORT: {
                    this.visitImport(t.getInput().getPath(), n);
                    break;
                }
                case EXPORT: {
                    this.visitExport(t, n, parent);
                    break;
                }
                case SCRIPT: {
                    this.visitScript(t, n);
                    break;
                }
                case NAME: {
                    this.maybeRenameImportedValue(t, n);
                    break;
                }
            }
        }

        private String getVarNameOfImport(Node importDecl) {
            Preconditions.checkState((boolean)importDecl.isImport());
            if (importDecl.getSecondChild().isImportStar()) {
                return importDecl.getSecondChild().getString();
            }
            return this.getVarNameOfImport(importDecl.getLastChild().getString());
        }

        private String getVarNameOfImport(String importRequest) {
            return this.modulePath.resolveModuleAsPath(importRequest).toModuleName();
        }

        private String getNameOfImportedValue(Node nameNode) {
            Node importDecl = nameNode;
            while (!importDecl.isImport()) {
                importDecl = importDecl.getParent();
            }
            String moduleName = this.getVarNameOfImport(importDecl);
            if (nameNode.getParent().isImportSpec()) {
                return moduleName + "." + nameNode.getParent().getFirstChild().getString();
            }
            if (nameNode.isImportStar()) {
                return moduleName;
            }
            Preconditions.checkState((boolean)nameNode.getParent().isImport());
            return moduleName + ".default";
        }

        private @Nullable String maybeGetNameOfImportedValue(Scope s, Node nameNode) {
            Preconditions.checkState((boolean)nameNode.isName());
            Var var = (Var)s.getVar(nameNode.getString());
            if (var != null && var.getNameNode() != null && NodeUtil.isImportedName(var.getNameNode()) && nameNode != var.getNameNode()) {
                return this.getNameOfImportedValue(var.getNameNode());
            }
            return null;
        }

        private void maybeRenameImportedValue(NodeTraversal t, Node n) {
            Preconditions.checkState((boolean)n.isName());
            Node parent = n.getParent();
            if (parent.isExport() || parent.isExportSpec() || parent.isImport() || parent.isImportSpec()) {
                return;
            }
            String qName = this.maybeGetNameOfImportedValue(t.getScope(), n);
            if (qName != null) {
                n.replaceWith(NodeUtil.newQName(this.compiler, qName));
                t.reportCodeChange();
            }
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkState((this.script == script ? 1 : 0) != 0);
            Node moduleNode = script.getFirstChild();
            Preconditions.checkState((boolean)moduleNode.isModuleBody());
            moduleNode.detach();
            script.addChildrenToFront(moduleNode.removeChildren());
            this.addRequireCalls();
            this.addExportDef();
            this.registerAndLoadModule(t);
        }

        private void addRequireCalls() {
            if (!this.importRequests.isEmpty()) {
                for (Node importDecl : this.imports) {
                    importDecl.detach();
                }
                HashSet<String> importedNames = new HashSet<String>();
                for (ModuleRequest request : this.importRequests) {
                    String varName = request.varName();
                    if (!importedNames.add(varName)) continue;
                    Node requireCall = IR.call(IR.name(Es6RewriteModulesToCommonJsModules.REQUIRE), IR.string(request.specifier()));
                    requireCall.putBooleanProp(Node.FREE_CALL, true);
                    Node decl = IR.var(IR.name(varName), requireCall);
                    decl.srcrefTreeIfMissing(this.script);
                    if (this.requireInsertSpot == null) {
                        this.script.addChildToFront(decl);
                    } else {
                        decl.insertAfter(this.requireInsertSpot);
                    }
                    this.requireInsertSpot = decl;
                }
            }
        }

        private void registerAndLoadModule(NodeTraversal t) {
            Node block = IR.block();
            block.addChildrenToFront(this.script.removeChildren());
            Node moduleFunction = IR.function(IR.name(""), IR.paramList(IR.name(Es6RewriteModulesToCommonJsModules.REQUIRE), IR.name(Es6RewriteModulesToCommonJsModules.EXPORTS), IR.name(Es6RewriteModulesToCommonJsModules.MODULE)), block);
            Node shallowDeps = new Node(Token.ARRAYLIT);
            for (ModuleRequest request : this.importRequests) {
                shallowDeps.addChildToBack(IR.string(request.specifier()));
            }
            Node exprResult = IR.exprResult(IR.call(IR.getprop(IR.name("$jscomp"), "registerAndLoadModule"), moduleFunction, IR.string(Es6RewriteModulesToCommonJsModules.normalizePath(this.compiler.getModuleLoader().resolve(t.getInput().getName()).toString())), shallowDeps));
            this.script.addChildToBack(exprResult.srcrefTreeIfMissing(this.script));
            this.compiler.reportChangeToChangeScope(this.script);
            this.compiler.reportChangeToChangeScope(moduleFunction);
            t.reportCodeChange();
        }

        private void addExportDef() {
            if (!this.exportedNameToLocalQName.isEmpty()) {
                Node definePropertiesLit = IR.objectlit(new Node[0]);
                for (Map.Entry<String, LocalQName> entry : this.exportedNameToLocalQName.entrySet()) {
                    this.addExport(definePropertiesLit, entry.getKey(), entry.getValue());
                }
                this.script.addChildToFront(IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "Object.defineProperties"), IR.name(Es6RewriteModulesToCommonJsModules.EXPORTS), definePropertiesLit)).srcrefTreeIfMissing(this.script));
            }
        }

        private void addExport(Node definePropertiesLit, String exportedName, LocalQName localQName) {
            Node exportedValue = NodeUtil.newQName(this.compiler, localQName.qName);
            Node getterFunction = IR.function(IR.name(""), IR.paramList(new Node[0]), IR.block(IR.returnNode(exportedValue)));
            getterFunction.srcrefTree(localQName.nodeForSourceInfo);
            Node objLit = IR.objectlit(IR.stringKey("enumerable", IR.trueNode()), IR.stringKey("get", getterFunction));
            definePropertiesLit.addChildToBack(IR.stringKey(exportedName, objLit));
            this.compiler.reportChangeToChangeScope(getterFunction);
        }

        private void visitImport(ModuleLoader.ModulePath path, Node importDecl) {
            if (importDecl.getLastChild().getString().contains("://")) {
                this.compiler.report(JSError.make(importDecl, TranspilationUtil.CANNOT_CONVERT, "Module requests with protocols."));
            }
            this.importRequests.add(ModuleRequest.create(Es6RewriteModulesToCommonJsModules.normalizePath(path.resolveModuleAsPath(importDecl.getLastChild().getString()).toString()), this.getVarNameOfImport(importDecl)));
            this.imports.add(importDecl);
        }

        private void visitExportDefault(NodeTraversal t, Node export) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.detach();
                export.replaceWith(decl);
            } else {
                name = Es6RewriteModulesToCommonJsModules.JSCOMP_DEFAULT_EXPORT;
                Node var = IR.constNode(IR.name(name), export.removeFirstChild());
                export.replaceWith(var.srcrefTreeIfMissing(export));
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
            }
            this.exportedNameToLocalQName.put("default", new LocalQName(name, export));
            t.reportCodeChange();
        }

        private void visitExportFrom(NodeTraversal t, Node export, Node parent) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = IR.importNode(IR.empty(), IR.empty(), moduleIdentifier.cloneNode());
            importNode.srcref(export);
            importNode.insertBefore(export);
            this.visit(t, importNode, parent);
            String moduleName = this.getVarNameOfImport(moduleIdentifier.getString());
            for (Node exportSpec = export.getFirstFirstChild(); exportSpec != null; exportSpec = exportSpec.getNext()) {
                this.exportedNameToLocalQName.put(exportSpec.getLastChild().getString(), new LocalQName(moduleName + "." + exportSpec.getFirstChild().getString(), exportSpec));
            }
            export.detach();
            t.reportCodeChange();
        }

        private void visitExportSpecs(NodeTraversal t, Node export) {
            for (Node exportSpec = export.getFirstFirstChild(); exportSpec != null; exportSpec = exportSpec.getNext()) {
                String localName = exportSpec.getFirstChild().getString();
                Var var = (Var)t.getScope().getVar(localName);
                if (var != null && NodeUtil.isImportedName(var.getNameNode())) {
                    localName = this.maybeGetNameOfImportedValue(t.getScope(), exportSpec.getFirstChild());
                    Preconditions.checkNotNull((Object)localName);
                }
                this.exportedNameToLocalQName.put(exportSpec.getLastChild().getString(), new LocalQName(localName, exportSpec));
            }
            export.detach();
            t.reportCodeChange();
        }

        private void visitExportNameDeclaration(Node declaration) {
            NodeUtil.visitLhsNodesInNode(declaration, this::addExportedName);
        }

        private void addExportedName(Node lhs) {
            Preconditions.checkState((boolean)lhs.isName());
            String name = lhs.getString();
            this.exportedNameToLocalQName.put(name, new LocalQName(name, lhs));
        }

        private void visitExportDeclaration(NodeTraversal t, Node export) {
            Node declaration = export.getFirstChild();
            if (NodeUtil.isNameDeclaration(declaration)) {
                this.visitExportNameDeclaration(declaration);
            } else {
                Preconditions.checkState((declaration.isFunction() || declaration.isClass() ? 1 : 0) != 0);
                String name = declaration.getFirstChild().getString();
                this.exportedNameToLocalQName.put(name, new LocalQName(name, export));
            }
            export.replaceWith(declaration.detach());
            t.reportCodeChange();
        }

        private void visitExportStar(NodeTraversal t, Node export, Node parent) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = IR.importNode(IR.empty(), IR.empty(), moduleIdentifier.cloneNode());
            importNode.srcref(export);
            importNode.insertBefore(export);
            this.visit(t, importNode, parent);
            String moduleName = this.getVarNameOfImport(moduleIdentifier.getString());
            export.replaceWith(IR.exprResult(IR.call(IR.getprop(IR.name(Es6RewriteModulesToCommonJsModules.MODULE), "exportAllFrom"), IR.name(moduleName))).srcrefTree(export));
            t.reportCodeChange();
        }

        private void visitExport(NodeTraversal t, Node export, Node parent) {
            if (export.getBooleanProp(Node.EXPORT_DEFAULT)) {
                this.visitExportDefault(t, export);
            } else if (export.getBooleanProp(Node.EXPORT_ALL_FROM)) {
                this.visitExportStar(t, export, parent);
            } else if (export.hasTwoChildren()) {
                this.visitExportFrom(t, export, parent);
            } else if (export.getFirstChild().isExportSpecs()) {
                this.visitExportSpecs(t, export);
            } else {
                this.visitExportDeclaration(t, export);
            }
        }
    }

    @AutoValue
    static abstract class ModuleRequest {
        ModuleRequest() {
        }

        abstract String specifier();

        abstract String varName();

        private static ModuleRequest create(String specifier, String varName) {
            return new AutoValue_Es6RewriteModulesToCommonJsModules_ModuleRequest(specifier, varName);
        }
    }

    private static class LocalQName {
        final String qName;
        final Node nodeForSourceInfo;

        LocalQName(String qName, Node nodeForSourceInfo) {
            this.qName = qName;
            this.nodeForSourceInfo = nodeForSourceInfo;
        }
    }
}

