/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Table;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;

final class Es6RenameReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private final Table<Node, String, String> renameTable;

    Es6RenameReferences(Table<Node, String, String> renameTable) {
        this.renameTable = renameTable;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isReferenceName(n)) {
            this.renameReference(t, n, n.getString());
        }
    }

    private void renameReference(NodeTraversal t, Node n, String oldName) {
        for (Scope current = t.getScope(); current != null; current = current.getParent()) {
            String newName = (String)this.renameTable.get((Object)current.getRootNode(), (Object)oldName);
            if (newName != null) {
                n.setString(newName);
                t.reportCodeChange();
                return;
            }
            if (!current.hasOwnSlot(oldName)) continue;
            return;
        }
    }
}

