/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import org.jspecify.nullness.Nullable;

public final class DestructuredTarget {
    private final JSTypeRegistry registry;
    private final @Nullable Node objectPatternKey;
    private final @Nullable Node node;
    private final Supplier<JSType> patternTypeSupplier;
    private final @Nullable Node defaultValue;
    private final boolean isRest;
    private final Node pattern;

    private DestructuredTarget(Node pattern, Node node, @Nullable Node defaultValue, @Nullable Node objectPatternKey, JSTypeRegistry registry, Supplier<JSType> patternTypeSupplier, boolean isRest) {
        this.pattern = pattern;
        this.node = node;
        this.objectPatternKey = objectPatternKey;
        this.registry = registry;
        this.patternTypeSupplier = patternTypeSupplier;
        this.isRest = isRest;
        this.defaultValue = defaultValue;
    }

    public @Nullable Node getComputedProperty() {
        return this.hasComputedProperty() ? this.objectPatternKey : null;
    }

    public boolean hasComputedProperty() {
        return this.objectPatternKey != null && this.objectPatternKey.isComputedProp();
    }

    public boolean hasStringKey() {
        return this.objectPatternKey != null && this.objectPatternKey.isStringKey();
    }

    public @Nullable Node getStringKey() {
        return this.hasStringKey() ? this.objectPatternKey : null;
    }

    public @Nullable Node getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Node getNode() {
        return this.node;
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, JSType destructuringPatternType, Node destructuringChild) {
        return DestructuredTarget.createTarget(registry, (Supplier<JSType>)((Supplier)() -> destructuringPatternType), destructuringChild);
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, Supplier<JSType> destructuringPatternType, Node destructuringChild) {
        Preconditions.checkArgument((boolean)destructuringChild.getParent().isDestructuringPattern(), (Object)destructuringChild);
        Builder builder = new Builder(registry, destructuringChild.getParent(), destructuringPatternType);
        switch (destructuringChild.getToken()) {
            case STRING_KEY: {
                builder.setObjectPatternKey(destructuringChild);
                Node value = destructuringChild.getFirstChild();
                if (value.isDefaultValue()) {
                    builder.setNode(value.getFirstChild());
                    builder.setDefaultValue(value.getSecondChild());
                    break;
                }
                builder.setNode(value);
                break;
            }
            case COMPUTED_PROP: {
                builder.setObjectPatternKey(destructuringChild);
                Node value = destructuringChild.getSecondChild();
                if (value.isDefaultValue()) {
                    builder.setNode(value.getFirstChild());
                    builder.setDefaultValue(value.getSecondChild());
                    break;
                }
                builder.setNode(value);
                break;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case NAME: 
            case GETELEM: 
            case GETPROP: {
                builder.setNode(destructuringChild);
                break;
            }
            case DEFAULT_VALUE: {
                builder.setNode(destructuringChild.getFirstChild());
                builder.setDefaultValue(destructuringChild.getSecondChild());
                break;
            }
            case ITER_REST: 
            case OBJECT_REST: {
                builder.setNode(destructuringChild.getFirstChild());
                builder.setIsRest(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected child of destructuring pattern " + destructuringChild);
            }
        }
        return builder.build();
    }

    public static ImmutableList<DestructuredTarget> createAllNonEmptyTargetsInPattern(JSTypeRegistry registry, JSType patternType, Node pattern) {
        return DestructuredTarget.createAllNonEmptyTargetsInPattern(registry, (Supplier<JSType>)((Supplier)() -> patternType), pattern);
    }

    public static ImmutableList<DestructuredTarget> createAllNonEmptyTargetsInPattern(JSTypeRegistry registry, Supplier<JSType> patternType, Node pattern) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern(), (Object)pattern);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node child = pattern.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isEmpty()) continue;
            builder.add((Object)DestructuredTarget.createTarget(registry, patternType, child));
        }
        return builder.build();
    }

    JSType inferTypeWithoutUsingDefaultValue() {
        if (this.pattern.isObjectPattern()) {
            return this.inferObjectPatternKeyType();
        }
        return this.inferArrayPatternTargetType();
    }

    JSType inferType() {
        JSType inferredType = this.inferTypeWithoutUsingDefaultValue();
        if (!inferredType.isUnknownType() && this.hasDefaultValue()) {
            JSType defaultValueType = this.getDefaultValue().getJSType();
            if (defaultValueType == null) {
                defaultValueType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return this.registry.createUnionType(inferredType.restrictByNotUndefined(), defaultValueType);
        }
        return inferredType;
    }

    private JSType inferObjectPatternKeyType() {
        JSType patternType = (JSType)this.patternTypeSupplier.get();
        if (this.isRest) {
            return this.registry.getNativeType(JSTypeNative.OBJECT_TYPE);
        }
        if (patternType == null || patternType.isUnknownType()) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        switch (this.objectPatternKey.getToken()) {
            case STRING_KEY: {
                JSType propertyType = patternType.findPropertyType(this.objectPatternKey.getString());
                return propertyType != null ? propertyType : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case COMPUTED_PROP: {
                return patternType != null ? patternType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getObjectElementKey()) : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
        }
        throw new IllegalStateException("Unexpected key " + this.objectPatternKey);
    }

    private JSType inferArrayPatternTargetType() {
        JSType patternType = (JSType)this.patternTypeSupplier.get();
        JSType templateTypeOfIterable = patternType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
        if (this.isRest) {
            return this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), templateTypeOfIterable);
        }
        return templateTypeOfIterable;
    }

    private static class Builder {
        private final JSTypeRegistry registry;
        private final Supplier<JSType> patternTypeSupplier;
        private final Node pattern;
        private Node node;
        private @Nullable Node defaultValue = null;
        private @Nullable Node objectPatternKey = null;
        private boolean isRest = false;

        Builder(JSTypeRegistry registry, Node pattern, Supplier<JSType> patternTypeSupplier) {
            this.registry = registry;
            this.patternTypeSupplier = patternTypeSupplier;
            this.pattern = pattern;
        }

        @CanIgnoreReturnValue
        Builder setNode(Node node) {
            this.node = node;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setDefaultValue(Node defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setObjectPatternKey(Node objectPatternKey) {
            this.objectPatternKey = objectPatternKey;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setIsRest(boolean isRest) {
            this.isRest = isRest;
            return this;
        }

        DestructuredTarget build() {
            Preconditions.checkNotNull((Object)this.node, (Object)"Must set a node");
            return new DestructuredTarget(this.pattern, this.node, this.defaultValue, this.objectPatternKey, this.registry, this.patternTypeSupplier, this.isRest);
        }
    }
}

