/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Set;

class DeclaredGlobalExternsOnWindow
implements CompilerPass,
NodeTraversal.Callback {
    private static final String WINDOW_NAME = "window";
    private final AbstractCompiler compiler;
    private final Set<Node> nodes = new LinkedHashSet<Node>();
    private boolean windowInExterns = false;

    public DeclaredGlobalExternsOnWindow(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        this.addWindowProperties();
    }

    private void addWindowProperties() {
        if (!this.nodes.isEmpty()) {
            for (Node node : this.nodes) {
                DeclaredGlobalExternsOnWindow.addExtern(node, this.windowInExterns);
                this.compiler.reportChangeToEnclosingScope(node);
            }
        }
    }

    private static void addExtern(Node node, boolean defineOnWindow) {
        Node getprop;
        String name = node.getString();
        JSDocInfo oldJSDocInfo = NodeUtil.getBestJSDocInfo(node);
        Node globalRef = defineOnWindow ? IR.name(WINDOW_NAME) : IR.thisNode();
        Node newNode = getprop = IR.getprop(globalRef, name);
        if (oldJSDocInfo != null) {
            JSDocInfo.Builder builder;
            if (oldJSDocInfo.isConstructorOrInterface() || oldJSDocInfo.hasEnumParameterType()) {
                Node nameNode = IR.name(name);
                newNode = IR.assign(getprop, nameNode);
                builder = JSDocInfo.builder();
                if (oldJSDocInfo.isConstructor()) {
                    builder.recordConstructor();
                }
                if (oldJSDocInfo.isInterface()) {
                    builder.recordInterface();
                }
                if (oldJSDocInfo.usesImplicitMatch()) {
                    builder.recordImplicitMatch();
                }
                if (oldJSDocInfo.hasEnumParameterType()) {
                    builder.recordEnumParameterType(oldJSDocInfo.getEnumParameterType());
                }
            } else {
                if (NodeUtil.isNamespaceDecl(node)) {
                    newNode = IR.assign(getprop, IR.name(name));
                } else {
                    Node rhs = NodeUtil.getRValueOfLValue(node);
                    if (oldJSDocInfo.hasConstAnnotation() && rhs != null && rhs.isQualifiedName()) {
                        newNode = IR.assign(getprop, rhs.cloneTree());
                    }
                }
                builder = JSDocInfo.Builder.copyFrom(oldJSDocInfo);
            }
            builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"const", (Object)"duplicate"));
            JSDocInfo jsDocInfo = builder.build();
            newNode.setJSDocInfo(jsDocInfo);
        }
        newNode.srcrefTree(node);
        newNode.setOriginalName(name);
        newNode.makeNonIndexableRecursive();
        node.getGrandparent().addChildToBack(IR.exprResult(newNode));
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            this.nodes.add(n.getFirstChild());
        } else if (n.isVar()) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (c.getString().equals(WINDOW_NAME)) {
                    this.windowInExterns = true;
                    continue;
                }
                if (c.getString().equals("location")) continue;
                this.nodes.add(c);
            }
        }
    }
}

