/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

final class ConvertChunksToESModules
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<JSChunk, Set<String>> crossChunkExports = new LinkedHashMap<JSChunk, Set<String>>();
    private final Map<JSChunk, Map<JSChunk, Set<String>>> crossChunkImports = new LinkedHashMap<JSChunk, Map<JSChunk, Set<String>>>();
    private final List<Node> dynamicImportCallbacks = new ArrayList<Node>();
    static final String DYNAMIC_IMPORT_CALLBACK_FN = "jscomp$DynamicImportCallback";
    static final DiagnosticType ASSIGNMENT_TO_IMPORT = DiagnosticType.error("JSC_IMPORT_ASSIGN", "Imported symbol \"{0}\" in chunk \"{1}\" cannot be assigned");
    static final DiagnosticType UNABLE_TO_COMPUTE_RELATIVE_PATH = DiagnosticType.error("JSC_UNABLE_TO_COMPUTE_RELATIVE_PATH", "Unable to compute relative import path from \"{0}\" to \"{1}\"");
    static final DiagnosticType UNRECOGNIZED_DYNAMIC_IMPORT_CALLBACK = DiagnosticType.error("JSC_UNRECOGNIZED_DYNAMIC_IMPORT_CALLBACK", "Dynamic import callback encountered wih an invalid format.{0}");

    ConvertChunksToESModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new FindCrossChunkReferences());
        for (JSChunk chunk : this.compiler.getChunkGraph().getAllChunks()) {
            if (this.crossChunkExports.containsKey(chunk) || this.crossChunkImports.containsKey(chunk) || chunk.getInputs().isEmpty()) continue;
            this.crossChunkExports.put(chunk, new LinkedHashSet());
        }
        this.convertChunkSourcesToModules();
        this.addExportStatements();
        this.addImportStatements();
        this.rewriteDynamicImportCallbacks();
        NodeUtil.addFeatureToAllScripts(root, FeatureSet.Feature.MODULES, this.compiler);
    }

    private void convertChunkSourcesToModules() {
        for (JSChunk chunk : this.compiler.getChunkGraph().getAllChunks()) {
            if (chunk.getInputs().isEmpty()) continue;
            CompilerInput firstInput = null;
            for (CompilerInput input : chunk.getInputs()) {
                Node astRoot = input.getAstRoot(this.compiler);
                FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(astRoot);
                Preconditions.checkState((!scriptFeatures.contains(FeatureSet.ES2015_MODULES) ? 1 : 0) != 0);
                if (firstInput == null) {
                    firstInput = input;
                    scriptFeatures = scriptFeatures.union(FeatureSet.ES2015_MODULES);
                    astRoot.putProp(Node.FEATURE_SET, scriptFeatures);
                    Node moduleBody = new Node(Token.MODULE_BODY);
                    moduleBody.srcref(astRoot);
                    moduleBody.addChildrenToFront(astRoot.removeChildren());
                    astRoot.addChildToFront(moduleBody);
                    this.compiler.reportChangeToEnclosingScope(moduleBody);
                    continue;
                }
                Node firstInputAstRoot = firstInput.getAstRoot(this.compiler);
                FeatureSet firstInputScriptFeatures = NodeUtil.getFeatureSetOfScript(firstInputAstRoot);
                FeatureSet combinedFeatureSet = firstInputScriptFeatures.union(NodeUtil.getFeatureSetOfScript(astRoot));
                astRoot.putProp(Node.FEATURE_SET, combinedFeatureSet);
                Node moduleBody = firstInputAstRoot.getFirstChild();
                Preconditions.checkState((moduleBody != null && moduleBody.isModuleBody() ? 1 : 0) != 0);
                moduleBody.addChildrenToBack(astRoot.removeChildren());
                this.compiler.reportChangeToEnclosingScope(firstInputAstRoot);
                this.compiler.reportChangeToChangeScope(astRoot);
            }
        }
    }

    private void addExportStatements() {
        for (Map.Entry<JSChunk, Set<String>> jsModuleExports : this.crossChunkExports.entrySet()) {
            CompilerInput firstInput = jsModuleExports.getKey().getFirst();
            Node moduleBody = firstInput.getAstRoot(this.compiler).getFirstChild();
            Preconditions.checkState((moduleBody != null && moduleBody.isModuleBody() ? 1 : 0) != 0);
            Node exportSpecs = new Node(Token.EXPORT_SPECS);
            for (String name : jsModuleExports.getValue()) {
                Node exportSpec = new Node(Token.EXPORT_SPEC);
                exportSpec.addChildToFront(IR.name(name));
                exportSpec.addChildToFront(IR.name(name));
                exportSpec.putIntProp(Node.IS_SHORTHAND_PROPERTY, 1);
                exportSpecs.addChildToBack(exportSpec);
            }
            Map<JSChunk, Set<String>> importsByChunk = this.crossChunkImports.get(jsModuleExports.getKey());
            if (!exportSpecs.hasChildren() && importsByChunk != null && !importsByChunk.isEmpty()) continue;
            Node export = IR.export(exportSpecs).srcrefTree(moduleBody);
            moduleBody.addChildToBack(export);
            this.compiler.reportChangeToEnclosingScope(moduleBody);
        }
    }

    private static String getChunkName(JSChunk chunk) {
        return chunk.getName() + ".js";
    }

    private void addImportStatements() {
        for (Map.Entry<JSChunk, Map<JSChunk, Set<String>>> chunkImportsEntry : this.crossChunkImports.entrySet()) {
            ArrayList<Node> importStatements = new ArrayList<Node>();
            JSChunk importingChunk = chunkImportsEntry.getKey();
            CompilerInput firstInput = importingChunk.getFirst();
            Node moduleBody = firstInput.getAstRoot(this.compiler).getFirstChild();
            Preconditions.checkState((moduleBody != null && moduleBody.isModuleBody() ? 1 : 0) != 0);
            for (Map.Entry<JSChunk, Set<String>> importsByChunk : chunkImportsEntry.getValue().entrySet()) {
                Node importSpecs = new Node(Token.IMPORT_SPECS);
                for (String name : importsByChunk.getValue()) {
                    Node importSpec = new Node(Token.IMPORT_SPEC);
                    importSpec.addChildToFront(IR.name(name));
                    importSpec.addChildToFront(IR.name(name));
                    importSpec.putIntProp(Node.IS_SHORTHAND_PROPERTY, 1);
                    importSpecs.addChildToBack(importSpec);
                }
                Node importStatement = new Node(Token.IMPORT);
                JSChunk exportingChunk = importsByChunk.getKey();
                String importPath = ConvertChunksToESModules.getChunkName(exportingChunk);
                try {
                    importPath = ModuleLoader.relativePathFrom(ConvertChunksToESModules.getChunkName(importingChunk), ConvertChunksToESModules.getChunkName(exportingChunk));
                }
                catch (IllegalArgumentException e) {
                    this.compiler.report(JSError.make(moduleBody, UNABLE_TO_COMPUTE_RELATIVE_PATH, ConvertChunksToESModules.getChunkName(importingChunk), ConvertChunksToESModules.getChunkName(exportingChunk)));
                }
                importStatement.addChildToFront(IR.string(importPath));
                if (importSpecs.hasChildren()) {
                    importStatement.addChildToFront(importSpecs);
                } else {
                    importStatement.addChildToFront(IR.empty());
                }
                importStatement.addChildToFront(IR.empty());
                importStatement.srcrefTree(moduleBody);
                importStatements.add(0, importStatement);
            }
            for (Node importStatement : importStatements) {
                moduleBody.addChildToFront(importStatement);
            }
            this.compiler.reportChangeToEnclosingScope(moduleBody);
        }
    }

    public static @Nullable Node getDynamicImportCallbackModuleNamespace(AbstractCompiler compiler, Node call) {
        Preconditions.checkState((boolean)call.isCall());
        Node callbackFn = NodeUtil.getArgumentForCallOrNew(call, 0);
        if (callbackFn == null || !callbackFn.isFunction() || NodeUtil.getFunctionParameters(callbackFn).hasChildren()) {
            compiler.report(JSError.make(call, UNRECOGNIZED_DYNAMIC_IMPORT_CALLBACK, " Unable to find valid callback function."));
            return null;
        }
        Node callbackBody = NodeUtil.getFunctionBody(callbackFn);
        if (callbackBody.isName()) {
            return callbackBody;
        }
        if (callbackBody.isBlock() && callbackBody.hasOneChild() && callbackBody.getFirstChild().isReturn() && callbackBody.getFirstChild().hasOneChild() && callbackBody.getFirstFirstChild().isName()) {
            return callbackBody.getFirstFirstChild();
        }
        compiler.report(JSError.make(call, UNRECOGNIZED_DYNAMIC_IMPORT_CALLBACK, " Unable to find valid namespace reference."));
        return null;
    }

    private void rewriteDynamicImportCallbacks() {
        AstFactory astFactory = this.compiler.createAstFactory();
        for (Node dynamicImportCallback : this.dynamicImportCallbacks) {
            Preconditions.checkState((boolean)dynamicImportCallback.isCall());
            Node moduleNamespace = ConvertChunksToESModules.getDynamicImportCallbackModuleNamespace(this.compiler, dynamicImportCallback);
            if (moduleNamespace == null) continue;
            Node callbackFn = NodeUtil.getArgumentForCallOrNew(dynamicImportCallback, 0);
            Node callbackParamList = NodeUtil.getFunctionParameters(callbackFn);
            Node importNamespaceParam = astFactory.createNameWithUnknownType("$").srcref(moduleNamespace);
            callbackParamList.addChildToFront(importNamespaceParam);
            this.compiler.reportChangeToEnclosingScope(importNamespaceParam);
            Node namespaceGetprop = astFactory.createGetPropWithUnknownType(astFactory.createNameWithUnknownType("$").srcref(moduleNamespace), moduleNamespace.getString());
            moduleNamespace.replaceWith(namespaceGetprop);
            this.compiler.reportChangeToEnclosingScope(namespaceGetprop);
            Node innerCallback = NodeUtil.getArgumentForCallOrNew(dynamicImportCallback, 0).detach();
            dynamicImportCallback.replaceWith(innerCallback);
            this.compiler.reportChangeToEnclosingScope(innerCallback);
        }
    }

    public static boolean isDynamicImportCallback(Node call) {
        if (!call.isCall()) {
            return false;
        }
        return NodeUtil.isCallTo(call, DYNAMIC_IMPORT_CALLBACK_FN);
    }

    private boolean visitCallAndTraverse(NodeTraversal t, Node call) {
        Preconditions.checkState((boolean)call.isCall());
        if (!ConvertChunksToESModules.isDynamicImportCallback(call)) {
            return true;
        }
        Node moduleNamespace = ConvertChunksToESModules.getDynamicImportCallbackModuleNamespace(this.compiler, call);
        if (moduleNamespace == null) {
            return true;
        }
        boolean isValidModuleNamespace = this.visitName(t, moduleNamespace, ImportType.DYNAMIC);
        if (isValidModuleNamespace) {
            this.dynamicImportCallbacks.add(call);
        } else {
            this.compiler.report(JSError.make(call, UNRECOGNIZED_DYNAMIC_IMPORT_CALLBACK, " Unable to find valid namespace reference."));
        }
        return false;
    }

    public boolean visitName(NodeTraversal t, Node nameNode, ImportType importType) {
        JSChunk referencingChunk;
        Preconditions.checkState((boolean)nameNode.isName());
        String name = nameNode.getString();
        if ("".equals(name)) {
            return false;
        }
        Scope s = t.getScope();
        Var v = (Var)s.getVar(name);
        if (v == null || !v.isGlobal()) {
            return false;
        }
        CompilerInput input = v.getInput();
        if (input == null) {
            return false;
        }
        JSChunk definingChunk = input.getChunk();
        if (definingChunk != (referencingChunk = t.getChunk())) {
            if (NodeUtil.isLhsOfAssign(nameNode)) {
                t.report(nameNode, ASSIGNMENT_TO_IMPORT, nameNode.getString(), ConvertChunksToESModules.getChunkName(referencingChunk));
            }
            Set namesToExport = this.crossChunkExports.computeIfAbsent(definingChunk, k -> new LinkedHashSet());
            namesToExport.add(name);
            Map namesToImportByModule = this.crossChunkImports.computeIfAbsent(referencingChunk, k -> new LinkedHashMap());
            if (importType == ImportType.STATIC) {
                Set importsForModule = namesToImportByModule.computeIfAbsent(definingChunk, k -> new LinkedHashSet());
                importsForModule.add(name);
            }
        }
        return true;
    }

    private class FindCrossChunkReferences
    extends NodeTraversal.AbstractPreOrderCallback {
        private FindCrossChunkReferences() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                this.visitScript(t, n);
                return true;
            }
            if (n.isCall()) {
                return ConvertChunksToESModules.this.visitCallAndTraverse(t, n);
            }
            if (n.isName()) {
                ConvertChunksToESModules.this.visitName(t, n, ImportType.STATIC);
                return true;
            }
            return true;
        }

        public void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkState((boolean)script.isScript());
            JSChunk chunk = t.getChunk();
            ImmutableList<JSChunk> chunkDependencies = chunk.getDependencies();
            ConvertChunksToESModules.this.crossChunkExports.putIfAbsent(chunk, new LinkedHashSet());
            if (!chunkDependencies.isEmpty()) {
                Map namesToImportByModule = ConvertChunksToESModules.this.crossChunkImports.computeIfAbsent(chunk, k -> new LinkedHashMap());
                for (JSChunk dependency : chunkDependencies) {
                    namesToImportByModule.computeIfAbsent(dependency, k -> new LinkedHashSet());
                }
            }
        }
    }

    private static enum ImportType {
        STATIC,
        DYNAMIC;

    }
}

