/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class ConstParamCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final Node CONST_FUNCTION_NAME = IR.getprop(IR.name("goog"), "string", "Const", "from");
    private static final Node CONST_FUNCTION_NAME_COLLAPSED = IR.name("goog$string$Const$from");
    @VisibleForTesting
    static final DiagnosticType CONST_NOT_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_CONSTANT_NOT_STRING_LITERAL_ERROR", "Function argument is not a string literal or a constant assigned from a string literal or a concatenation of these.");
    private final AbstractCompiler compiler;

    public ConstParamCheck(AbstractCompiler compiler) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.isCall()) {
            Node name = node.getFirstChild();
            Node argument = name.getNext();
            if (argument == null) {
                return;
            }
            if (name.isName() && !name.matchesQualifiedName(CONST_FUNCTION_NAME_COLLAPSED)) {
                Scope scope = traversal.getScope();
                Var var = (Var)scope.getVar(name.getString());
                if (var == null) {
                    return;
                }
                name = var.getInitialValue();
                if (name == null) {
                    return;
                }
            }
            if ((name.matchesQualifiedName(CONST_FUNCTION_NAME) || name.matchesQualifiedName(CONST_FUNCTION_NAME_COLLAPSED)) && !this.isSafeValue(traversal.getScope(), argument)) {
                this.compiler.report(JSError.make(argument, CONST_NOT_STRING_LITERAL_ERROR, new String[0]));
            }
        }
    }

    private boolean isSafeValue(Scope scope, Node argument) {
        if (NodeUtil.isSomeCompileTimeConstStringValue(argument)) {
            return true;
        }
        if (argument.isTemplateLit()) {
            for (Node sub = argument.getFirstChild(); sub != null; sub = sub.getNext()) {
                if (sub.isTemplateLitString() || this.isSafeValue(scope, sub.getOnlyChild())) continue;
                return false;
            }
            return true;
        }
        if (argument.isAdd()) {
            Node left = argument.getFirstChild();
            Node right = argument.getLastChild();
            return this.isSafeValue(scope, left) && this.isSafeValue(scope, right);
        }
        if (argument.isName()) {
            String name = argument.getString();
            Var var = (Var)scope.getVar(name);
            if (var == null || !var.isDeclaredOrInferredConst()) {
                return false;
            }
            Node initialValue = var.getInitialValue();
            if (initialValue == null) {
                return false;
            }
            return this.isSafeValue((Scope)var.getScope(), initialValue);
        }
        return false;
    }
}

