/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.jstype.FunctionType;

@Immutable
public final class ChromeCodingConvention
extends CodingConventions.Proxy {
    private final ImmutableSet<String> indirectlyDeclaredProperties;
    private static final QualifiedName CR_ADD_SINGLETON_GETTER = QualifiedName.of("cr.addSingletonGetter");

    public ChromeCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ChromeCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        this.indirectlyDeclaredProperties = new ImmutableSet.Builder().add((Object[])new String[]{"instance_", "getInstance"}).addAll(wrapped.getIndirectlyDeclaredProperties()).build();
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (!CR_ADD_SINGLETON_GETTER.matches(callArg) || !callNode.hasTwoChildren()) {
            return super.getSingletonGetterClassName(callNode);
        }
        return callArg.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(NominalTypeBuilder classType, FunctionType getterType) {
        Node defSite = classType.constructor().getSource();
        classType.declareConstructorProperty("getInstance", getterType, defSite);
        classType.declareConstructorProperty("instance_", classType.instance(), defSite);
    }

    public ImmutableCollection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }
}

