/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ConformanceRules;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="com.google.protobuf")
public final class CheckConformance
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType CONFORMANCE_ERROR = DiagnosticType.error("JSC_CONFORMANCE_ERROR", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_VIOLATION", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_POSSIBLE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_POSSIBLE_VIOLATION", "Possible violation: {0}{1}{2}");
    static final DiagnosticType INVALID_REQUIREMENT_SPEC = DiagnosticType.error("JSC_INVALID_REQUIREMENT_SPEC", "Invalid requirement. Reason: {0}\nRequirement spec:\n{1}");
    private final AbstractCompiler compiler;
    private final ImmutableList<Category> categories;
    private static final ImmutableSet<String> EXTENDABLE_FIELDS = ImmutableSet.of((Object)"config_file", (Object)"extends", (Object)"only_apply_to", (Object)"only_apply_to_regexp", (Object)"whitelist", (Object)"whitelist_regexp", (Object[])new String[]{"allowlist", "allowlist_regexp", "value"});

    CheckConformance(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        this.compiler = compiler;
        this.categories = CheckConformance.initRules(compiler, configs);
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.categories.isEmpty()) {
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || this.isScriptOfInterest(t.getInput().getSourceFile()) && !t.getSourceName().endsWith("tsmes.closure.js");
    }

    private boolean isScriptOfInterest(SourceFile sf) {
        return !sf.isWeak() && !sf.isExtern();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        for (int c = this.categories.size() - 1; c >= 0; --c) {
            Category category = (Category)this.categories.get(c);
            if (!category.precondition.shouldCheck(n)) continue;
            for (int r = category.rules.size() - 1; r >= 0; --r) {
                ((Rule)category.rules.get(r)).check(t, n);
            }
        }
    }

    private static ImmutableList<Category> initRules(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        HashMultimap builder = HashMultimap.create();
        List<Requirement> requirements = CheckConformance.mergeRequirements(compiler, configs);
        for (Requirement requirement : requirements) {
            Rule rule = CheckConformance.initRule(compiler, requirement);
            if (rule == null) continue;
            builder.put((Object)rule.getPrecondition(), (Object)rule);
        }
        return (ImmutableList)builder.asMap().entrySet().stream().map(e -> new Category((Precondition)e.getKey(), (ImmutableList<Rule>)ImmutableList.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableList.toImmutableList());
    }

    static List<Requirement> mergeRequirements(AbstractCompiler compiler, List<ConformanceConfig> configs) {
        ArrayList<Requirement.Builder> builders = new ArrayList<Requirement.Builder>();
        LinkedHashMap<String, Requirement.Builder> extendable = new LinkedHashMap<String, Requirement.Builder>();
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                Requirement.Builder builder = requirement.toBuilder();
                if (requirement.hasRuleId()) {
                    if (requirement.getRuleId().isEmpty()) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "empty rule_id");
                        continue;
                    }
                    if (extendable.containsKey(requirement.getRuleId())) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "two requirements with the same rule_id: " + requirement.getRuleId());
                        continue;
                    }
                    extendable.put(requirement.getRuleId(), builder);
                }
                if (requirement.hasExtends()) continue;
                builders.add(builder);
            }
        }
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                if (!requirement.hasExtends()) continue;
                Requirement.Builder existing = (Requirement.Builder)extendable.get(requirement.getExtends());
                if (existing == null) {
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "no requirement with rule_id: " + requirement.getExtends());
                    continue;
                }
                for (Descriptors.FieldDescriptor field : requirement.getAllFields().keySet()) {
                    if (EXTENDABLE_FIELDS.contains((Object)field.getName())) continue;
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "extending rules allow only " + EXTENDABLE_FIELDS);
                }
                if (requirement.getValueCount() > 0 && !existing.getAllowExtendingValue()) {
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "extending rule may not specify 'value' if base rule does not allow it");
                }
                existing.addAllWhitelist((Iterable<String>)requirement.getWhitelistList()).addAllWhitelistRegexp((Iterable<String>)requirement.getWhitelistRegexpList()).addAllAllowlist((Iterable<String>)requirement.getAllowlistList()).addAllAllowlistRegexp((Iterable<String>)requirement.getAllowlistRegexpList()).addAllOnlyApplyTo((Iterable<String>)requirement.getOnlyApplyToList()).addAllOnlyApplyToRegexp((Iterable<String>)requirement.getOnlyApplyToRegexpList()).addAllWhitelistEntry(requirement.getWhitelistEntryList()).addAllAllowlistEntry(requirement.getAllowlistEntryList()).addAllValue((Iterable<String>)requirement.getValueList()).addAllConfigFile((Iterable<String>)requirement.getConfigFileList());
            }
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(builders.size());
        for (Requirement.Builder builder : builders) {
            CheckConformance.removeDuplicates(builder);
            requirements.add(builder.build());
        }
        return requirements;
    }

    private static void removeDuplicates(Requirement.Builder requirement) {
        ImmutableSet list1 = ImmutableSet.copyOf((Collection)requirement.getWhitelistList());
        requirement.clearWhitelist().addAllWhitelist((Iterable<String>)list1);
        ImmutableSet allowlist = ImmutableSet.copyOf((Collection)requirement.getAllowlistList());
        requirement.clearAllowlist().addAllAllowlist((Iterable<String>)allowlist);
        ImmutableSet list2 = ImmutableSet.copyOf((Collection)requirement.getWhitelistRegexpList());
        requirement.clearWhitelistRegexp().addAllWhitelistRegexp((Iterable<String>)list2);
        ImmutableSet allowlistRegexp = ImmutableSet.copyOf((Collection)requirement.getAllowlistRegexpList());
        requirement.clearAllowlistRegexp().addAllAllowlistRegexp((Iterable<String>)allowlistRegexp);
        ImmutableSet list3 = ImmutableSet.copyOf((Collection)requirement.getOnlyApplyToList());
        requirement.clearOnlyApplyTo().addAllOnlyApplyTo((Iterable<String>)list3);
        ImmutableSet list4 = ImmutableSet.copyOf((Collection)requirement.getOnlyApplyToRegexpList());
        requirement.clearOnlyApplyToRegexp().addAllOnlyApplyToRegexp((Iterable<String>)list4);
    }

    private static @Nullable Rule initRule(AbstractCompiler compiler, Requirement requirement) {
        try {
            switch (requirement.getType()) {
                case CUSTOM: {
                    return new ConformanceRules.CustomRuleProxy(compiler, requirement);
                }
                case NO_OP: {
                    return new ConformanceRules.NoOp(compiler, requirement);
                }
                case BANNED_CODE_PATTERN: {
                    return new ConformanceRules.BannedCodePattern(compiler, requirement);
                }
                case BANNED_DEPENDENCY: {
                    return new ConformanceRules.BannedDependency(compiler, requirement);
                }
                case BANNED_DEPENDENCY_REGEX: {
                    return new ConformanceRules.BannedDependencyRegex(compiler, requirement);
                }
                case BANNED_ENHANCE: {
                    return new ConformanceRules.BannedEnhance(compiler, requirement);
                }
                case BANNED_MODS_REGEX: {
                    return new ConformanceRules.BannedModsRegex(compiler, requirement);
                }
                case BANNED_NAME: 
                case BANNED_NAME_CALL: {
                    return new ConformanceRules.BannedName(compiler, requirement);
                }
                case BANNED_PROPERTY: 
                case BANNED_PROPERTY_READ: 
                case BANNED_PROPERTY_WRITE: 
                case BANNED_PROPERTY_NON_CONSTANT_WRITE: 
                case BANNED_PROPERTY_CALL: {
                    return new ConformanceRules.BannedProperty(compiler, requirement);
                }
                case RESTRICTED_NAME_CALL: {
                    return new ConformanceRules.RestrictedNameCall(compiler, requirement);
                }
                case RESTRICTED_METHOD_CALL: {
                    return new ConformanceRules.RestrictedMethodCall(compiler, requirement);
                }
                case RESTRICTED_PROPERTY_WRITE: {
                    return new ConformanceRules.RestrictedPropertyWrite(compiler, requirement);
                }
                case BANNED_STRING_REGEX: {
                    return new ConformanceRules.BannedStringRegex(compiler, requirement);
                }
            }
            throw new AssertionError();
        }
        catch (InvalidRequirementSpec e) {
            CheckConformance.reportInvalidRequirement(compiler, requirement, e.getMessage());
            return null;
        }
    }

    private static void reportInvalidRequirement(AbstractCompiler compiler, Requirement requirement, String reason) {
        compiler.report(JSError.make(INVALID_REQUIREMENT_SPEC, reason, TextFormat.printer().printToString((MessageOrBuilder)requirement)));
    }

    private static final class Category {
        final Precondition precondition;
        final ImmutableList<Rule> rules;

        Category(Precondition precondition, ImmutableList<Rule> rules) {
            this.precondition = precondition;
            this.rules = rules;
        }
    }

    public static interface Precondition {
        public static final Precondition CHECK_ALL = new Precondition(){

            @Override
            public boolean shouldCheck(Node n) {
                return true;
            }
        };

        public boolean shouldCheck(Node var1);
    }

    public static interface Rule {
        default public @Nullable Precondition getPrecondition() {
            return Precondition.CHECK_ALL;
        }

        public void check(NodeTraversal var1, Node var2);
    }

    public static class InvalidRequirementSpec
    extends Exception {
        InvalidRequirementSpec(String message) {
            super(message);
        }

        InvalidRequirementSpec(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

