/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ReplaceMessagesConstants;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

class AliasStrings
implements CompilerPass,
NodeTraversal.Callback {
    private static final Logger logger = Logger.getLogger(AliasStrings.class.getName());
    private static final String STRING_ALIAS_PREFIX = "$$S_";
    private final AbstractCompiler compiler;
    private final JSChunkGraph chunkGraph;
    private final boolean outputStringUsage;
    private final SortedMap<String, StringInfo> stringInfoMap = new TreeMap<String, StringInfo>();
    private final Set<String> usedHashedAliases = new LinkedHashSet<String>();
    private final CompilerOptions.AliasStringsMode aliasStringsMode;
    private static final int ALIAS_LARGE_STRINGS_LENGTH = 100;
    private final Map<JSChunk, Node> chunkVarParentMap = new HashMap<JSChunk, Node>();
    int unitTestHashReductionMask = -1;

    AliasStrings(AbstractCompiler compiler, JSChunkGraph chunkGraph, boolean outputStringUsage, CompilerOptions.AliasStringsMode aliasStringsMode) {
        this.compiler = compiler;
        this.chunkGraph = chunkGraph;
        this.outputStringUsage = outputStringUsage;
        this.aliasStringsMode = aliasStringsMode;
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Aliasing common strings");
        NodeTraversal.traverse(this.compiler, root, this);
        this.replaceStringsWithAliases();
        this.addAliasDeclarationNodes();
        if (this.outputStringUsage) {
            this.outputStringUsage();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        switch (n.getToken()) {
            case TEMPLATELIT: 
            case TAGGED_TEMPLATELIT: 
            case TEMPLATELIT_SUB: {
                return false;
            }
            case CALL: {
                return !ReplaceMessagesConstants.isProtectedMessage(n);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isStringLit() && !parent.isRegExp()) {
            String str = n.getString();
            if ("undefined".equals(str)) {
                return;
            }
            if (this.aliasStringsMode == CompilerOptions.AliasStringsMode.LARGE && str.length() <= 100) {
                return;
            }
            Node occurrence = n;
            StringInfo info = this.getOrCreateStringInfo(str);
            info.occurrences.add(occurrence);
            JSChunk chunk = t.getChunk();
            if (info.occurrences.size() != 1) {
                if (chunk != null && info.chunkToContainDecl != null && chunk != info.chunkToContainDecl) {
                    chunk = this.chunkGraph.getDeepestCommonDependencyInclusive(chunk, info.chunkToContainDecl);
                } else {
                    return;
                }
            }
            Node varParent = this.chunkVarParentMap.computeIfAbsent(chunk, this.compiler::getNodeForCodeInsertion);
            info.chunkToContainDecl = chunk;
            info.parentForNewVarDecl = varParent;
            info.siblingToInsertVarDeclBefore = varParent.getFirstChild();
        }
    }

    private StringInfo getOrCreateStringInfo(String string) {
        StringInfo info = (StringInfo)this.stringInfoMap.get(string);
        if (info == null) {
            info = new StringInfo(this.stringInfoMap.size());
            this.stringInfoMap.put(string, info);
        }
        return info;
    }

    private void replaceStringsWithAliases() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo info;
            String literal = entry.getKey();
            if (!AliasStrings.shouldReplaceWithAlias(literal, info = entry.getValue())) continue;
            for (Node node : info.occurrences) {
                this.replaceStringWithAliasName(node, info.getVariableName(literal), info);
            }
        }
    }

    private void addAliasDeclarationNodes() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo info = entry.getValue();
            if (!info.isAliased) continue;
            String alias = info.getVariableName(entry.getKey());
            Node var = IR.var(IR.name(alias), IR.string(entry.getKey()));
            Node firstUse = info.occurrences.get(0);
            var.srcrefTree(firstUse);
            if (info.siblingToInsertVarDeclBefore == null) {
                info.parentForNewVarDecl.addChildToFront(var);
            } else {
                var.insertBefore(info.siblingToInsertVarDeclBefore);
            }
            this.compiler.reportChangeToEnclosingScope(var);
        }
    }

    private static boolean shouldReplaceWithAlias(String str, StringInfo info) {
        int sizeOfStrings;
        int count;
        int sizeOfVariable = 3;
        int sizeOfLiteral = 2 + str.length();
        int sizeOfAliases = 6 + sizeOfVariable + sizeOfLiteral + (count = info.occurrences.size()) * sizeOfVariable;
        return sizeOfAliases < (sizeOfStrings = count * sizeOfLiteral);
    }

    private void replaceStringWithAliasName(Node n, String name, StringInfo info) {
        Node nameNode = IR.name(name);
        n.replaceWith(nameNode);
        info.isAliased = true;
        this.compiler.reportChangeToEnclosingScope(nameNode);
    }

    private void outputStringUsage() {
        StringBuilder sb = new StringBuilder("Strings used more than once:\n");
        for (Map.Entry<String, StringInfo> stringInfoEntry : this.stringInfoMap.entrySet()) {
            StringInfo info = stringInfoEntry.getValue();
            int count = info.occurrences.size();
            if (count <= 1) continue;
            sb.append(count);
            sb.append(": ");
            sb.append(stringInfoEntry.getKey());
            sb.append('\n');
        }
        logger.fine(sb.toString());
    }

    private final class StringInfo {
        final int id;
        boolean isAliased;
        final ArrayList<Node> occurrences = new ArrayList();
        JSChunk chunkToContainDecl;
        Node parentForNewVarDecl;
        Node siblingToInsertVarDeclBefore;
        String aliasName;

        StringInfo(int id) {
            this.id = id;
            this.isAliased = false;
        }

        String getVariableName(String stringLiteral) {
            if (this.aliasName == null) {
                this.aliasName = this.encodeStringAsIdentifier(AliasStrings.STRING_ALIAS_PREFIX, stringLiteral);
            }
            return this.aliasName;
        }

        String encodeStringAsIdentifier(String prefix, String s) {
            int maxLimit = 20;
            int length = s.length();
            int limit = Math.min(length, 20);
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            boolean protectHex = false;
            for (int i = 0; i < limit; ++i) {
                char ch = s.charAt(i);
                if (protectHex) {
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') {
                        sb.append('_');
                    }
                    protectHex = false;
                }
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                    sb.append(ch);
                    continue;
                }
                sb.append('$');
                sb.append(Integer.toHexString(ch));
                protectHex = true;
            }
            if (length == limit) {
                return sb.toString();
            }
            int hash = s.hashCode() & AliasStrings.this.unitTestHashReductionMask;
            sb.append('_');
            sb.append(Integer.toHexString(hash));
            Object encoded = sb.toString();
            if (!AliasStrings.this.usedHashedAliases.add((String)encoded)) {
                encoded = (String)encoded + "_" + this.id;
            }
            return encoded;
        }
    }
}

