/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.refactoring.ErrorToFixMapper;
import com.google.javascript.refactoring.SuggestedFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FixingErrorManager
extends BasicErrorManager {
    private AbstractCompiler compiler;
    private final ListMultimap<JSError, SuggestedFix> fixes = ArrayListMultimap.create();
    private final ImmutableSet<DiagnosticType> unfixableErrors;

    public FixingErrorManager() {
        this((ImmutableSet<DiagnosticType>)ImmutableSet.of());
    }

    public FixingErrorManager(ImmutableSet<DiagnosticType> unfixableErrors) {
        this.unfixableErrors = unfixableErrors;
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void report(CheckLevel level, JSError error) {
        super.report(level, error);
        if (!this.unfixableErrors.contains((Object)error.getType())) {
            this.fixes.putAll((Object)error, ErrorToFixMapper.getFixesForJsError(error, this.compiler));
        }
    }

    private boolean containsFixableShorthandModuleWarning() {
        for (JSError error : this.fixes.keySet()) {
            if (!error.getType().equals(ClosureCheckModule.JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME) && !error.getType().equals(ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME)) continue;
            return true;
        }
        return false;
    }

    public List<SuggestedFix> getFixesForJsError(JSError error) {
        return this.fixes.get((Object)error);
    }

    public Collection<SuggestedFix> getAllFixes() {
        boolean containsFixableShorthandModuleWarning = this.containsFixableShorthandModuleWarning();
        ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>();
        for (JSError error : this.getErrors()) {
            if (containsFixableShorthandModuleWarning && (error.getType().equals(CheckMissingAndExtraRequires.EXTRA_REQUIRE_WARNING) || error.getType().equals(CheckMissingAndExtraRequires.MISSING_REQUIRE_STRICT_WARNING) || error.getType().equals(CheckMissingAndExtraRequires.MISSING_REQUIRE_WARNING))) continue;
            fixes.addAll(this.getFixesForJsError(error));
        }
        for (JSError warning : this.getWarnings()) {
            if (warning.getType().equals(CheckMissingAndExtraRequires.EXTRA_REQUIRE_WARNING) && containsFixableShorthandModuleWarning) continue;
            fixes.addAll(this.getFixesForJsError(warning));
        }
        return fixes;
    }

    @Override
    public void printSummary() {
    }

    @Override
    public void println(CheckLevel level, JSError error) {
    }
}

