/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.javascript.jscomp.AutoValue_TypeMismatch_LazyError;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class TypeMismatch
implements Serializable {
    final JSType typeA;
    final JSType typeB;
    final Supplier<JSError> error;

    TypeMismatch(JSType a, JSType b, Supplier<JSError> error) {
        this.typeA = a;
        this.typeB = b;
        this.error = error;
    }

    static void registerIfMismatch(List<TypeMismatch> mismatches, List<TypeMismatch> implicitInterfaceUses, JSType found, JSType required, JSError error) {
        if (found != null && required != null && !found.isSubtypeWithoutStructuralTyping(required)) {
            TypeMismatch.registerMismatch(mismatches, implicitInterfaceUses, found, required, error);
        }
    }

    private static boolean bothAreNotTypeVariables(JSType found, JSType required) {
        return !found.isTypeVariable() && !required.isTypeVariable();
    }

    static void registerMismatch(List<TypeMismatch> mismatches, List<TypeMismatch> implicitInterfaceUses, JSType found, JSType required, JSError error) {
        if ((found = TypeMismatch.removeNullUndefinedAndTemplates(found)).isSubtypeOf(required = TypeMismatch.removeNullUndefinedAndTemplates(required)) || required.isSubtypeOf(found)) {
            boolean strictMismatch;
            boolean bl = strictMismatch = !found.isSubtypeWithoutStructuralTyping(required) && !required.isSubtypeWithoutStructuralTyping(found);
            if (strictMismatch && TypeMismatch.bothAreNotTypeVariables(found, required)) {
                implicitInterfaceUses.add(new TypeMismatch(found, required, (Supplier<JSError>)Suppliers.ofInstance((Object)error)));
            }
            return;
        }
        if (TypeMismatch.bothAreNotTypeVariables(found, required)) {
            mismatches.add(new TypeMismatch(found, required, (Supplier<JSError>)Suppliers.ofInstance((Object)error)));
        }
        if (found.isFunctionType() && required.isFunctionType()) {
            FunctionType fnTypeA = found.toMaybeFunctionType();
            FunctionType fnTypeB = required.toMaybeFunctionType();
            Iterator<JSType> paramItA = fnTypeA.getParameterTypes().iterator();
            Iterator<JSType> paramItB = fnTypeB.getParameterTypes().iterator();
            while (paramItA.hasNext() && paramItB.hasNext()) {
                TypeMismatch.registerIfMismatch(mismatches, implicitInterfaceUses, paramItA.next(), paramItB.next(), error);
            }
            TypeMismatch.registerIfMismatch(mismatches, implicitInterfaceUses, fnTypeA.getReturnType(), fnTypeB.getReturnType(), error);
        }
    }

    static void recordImplicitUseOfNativeObject(List<TypeMismatch> mismatches, Node node, JSType sourceType, JSType targetType) {
        sourceType = sourceType.restrictByNotNullOrUndefined();
        targetType = targetType.restrictByNotNullOrUndefined();
        if (TypeMismatch.isInstanceOfObject(sourceType) && !TypeMismatch.isInstanceOfObject(targetType) && !targetType.isUnknownType() && TypeMismatch.bothAreNotTypeVariables(sourceType, targetType)) {
            LazyError err = LazyError.of("Implicit use of Object type: %s as type: %s", node, sourceType, targetType);
            mismatches.add(new TypeMismatch(sourceType, targetType, err));
        }
    }

    static void recordImplicitInterfaceUses(List<TypeMismatch> implicitInterfaceUses, Node node, JSType sourceType, JSType targetType) {
        boolean mismatch;
        sourceType = TypeMismatch.removeNullUndefinedAndTemplates(sourceType);
        if ((targetType = TypeMismatch.removeNullUndefinedAndTemplates(targetType)).isUnknownType()) {
            return;
        }
        boolean strictMismatch = !sourceType.isSubtypeWithoutStructuralTyping(targetType) && !targetType.isSubtypeWithoutStructuralTyping(sourceType);
        boolean bl = mismatch = !sourceType.isSubtypeOf(targetType) && !targetType.isSubtypeOf(sourceType);
        if ((strictMismatch || mismatch) && TypeMismatch.bothAreNotTypeVariables(sourceType, targetType)) {
            LazyError err = LazyError.of("Implicit use of type %s as %s", node, sourceType, targetType);
            implicitInterfaceUses.add(new TypeMismatch(sourceType, targetType, err));
        }
    }

    private static boolean isInstanceOfObject(JSType type) {
        ObjectType obj = type.toMaybeObjectType();
        if (obj != null && obj.isNativeObjectType() && "Object".equals(obj.getReferenceName())) {
            return true;
        }
        return type.isRecordType() || type.isLiteralObject();
    }

    private static JSType removeNullUndefinedAndTemplates(JSType t) {
        JSType result = t.restrictByNotNullOrUndefined();
        ObjectType obj = result.toMaybeObjectType();
        if (obj != null && obj.isGenericObjectType()) {
            return obj.instantiateGenericsWithUnknown();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof TypeMismatch) {
            TypeMismatch that = (TypeMismatch)object;
            return that.typeA.equals(this.typeA) && that.typeB.equals(this.typeB) || that.typeB.equals(this.typeA) && that.typeA.equals(this.typeB);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.typeA, this.typeB);
    }

    public String toString() {
        return "(" + this.typeA + ", " + this.typeB + ")";
    }

    static abstract class LazyError
    implements Supplier<JSError>,
    Serializable {
        LazyError() {
        }

        abstract String message();

        abstract Node node();

        abstract JSType sourceType();

        abstract JSType targetType();

        private static LazyError of(String message, Node node, JSType sourceType, JSType targetType) {
            return new AutoValue_TypeMismatch_LazyError(message, node, sourceType, targetType);
        }

        public JSError get() {
            List parts = Splitter.on((String)"%s").splitToList((CharSequence)this.message());
            Preconditions.checkState((parts.size() == 3 ? 1 : 0) != 0);
            return JSError.make(this.node(), TypeValidator.TYPE_MISMATCH_WARNING, (String)parts.get(0) + this.sourceType() + (String)parts.get(1) + this.targetType() + (String)parts.get(2));
        }
    }
}

