/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class RewriteGoogJsImports
implements HotSwapCompilerPass {
    static final DiagnosticType GOOG_JS_IMPORT_MUST_BE_GOOG_STAR = DiagnosticType.error("JSC_GOOG_JS_IMPORT_MUST_BE_GOOG_STAR", "Closure''s goog.js file must be imported as `import * as goog`.");
    static final DiagnosticType GOOG_JS_REEXPORTED = DiagnosticType.error("JSC_GOOG_JS_REEXPORTED", "Do not re-export from goog.js.");
    static final DiagnosticType CANNOT_NAME_FILE_GOOG = DiagnosticType.error("JSC_CANNOT_NAME_FILE_GOOG", "Do not name files goog.js, it is reserved for Closure Library.");
    static final DiagnosticType CANNOT_HAVE_MODULE_VAR_NAMED_GOOG = DiagnosticType.error("JSC_CANNOT_HAVE_MODULE_VAR_NAMED_GOOG", "Module scoped variables named ''goog'' must come from importing Closure Library''s goog.js file..");
    private static final ImmutableList<String> EXPECTED_BASE_PROVIDES = ImmutableList.of((Object)"goog");
    private final Mode mode;
    private final AbstractCompiler compiler;
    private FindExports exportsFinder;

    public RewriteGoogJsImports(AbstractCompiler compiler, Mode mode) {
        this.compiler = compiler;
        this.mode = mode;
    }

    @Nullable
    private Node findGoogImportNode(Node scriptRoot) {
        boolean valid = true;
        Node googImportNode = null;
        for (Node child : scriptRoot.getFirstChild().children()) {
            if (!child.isImport() || !child.getLastChild().getString().endsWith("/goog.js")) continue;
            if (child.getFirstChild().isEmpty() && child.getSecondChild().isImportStar() && child.getSecondChild().getString().equals("goog")) {
                googImportNode = child;
                continue;
            }
            valid = false;
            this.compiler.report(JSError.make(scriptRoot.getSourceFileName(), child.getLineno(), child.getCharno(), GOOG_JS_IMPORT_MUST_BE_GOOG_STAR, new String[0]));
        }
        if (!valid) {
            return null;
        }
        if (googImportNode != null) {
            return googImportNode;
        }
        AbstractScope moduleScope = new Es6SyntacticScopeCreator(this.compiler).createScope(scriptRoot.getFirstChild(), (AbstractScope)Scope.createGlobalScope(scriptRoot));
        Var googVar = (Var)moduleScope.getVar("goog");
        if (googVar != null && googVar.getNameNode() != null) {
            this.compiler.report(JSError.make(scriptRoot.getSourceFileName(), googVar.getNameNode().getLineno(), googVar.getNameNode().getCharno(), CANNOT_HAVE_MODULE_VAR_NAMED_GOOG, new String[0]));
        }
        return null;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        if (Es6RewriteModules.isEs6ModuleRoot(scriptRoot)) {
            Node googImportNode = this.findGoogImportNode(scriptRoot);
            NodeTraversal.traverse(this.compiler, scriptRoot, new FindReexports(googImportNode != null));
            if (this.exportsFinder != null && googImportNode != null && this.mode == Mode.LINT_AND_REWRITE) {
                new ReferenceReplacer(scriptRoot, googImportNode);
            }
        }
    }

    @Nullable
    private Node findGoogJsScriptNode(Node root) {
        ModuleLoader.ModulePath expectedGoogPath = null;
        for (Node script : root.children()) {
            ImmutableList<String> provides = this.compiler.getInput(script.getInputId()).getProvides();
            if (!EXPECTED_BASE_PROVIDES.equals(provides)) continue;
            expectedGoogPath = this.compiler.getInput(script.getInputId()).getPath().resolveModuleAsPath("./goog.js");
            break;
        }
        if (expectedGoogPath != null) {
            Node googScriptNode = null;
            for (Node script : root.children()) {
                if (this.compiler.getInput(script.getInputId()).getPath().equalsIgnoreLeadingSlash(expectedGoogPath)) {
                    googScriptNode = script;
                    continue;
                }
                if (!script.getSourceFileName().endsWith("/goog.js")) continue;
                this.compiler.report(JSError.make(script.getSourceFileName(), -1, -1, CheckLevel.ERROR, CANNOT_NAME_FILE_GOOG, new String[0]));
            }
            return googScriptNode;
        }
        return null;
    }

    @Override
    public void process(Node externs, Node root) {
        this.exportsFinder = null;
        Node googJsScriptNode = this.findGoogJsScriptNode(root);
        if (this.mode == Mode.LINT_AND_REWRITE) {
            if (googJsScriptNode != null) {
                this.exportsFinder = new FindExports(googJsScriptNode);
            }
        } else {
            Preconditions.checkState((this.mode == Mode.LINT_ONLY ? 1 : 0) != 0);
        }
        for (Node script : root.children()) {
            this.hotSwapScript(script, null);
        }
    }

    private static class FindReexports
    extends NodeTraversal.AbstractPreOrderCallback {
        private final boolean hasGoogImport;

        public FindReexports(boolean hasGoogImport) {
            this.hasGoogImport = hasGoogImport;
        }

        private void checkIfForwardingExport(NodeTraversal t, Node export) {
            if (export.hasTwoChildren() && export.getLastChild().getString().endsWith("/goog.js")) {
                t.report(export, GOOG_JS_REEXPORTED, new String[0]);
            }
        }

        private void checkIfNameFowardedExport(NodeTraversal t, Node nameNode, Node parent) {
            if (this.hasGoogImport && nameNode.getString().equals("goog") && (parent.isExportSpec() && parent.getFirstChild() == nameNode || parent.isExport())) {
                t.report(nameNode, GOOG_JS_REEXPORTED, new String[0]);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: 
                case MODULE_BODY: 
                case ROOT: 
                case EXPORT_SPECS: 
                case EXPORT_SPEC: {
                    return true;
                }
                case EXPORT: {
                    this.checkIfForwardingExport(t, n);
                    return true;
                }
                case NAME: {
                    this.checkIfNameFowardedExport(t, n, parent);
                    return false;
                }
            }
            return false;
        }
    }

    private class ReferenceReplacer
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean hasBadExport;
        private final Node googImportNode;

        public ReferenceReplacer(Node script, Node googImportNode) {
            this.googImportNode = googImportNode;
            NodeTraversal.traverse(RewriteGoogJsImports.this.compiler, script, this);
            if (googImportNode.getSecondChild().isImportStar()) {
                if (this.hasBadExport) {
                    googImportNode.getSecondChild().setOriginalName("goog");
                    googImportNode.getSecondChild().setString("$goog");
                } else {
                    googImportNode.getSecondChild().replaceWith(IR.empty());
                }
                RewriteGoogJsImports.this.compiler.reportChangeToEnclosingScope(googImportNode);
            }
        }

        private void maybeRewriteBadGoogJsImportRef(NodeTraversal t, Node nameNode, Node parent) {
            if (!parent.isGetProp() || !nameNode.getString().equals("goog")) {
                return;
            }
            Var var = (Var)t.getScope().getVar(nameNode.getString());
            if (var == null || var.getNameNode() == null || var.getNameNode().getParent() != this.googImportNode) {
                return;
            }
            if (((RewriteGoogJsImports)RewriteGoogJsImports.this).exportsFinder.exportedNames.contains(parent.getSecondChild().getString())) {
                return;
            }
            this.hasBadExport = true;
            nameNode.setOriginalName("goog");
            nameNode.setString("$goog");
            t.reportCodeChange();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case NAME: {
                    this.maybeRewriteBadGoogJsImportRef(t, n, parent);
                    break;
                }
            }
        }
    }

    private class FindExports
    extends NodeTraversal.AbstractPreOrderCallback {
        final Set<String> exportedNames;

        public FindExports(Node googRoot) {
            Preconditions.checkState((boolean)Es6RewriteModules.isEs6ModuleRoot(googRoot));
            this.exportedNames = new HashSet<String>();
            NodeTraversal.traverse(RewriteGoogJsImports.this.compiler, googRoot, this);
        }

        private void visitExport(Node export) {
            if (export.getBooleanProp((byte)63)) {
                throw new IllegalStateException("goog.js should never have a default export.");
            }
            if (export.hasTwoChildren()) {
                throw new IllegalStateException("goog.js should never export from anything.");
            }
            if (export.getFirstChild().isExportSpecs()) {
                for (Node spec = export.getFirstFirstChild(); spec != null; spec = spec.getNext()) {
                    this.exportedNames.add(spec.getSecondChild().getString());
                }
            } else {
                for (Node maybeName = export.getFirstFirstChild(); maybeName != null; maybeName = maybeName.getNext()) {
                    if (!maybeName.isName()) continue;
                    this.exportedNames.add(maybeName.getString());
                }
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getToken()) {
                case EXPORT: {
                    this.visitExport(n);
                    return false;
                }
                case IMPORT: {
                    throw new IllegalStateException("goog.js should never import anything.");
                }
                case SCRIPT: 
                case MODULE_BODY: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Mode {
        LINT_ONLY,
        LINT_AND_REWRITE;

    }
}

