/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public final class RewriteAsyncFunctions
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String ASYNC_ARGUMENTS = "$jscomp$async$arguments";
    private static final String ASYNC_THIS = "$jscomp$async$this";
    private static final String ASYNC_SUPER_PROP_GETTER_PREFIX = "$jscomp$async$super$get$";
    private final Deque<LexicalContext> contextStack;
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_FUNCTIONS);

    public RewriteAsyncFunctions(AbstractCompiler compiler) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.contextStack = new ArrayDeque<LexicalContext>();
        this.contextStack.addFirst(new LexicalContext());
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.addFirst(new LexicalContext(this.contextStack.getFirst(), n));
            if (n.isAsyncFunction()) {
                this.compiler.ensureLibraryInjected("es6/execute_async_generator", false);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext context = this.contextStack.getFirst();
        switch (n.getToken()) {
            case FUNCTION: {
                Preconditions.checkState((context.function == n ? 1 : 0) != 0, (String)"unexpected function context:\nexpected: %s\nactual: %s", (Object)n, (Object)context.function);
                Preconditions.checkState((this.contextStack.removeFirst() == context ? 1 : 0) != 0);
                if (!context.isAsyncContext()) break;
                this.convertAsyncFunction(t, context);
                break;
            }
            case NAME: {
                if (!context.mustReplaceThisAndArguments() || !n.matchesQualifiedName("arguments")) break;
                n.setString(ASYNC_ARGUMENTS);
                context.recordAsyncArgumentsReplacementWasDone();
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case THIS: {
                if (!context.mustReplaceThisAndArguments()) break;
                parent.replaceChild(n, IR.name(ASYNC_THIS));
                context.recordAsyncThisReplacementWasDone();
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case SUPER: {
                if (!context.mustReplaceThisAndArguments()) break;
                if (!parent.isGetProp()) {
                    this.compiler.report(JSError.make(parent, Es6ToEs3Util.CANNOT_CONVERT_YET, "super expression"));
                }
                Node medhodName = n.getNext();
                String superPropertyName = ASYNC_SUPER_PROP_GETTER_PREFIX + medhodName.getString();
                Node getPropReplacement = NodeUtil.newCallNode(IR.name(superPropertyName), new Node[0]);
                Node grandparent = parent.getParent();
                if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
                    getPropReplacement = IR.getprop(getPropReplacement, IR.string("call"));
                    grandparent.addChildAfter(IR.name(ASYNC_THIS).useSourceInfoFrom(parent), parent);
                    context.recordAsyncThisReplacementWasDone();
                }
                getPropReplacement.useSourceInfoFromForTree(parent);
                grandparent.replaceChild(parent, getPropReplacement);
                context.recordAsyncSuperReplacementWasDone(medhodName.getString());
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case AWAIT: {
                Preconditions.checkState((boolean)context.isAsyncContext(), (Object)"await found within non-async function body");
                Preconditions.checkState((boolean)n.hasOneChild(), (String)"await should have 1 operand, but has %s", (int)n.getChildCount());
                parent.replaceChild(n, IR.yield(n.removeFirstChild()));
                break;
            }
        }
    }

    private void convertAsyncFunction(NodeTraversal t, LexicalContext functionContext) {
        Node originalFunction = (Node)Preconditions.checkNotNull((Object)functionContext.function);
        originalFunction.setIsAsyncFunction(false);
        Node originalBody = originalFunction.getLastChild();
        Node newBody = IR.block();
        originalFunction.replaceChild(originalBody, newBody);
        if (functionContext.mustAddAsyncThisVariable) {
            newBody.addChildToBack(IR.constNode(IR.name(ASYNC_THIS), IR.thisNode()));
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        if (functionContext.mustAddAsyncArgumentsVariable) {
            newBody.addChildToBack(IR.constNode(IR.name(ASYNC_ARGUMENTS), IR.name("arguments")));
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        for (String replacedMethodName : functionContext.replacedSuperProperties) {
            Node arrowFunction = IR.arrowFunction(IR.name(""), IR.paramList(), IR.getprop(IR.superNode(), IR.string(replacedMethodName)));
            this.compiler.reportChangeToChangeScope(arrowFunction);
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.ARROW_FUNCTIONS);
            String superReplacementName = ASYNC_SUPER_PROP_GETTER_PREFIX + replacedMethodName;
            newBody.addChildToBack(IR.constNode(IR.name(superReplacementName), arrowFunction));
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        if (!originalBody.isBlock()) {
            originalBody = IR.block(IR.returnNode(originalBody).useSourceInfoFrom(originalBody)).useSourceInfoFrom(originalBody);
        }
        Node generatorFunction = IR.function(IR.name(""), IR.paramList(), originalBody);
        generatorFunction.setIsGeneratorFunction(true);
        this.compiler.reportChangeToChangeScope(generatorFunction);
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.GENERATORS);
        newBody.addChildToBack(IR.returnNode(IR.call(IR.getprop(IR.name("$jscomp"), IR.string("asyncExecutePromiseGeneratorFunction")), generatorFunction)));
        newBody.useSourceInfoIfMissingFromForTree(originalBody);
        this.compiler.reportChangeToEnclosingScope(newBody);
    }

    private static final class LexicalContext {
        @Nullable
        final Node function;
        @Nullable
        final LexicalContext asyncThisAndArgumentsContext;
        final Set<String> replacedSuperProperties = new LinkedHashSet<String>();
        boolean mustAddAsyncThisVariable = false;
        boolean mustAddAsyncArgumentsVariable = false;

        LexicalContext() {
            this.function = null;
            this.asyncThisAndArgumentsContext = null;
        }

        LexicalContext(LexicalContext outer, Node function) {
            this.function = function;
            this.asyncThisAndArgumentsContext = function.isAsyncFunction() ? (function.isArrowFunction() ? (outer.asyncThisAndArgumentsContext == null ? this : outer.asyncThisAndArgumentsContext) : this) : (function.isArrowFunction() ? outer.asyncThisAndArgumentsContext : null);
        }

        boolean isAsyncContext() {
            return this.function.isAsyncFunction();
        }

        boolean mustReplaceThisAndArguments() {
            return this.asyncThisAndArgumentsContext != null;
        }

        void recordAsyncThisReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncThisVariable = true;
        }

        void recordAsyncSuperReplacementWasDone(String superFunctionName) {
            this.asyncThisAndArgumentsContext.replacedSuperProperties.add(superFunctionName);
        }

        void recordAsyncArgumentsReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncArgumentsVariable = true;
        }
    }
}

