/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

@Invariant(value={"content != null", "lineNumberMap == null || Iterables.all(lineNumberMap.keySet(), Predicates.between(1L, null))"})
public class SyntheticJavaFile
extends SimpleJavaFileObject {
    protected byte[] content;
    protected Map<Long, ?> lineNumberMap;

    @Requires(value={"name != null", "content != null"})
    public SyntheticJavaFile(String name, byte[] content, Map<Long, ?> lineNumberMap) {
        super(Elements.getUriForClass(name, JavaFileObject.Kind.SOURCE), JavaFileObject.Kind.SOURCE);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$SyntheticJavaFile(name, content, lineNumberMap);
                contractContext.leaveContract();
            }
            this.content = content;
            this.lineNumberMap = lineNumberMap;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == SyntheticJavaFile.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == SyntheticJavaFile.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$SyntheticJavaFile(String name, byte[] content, Map<Long, ?> lineNumberMap) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$SyntheticJavaFile$SyntheticJavaFile(name, content, lineNumberMap, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$util$SyntheticJavaFile();
    }

    @Override
    public InputStream openInputStream() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
            if (contractContext.tryEnterContract()) {
                ByteArrayInputStream byteArrayInputStream2;
                byteArrayInputStream = byteArrayInputStream2 = byteArrayInputStream;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public CharSequence getCharContent(boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = new String(this.content);
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public boolean delete() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.content = null;
            boolean bl2 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getSourceInfo(long l) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void lineNumber;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Object v0 = this.lineNumberMap == null ? null : this.lineNumberMap.get((long)lineNumber);
            if (contractContext.tryEnterContract()) {
                Object var5_4;
                v0 = var5_4 = v0;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return v0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={40L, 41L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$SyntheticJavaFile() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.content != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("content != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.lineNumberMap == null || Iterables.all(this.lineNumberMap.keySet(), Predicates.between(1L, null));
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("lineNumberMap == null || Iterables.all(lineNumberMap.keySet(), Predicates.between(1L, null))", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={58L, 59L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$SyntheticJavaFile$SyntheticJavaFile(String name, byte[] content, Map<Long, ?> lineNumberMap, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = content != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("content != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }
}

