/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class DebugUtils {
    private static String dumpDirectory;
    private static Map<String, Boolean> loggingEnabled;

    public DebugUtils() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result != null"})
    public static String getDumpDirectory() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            String string = dumpDirectory;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                DebugUtils.com$google$java$contract$QH$com$google$java$contract$core$util$DebugUtils$getDumpDirectory(string2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @Requires(value={"dir != null"})
    @Ensures(value={"getDumpDirectory().equals(dir)"})
    public static void setDumpDirectory(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            String dir;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$setDumpDirectory(string);
                contractContext.leaveContract();
            }
            dumpDirectory = dir;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$QH$com$google$java$contract$core$util$DebugUtils$setDumpDirectory(dir);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="setDumpDirectory")
    private static /* synthetic */ void com$google$java$contract$P$setDumpDirectory(String dir) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$setDumpDirectory(dir, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"name != null", "data != null", "kind != null"})
    public static void dump(String string, byte[] byArray, JavaFileObject.Kind kind) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            void kind2;
            String name;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$dump(string, byArray, kind);
                contractContext.leaveContract();
            }
            File f = new File(dumpDirectory + "/" + name + kind2.extension);
            DebugUtils.info("dump", "dumping file " + f);
            f.getParentFile().mkdirs();
            try {
                void data;
                FileOutputStream out = new FileOutputStream(f);
                ((OutputStream)out).write((byte[])data);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                DebugUtils.warn("dump", "while dumping " + f + ": " + e.getMessage());
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="dump")
    private static /* synthetic */ void com$google$java$contract$P$dump(String name, byte[] data, JavaFileObject.Kind kind) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$dump(name, data, kind, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"facility != null"})
    public static boolean isLoggingEnabled(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            String facility;
            Boolean enabled;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$isLoggingEnabled(string);
                contractContext.leaveContract();
            }
            if ((enabled = loggingEnabled.get(facility)) == null) {
                enabled = Boolean.valueOf(System.getProperty("com.google.java.contract.log." + facility, "false"));
                loggingEnabled.put(facility, enabled);
            }
            boolean bl2 = enabled;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="isLoggingEnabled")
    private static /* synthetic */ void com$google$java$contract$P$isLoggingEnabled(String facility) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$isLoggingEnabled(facility, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public static void contractInfo(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (DebugUtils.isLoggingEnabled("contract")) {
                String message;
                System.err.println("[com.google.java.contract:contract " + message + "]");
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"facility != null", "message != null"})
    public static void info(String string, String string2) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            String facility;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$info(string, string2);
                contractContext.leaveContract();
            }
            if (DebugUtils.isLoggingEnabled(facility)) {
                void message;
                System.err.println("[com.google.java.contract:" + facility + " " + (String)message + "]");
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="info")
    private static /* synthetic */ void com$google$java$contract$P$info(String facility, String message) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$info(facility, message, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"facility != null", "message != null"})
    public static void warn(String string, String string2) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            void message;
            String facility;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$warn(string, string2);
                contractContext.leaveContract();
            }
            System.err.println("[com.google.java.contract:" + facility + " " + (String)message + "]");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="warn")
    private static /* synthetic */ void com$google$java$contract$P$warn(String facility, String message) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$warn(facility, message, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"facility != null", "message != null"})
    public static void err(String string, String string2, Throwable throwable) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            void cause;
            void message;
            String facility;
            if (contractContext.tryEnterContract()) {
                DebugUtils.com$google$java$contract$P$err(string, string2, throwable);
                contractContext.leaveContract();
            }
            System.err.println("[com.google.java.contract:" + facility + " FATAL ERROR " + (String)message + (cause != null ? " (stack trace follows)" : "") + "]");
            if (cause != null) {
                cause.printStackTrace();
            } else {
                new Exception().printStackTrace();
            }
            System.exit(1);
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (throwable2 instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable3;
                throwable3 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable3;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="err")
    private static /* synthetic */ void com$google$java$contract$P$err(String facility, String message, Throwable cause) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = DebugUtils.com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$err(facility, message, cause, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(DebugUtils.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            dumpDirectory = "contracts_for_java.out";
            loggingEnabled = new HashMap<String, Boolean>();
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(DebugUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getDumpDirectory", lines={40L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$DebugUtils$getDumpDirectory(String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setDumpDirectory", lines={45L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$setDumpDirectory(String dir, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = dir != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("dir != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setDumpDirectory", lines={46L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$DebugUtils$setDumpDirectory(String dir) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = DebugUtils.getDumpDirectory().equals(dir);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getDumpDirectory().equals(dir)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="dump", lines={61L, 62L, 63L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$dump(String name, byte[] data, JavaFileObject.Kind kind, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = data != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("data != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="isLoggingEnabled", lines={79L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$isLoggingEnabled(String facility, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = facility != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("facility != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="info", lines={103L, 104L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$info(String facility, String message, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = facility != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("facility != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = message != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("message != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="warn", lines={114L, 115L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$warn(String facility, String message, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = facility != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("facility != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = message != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("message != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="err", lines={123L, 124L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$DebugUtils$err(String facility, String message, Throwable cause, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = facility != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("facility != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = message != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("message != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }
}

